/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.dna.tag.FastqReader;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class KeepSpecifiedReadsinFastqPlugin
extends AbstractPlugin {
    private final Logger myLogger = Logger.getLogger(KeepSpecifiedReadsinFastqPlugin.class);
    private static String FASTQ_FILENAME_REGEX = "(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$";
    private ArgsEngine myArgsEngine = null;
    private String[] myInputFastqFileNames = null;
    private String myOutputDir = null;
    private String myTOPMFilename = null;
    private String myKeyFilename = null;
    private String myEnzyme = null;
    private TOPMInterface myTOPM = null;
    private int[] myChrs;
    private int myStartPos;
    private int myEndPos;

    public KeepSpecifiedReadsinFastqPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        BufferedWriter writer = null;
        try {
            this.myTOPM = TOPMUtils.readTOPM(this.myTOPMFilename);
            for (int i = 0; i < this.myInputFastqFileNames.length; ++i) {
                this.myLogger.info((Object)("Processing Fastq: " + this.myInputFastqFileNames[i]));
                String outputFile = this.myOutputDir + "/" + Utils.getFilename(this.myInputFastqFileNames[i]);
                this.myLogger.info((Object)("Output Fastq: " + outputFile));
                writer = Utils.getBufferedWriter(outputFile);
                ParseBarcodeRead thePBR = this.getParseBarcodeRead(this.myInputFastqFileNames[i]);
                FastqReader reader = new FastqReader(this.myInputFastqFileNames[i]);
                String[] current = reader.getNext();
                while (current != null) {
                    int index;
                    ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(current[1], current[3], true, 0);
                    if (rr != null && (index = this.myTOPM.getTagIndex(rr.getRead())) >= 0) {
                        int chr = this.myTOPM.getChromosome(index);
                        int start = this.myTOPM.getStartPosition(index);
                        int end = this.myTOPM.getEndPosition(index);
                        if (this.isMatchingChr(chr) && (start >= this.myStartPos && start <= this.myEndPos || end >= this.myStartPos && end <= this.myEndPos)) {
                            writer.write(current[0]);
                            writer.write("\n");
                            writer.write(current[1]);
                            writer.write("\n");
                            writer.write(current[2]);
                            writer.write("\n");
                            writer.write(current[3]);
                            writer.write("\n");
                        }
                    }
                    current = reader.getNext();
                }
                writer.close();
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void printUsage() {
        this.myLogger.info((Object)"\nThe options for the KeepSpecifiedReadsinFastqPlugin:\n-input            Input directory containing fastq files\n-topm             TOPM\n-k                Key File\n-e                Enzyme\n-output           Output directory for resulting fastq files\n-chrs             Comma separated list of chromosomes. (no spaces)\n-startPosition    Start Position\n-endPosition      End Position\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-input", "-input", true);
            this.myArgsEngine.add("-topm", "-topm", true);
            this.myArgsEngine.add("-k", "-k", true);
            this.myArgsEngine.add("-e", "-e", true);
            this.myArgsEngine.add("-output", "-output", true);
            this.myArgsEngine.add("-chrs", "-chrs", true);
            this.myArgsEngine.add("-startPosition", "-startPosition", true);
            this.myArgsEngine.add("-endPosition", "-endPosition", true);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-input");
        if (tempDirectory != null && tempDirectory.length() != 0) {
            File inputDirectory = new File(tempDirectory);
            if (!inputDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.myInputFastqFileNames = DirectoryCrawler.listFileNames(FASTQ_FILENAME_REGEX, inputDirectory.getAbsolutePath());
            if (this.myInputFastqFileNames.length == 0 || this.myInputFastqFileNames == null) {
                this.printUsage();
                throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: No fastq files in: " + tempDirectory);
            }
            this.myLogger.info((Object)"setParameters: Using these fastq files:");
            for (String filename : this.myInputFastqFileNames) {
                this.myLogger.info((Object)("setParameters: found fastq: " + filename));
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: No input directory specified.");
        }
        this.myTOPMFilename = this.myArgsEngine.getString("-topm");
        if (this.myTOPMFilename == null || this.myTOPMFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: Must define TOPM");
        }
        File tempFile = new File(this.myTOPMFilename);
        if (!tempFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: The TOPM file doesn't exist: " + this.myTOPMFilename);
        }
        this.myKeyFilename = this.myArgsEngine.getString("-k");
        if (this.myKeyFilename == null || this.myKeyFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: Must define Key File");
        }
        tempFile = new File(this.myKeyFilename);
        if (!tempFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: The Key file doesn't exist: " + this.myKeyFilename);
        }
        this.myEnzyme = this.myArgsEngine.getString("-e");
        if (this.myEnzyme == null || this.myEnzyme.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: Must define TOPM");
        }
        this.myOutputDir = this.myArgsEngine.getString("-output");
        if (this.myOutputDir != null && this.myOutputDir.length() != 0) {
            File outputDirectory = new File(this.myOutputDir);
            if (!outputDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: The output name you supplied is not a directory: " + this.myOutputDir);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: No output directory specified.");
        }
        if (this.myOutputDir.equals(tempDirectory)) {
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: Output Directory should be different from Input Directory");
        }
        String tempChrs = this.myArgsEngine.getString("-chrs");
        if (tempChrs == null || tempChrs.length() == 0) {
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: No chromosomes specified.");
        }
        String[] tokenChrs = tempChrs.split(",");
        this.myChrs = new int[tokenChrs.length];
        for (int i = 0; i < tokenChrs.length; ++i) {
            try {
                this.myChrs[i] = Integer.parseInt(tokenChrs[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: chromosome not a number: " + tokenChrs[i]);
            }
        }
        String tempStart = this.myArgsEngine.getString("-startPosition");
        if (tempStart == null || tempStart.length() == 0) {
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: No Start Position specified.");
        }
        try {
            this.myStartPos = Integer.parseInt(tempStart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: Start Position not a number: " + tempStart);
        }
        String tempEnd = this.myArgsEngine.getString("-endPosition");
        if (tempEnd == null || tempEnd.length() == 0) {
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: No End Position specified.");
        }
        try {
            this.myEndPos = Integer.parseInt(tempEnd);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: End Position not a number: " + tempEnd);
        }
        if (this.myStartPos > this.myEndPos) {
            throw new IllegalArgumentException("KeepSpecifiedReadsinFastqPlugin: setParameters: Start Position: " + this.myStartPos + " can't be larger than End Position: " + this.myEndPos);
        }
    }

    private boolean isMatchingChr(int chr) {
        for (int i = 0; i < this.myChrs.length; ++i) {
            if (this.myChrs[i] != chr) continue;
            return true;
        }
        return false;
    }

    private ParseBarcodeRead getParseBarcodeRead(String fastqFile) {
        ParseBarcodeRead result;
        String[] np = Utils.getFilename(fastqFile).split("_");
        if (np.length == 3) {
            result = new ParseBarcodeRead(this.myKeyFilename, this.myEnzyme, np[0], np[1]);
        } else if (np.length == 5) {
            result = new ParseBarcodeRead(this.myKeyFilename, this.myEnzyme, np[1], np[3]);
        } else if (np.length == 4) {
            result = new ParseBarcodeRead(this.myKeyFilename, this.myEnzyme, np[0], np[2]);
        } else if (np.length == 6) {
            result = new ParseBarcodeRead(this.myKeyFilename, this.myEnzyme, np[1], np[3]);
        } else {
            this.myLogger.error((Object)"Error in parsing file name:");
            this.myLogger.error((Object)"   The filename does not contain either 3 or 5 underscore-delimited values.");
            this.myLogger.error((Object)"   Expect: flowcell_lane_fastq.txt OR code_flowcell_s_lane_fastq.txt");
            this.myLogger.error((Object)("   Filename: " + fastqFile));
            return null;
        }
        this.myLogger.info((Object)("Total barcodes found in lane:" + result.getBarCodeCount()));
        return result;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

