/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.TagCountMutable;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class KmerToTagCountPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(KmerToTagCountPlugin.class);
    String inputFile = null;
    int maxGoodReads = 200000000;
    int minCount = 1;
    int maxCount = 100;
    String outputFile = null;
    private static String nullS;

    public KmerToTagCountPlugin() {
        super(null, false);
    }

    public KmerToTagCountPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -i  Input file containing kmer files in fasta or gzipped fasta file.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.\n\n -s  Max good reads per file. (Optional. Default is 200,000,000).\n -cm  Minimum kmer depth (default is 1).\n -cM  Maximum kmer depth (default is 100).\n -o  Output .cnt files.\n\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        KmerToTagCountPlugin.countTags(this.inputFile, this.outputFile, this.maxGoodReads, this.minCount, this.maxCount);
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-i", "--input-file", true);
            this.engine.add("-s", "--max-reads", true);
            this.engine.add("-cM", "--max-count", true);
            this.engine.add("-cm", "--min-count", true);
            this.engine.add("-o", "--output-file", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the input kmer files.");
        }
        this.inputFile = this.engine.getString("-i");
        if (this.engine.getBoolean("-s")) {
            this.maxGoodReads = Integer.parseInt(this.engine.getString("-s"));
        }
        if (this.engine.getBoolean("-cm")) {
            this.minCount = Integer.parseInt(this.engine.getString("-cm"));
        }
        if (this.engine.getBoolean("-cM")) {
            this.maxCount = Integer.parseInt(this.engine.getString("-cM"));
        }
        this.outputFile = this.engine.getBoolean("-o") ? this.engine.getString("-o") : this.inputFile.substring(0, this.inputFile.indexOf(".")) + ".cnt";
    }

    public static void countTags(String myInput, String myOutput, int maxGoodReads, int minCount, int maxCount) {
        Object countFileNames = null;
        int allReads = 0;
        int goodBarcodedReads = 0;
        File myoutputFile = new File(myOutput);
        File myinputFile = new File(myInput);
        if (!myinputFile.isFile()) {
            System.out.println("Input file " + myInput + "\n" + " does not exists");
            return;
        }
        if (myoutputFile.isFile()) {
            System.out.println("An output file " + myOutput + "\n" + " already exists");
            return;
        }
        TagCountMutable theTC = null;
        System.out.println("Reading kmer file: " + myInput);
        try {
            String temp;
            BufferedReader br = myInput.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(myinputFile)))) : new BufferedReader(new FileReader(myinputFile), 65536);
            try {
                theTC = new TagCountMutable(2, maxGoodReads);
            }
            catch (OutOfMemoryError e) {
                System.out.println("Your system doesn't have enough memory to store the number of sequencesyou specified.  Try using a smaller value for the minimum number of reads.");
            }
            allReads = 0;
            long[] binary_s1 = new long[2];
            while ((temp = br.readLine()) != null && allReads < maxGoodReads) {
                ++allReads;
                int kmercount = Integer.parseInt(temp.replaceAll("[^\\d]", ""));
                String sl = br.readLine().trim();
                sl = sl + nullS;
                sl = sl.substring(0, 64);
                if (kmercount < minCount || kmercount > maxCount) continue;
                try {
                    binary_s1 = BaseEncoder.getLongArrayFromSeq(sl);
                    theTC.addReadCount(binary_s1, 31, kmercount);
                    if (allReads % 1000000 != 0) continue;
                    System.out.println("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads);
                }
                catch (NullPointerException e) {
                    System.out.println("Unable to correctly parse the sequence and quality score from fastq file.  Your fastq file may have been corrupted.");
                    System.exit(0);
                }
            }
            System.out.println("Total number of reads in lane=" + allReads);
            System.out.println("Timing process (sorting, collapsing, and writing TagCount to file).");
            timePoint1 = System.currentTimeMillis();
            theTC.collapseCounts();
            theTC.writeTagCountFile(myOutput, TagsByTaxa.FilePacking.Byte, minCount);
            System.out.println("Process took " + (System.currentTimeMillis() - timePoint1) + " milliseconds.");
            br.close();
        }
        catch (Exception e) {
            System.out.println("Catch testBasicPipeline c=" + goodBarcodedReads + " e=" + e);
            e.printStackTrace();
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        nullS = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }
}

