/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.DiscoverySNPCallerPlugin;
import net.maizegenetics.analysis.gbs.SNPLogging;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class MergeDuplicateSNPsPlugin
extends AbstractPlugin {
    private static Logger myLogger = Logger.getLogger(MergeDuplicateSNPsPlugin.class);
    private static ArgsEngine myArgsEngine = null;
    private String suppliedInputFileName;
    private String suppliedOutputFileName;
    private String infile;
    private String outfile;
    private String snpLogFileName;
    private SNPLogging snpLogging = null;
    private double maxMisMat = 0.05;
    private boolean usePedigree = false;
    private HashMap<String, Double> taxaFs = null;
    private boolean[] useTaxaForCompare = null;
    private int nInbredTaxa = Integer.MIN_VALUE;
    private boolean callHets = false;
    private boolean kpUnmergDups = false;
    private int startChr = 1;
    private int endChr = 10;
    private INPUT_FORMAT inputFormat = INPUT_FORMAT.hapmap;
    private int myMaxNumAlleles;

    public MergeDuplicateSNPsPlugin() {
        super(null, false);
    }

    public MergeDuplicateSNPsPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        myLogger.info((Object)("\n\nUsage is as follows:\n-hmp           Input GBS genotype file (in HapMap format). Use a plus sign (+) as a wild card character to specify multiple chromosome numbers.\n-vcf           Input GBS genotype file (in VCF format). Use a plus sign (+) as a wild card character to specify multiple chromosome numbers. Options -hmp and -vcf are mutual exclusive.\n-o             Output HapMap file. Use a plus sign (+) as a wild card character to specify multiple chromosome numbers.\n-misMat        Threshold genotypic mismatch rate above which the duplicate SNPs won't be merged (default: " + this.maxMisMat + ")\n" + "-p             Pedigree file containing full sample names (or expected names after merging) & expected inbreeding\n" + "                 coefficient (F) for each.  Only highly inbred taxa, with F >= 0.8 (e.g., S3 or more), will be used\n" + "                 to test if two duplicate SNPs agree with each other (default: use ALL taxa to compare duplicate SNPs)\n" + "-callHets      When two genotypes disagree at a SNP, call it a heterozygote (default: " + this.callHets + " = set to missing)\n" + "-kpUnmergDups  When two duplicate SNPs were not merged (different alleles or too many mismatches), keep them (default: " + this.kpUnmergDups + " = delete them)\n" + "-sC             Start chromosome\n" + "-eC             End chromosome\n" + "-maxAlleleVCF   Maximum number of alleles allowed in vcf file.\n" + "-snpLog        SNPs Removed Log file name\n\n"));
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (myArgsEngine == null) {
            myArgsEngine = new ArgsEngine();
            myArgsEngine.add("-hmp", "--hmpFile", true);
            myArgsEngine.add("-vcf", "--vcfFile", true);
            myArgsEngine.add("-o", "--outFile", true);
            myArgsEngine.add("-misMat", "--maxMismatchRate", true);
            myArgsEngine.add("-p", "--pedigree-file", true);
            myArgsEngine.add("-callHets", "--callHeterozygotes", false);
            myArgsEngine.add("-kpUnmergDups", "--keepUnmergedDuplicates", false);
            myArgsEngine.add("-sC", "--startChromosome", true);
            myArgsEngine.add("-eC", "--endChromosome", true);
            myArgsEngine.add("-maxAlleleVCF", "--maxAlleleVCF", true);
            myArgsEngine.add("-snpLog", "", true);
        }
        myArgsEngine.parse(args);
        if (myArgsEngine.getBoolean("-hmp")) {
            if (myArgsEngine.getBoolean("-vcf")) {
                throw new IllegalArgumentException("-hmp and -vcf options are mutual exclusive!\n");
            }
            this.suppliedInputFileName = myArgsEngine.getString("-hmp");
            this.inputFormat = INPUT_FORMAT.hapmap;
        } else if (myArgsEngine.getBoolean("-vcf")) {
            this.suppliedInputFileName = myArgsEngine.getString("-vcf");
            this.inputFormat = INPUT_FORMAT.vcf;
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a HapMap or vcf file to filter.\n");
        }
        if (!myArgsEngine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output file name.\n");
        }
        this.suppliedOutputFileName = myArgsEngine.getString("-o");
        if (myArgsEngine.getBoolean("-misMat")) {
            this.maxMisMat = Double.parseDouble(myArgsEngine.getString("-misMat"));
        }
        if (myArgsEngine.getBoolean("-p")) {
            String pedigreeFileStr = myArgsEngine.getString("-p");
            File pedigreeFile = new File(pedigreeFileStr);
            if (!pedigreeFile.exists() || !pedigreeFile.isFile()) {
                this.printUsage();
                throw new IllegalArgumentException("Can't find the pedigree input file (-p option: " + pedigreeFileStr + ").");
            }
            this.taxaFs = DiscoverySNPCallerPlugin.readTaxaFsFromFile(pedigreeFile);
            if (this.taxaFs == null) {
                throw new IllegalArgumentException("Problem reading the pedigree file. Progam aborted.");
            }
            this.usePedigree = true;
        }
        if (myArgsEngine.getBoolean("-callHets")) {
            this.callHets = true;
        }
        if (myArgsEngine.getBoolean("-kpUnmergDups")) {
            this.kpUnmergDups = true;
        }
        if (myArgsEngine.getBoolean("-sC")) {
            this.startChr = Integer.parseInt(myArgsEngine.getString("-sC"));
        }
        if (myArgsEngine.getBoolean("-eC")) {
            this.endChr = Integer.parseInt(myArgsEngine.getString("-eC"));
        }
        if (this.endChr - this.startChr < 0) {
            this.printUsage();
            throw new IllegalArgumentException("Error: The start chromosome is higher than the end chromosome.");
        }
        if (myArgsEngine.getBoolean("-snpLog")) {
            this.snpLogFileName = myArgsEngine.getString("-snpLog");
        }
        if (myArgsEngine.getBoolean("-maxAlleleVCF")) {
            if (!myArgsEngine.getBoolean("-vcf")) {
                throw new IllegalArgumentException("-maxAlleleVCF option only works with -vcf input.\n");
            }
            this.myMaxNumAlleles = Integer.parseInt(myArgsEngine.getString("-maxAlleleVCF"));
        } else {
            this.myMaxNumAlleles = 3;
        }
        this.snpLogging = new SNPLogging(this.snpLogFileName, this.getClass());
    }

    @Override
    public DataSet performFunction(DataSet input) {
        for (int chr = this.startChr; chr <= this.endChr; ++chr) {
            GenotypeTable a;
            this.infile = this.suppliedInputFileName.replace("+", "" + chr);
            this.outfile = this.suppliedOutputFileName.replace("+", "" + chr);
            myLogger.info((Object)("Reading: " + this.infile));
            try {
                if (this.inputFormat == INPUT_FORMAT.hapmap) {
                    a = ImportUtils.readFromHapmap(this.infile, this);
                } else if (this.inputFormat == INPUT_FORMAT.vcf) {
                    a = ImportUtils.readFromVCF(this.infile, this, true);
                } else {
                    throw new IllegalArgumentException("File format " + (Object)((Object)this.inputFormat) + " is not recognized!");
                }
                myLogger.info((Object)("Original Alignment  Taxa:" + a.numberOfTaxa() + " Sites:" + a.numberOfSites()));
                if (this.usePedigree && !this.maskNonInbredTaxa(a)) {
                    throw new IllegalArgumentException("Mismatch between taxa names in the input hapmap and pedigree files.");
                }
            }
            catch (Exception e) {
                myLogger.info((Object)("Could not read input hapmap file for chr" + chr + ":\n\t" + this.infile + "\n\te: " + e + "\n\tSkipping..."));
                continue;
            }
            GenotypeCallTableBuilder msa = GenotypeCallTableBuilder.getInstance(a.numberOfTaxa(), a.numberOfSites());
            PositionListBuilder posBuilder = new PositionListBuilder();
            ArrayList<Integer> samePosAL = new ArrayList<Integer>();
            Integer[] samePos = null;
            int currentPos = a.chromosomalPosition(0);
            for (int s = 0; s < a.numberOfSites(); ++s) {
                int newPos = a.chromosomalPosition(s);
                if (newPos == currentPos) {
                    samePosAL.add(s);
                    continue;
                }
                samePos = samePosAL.toArray(new Integer[samePosAL.size()]);
                if (samePosAL.size() > 1) {
                    if (this.inputFormat == INPUT_FORMAT.hapmap) {
                        this.processSNPsWithSamePosition(samePos, a, chr, currentPos, msa, posBuilder);
                    }
                } else {
                    byte[] genos = new byte[a.numberOfTaxa()];
                    for (int t = 0; t < a.numberOfTaxa(); ++t) {
                        genos[t] = a.genotype(t, samePos[0]);
                    }
                    this.addSiteToMutableAlignment(chr, currentPos, genos, msa, posBuilder);
                }
                samePosAL = new ArrayList();
                samePosAL.add(s);
                currentPos = newPos;
            }
            samePos = samePosAL.toArray(new Integer[samePosAL.size()]);
            if (samePosAL.size() > 1) {
                if (this.inputFormat == INPUT_FORMAT.hapmap) {
                    this.processSNPsWithSamePosition(samePos, a, chr, currentPos, msa, posBuilder);
                }
            } else {
                byte[] genos = new byte[a.numberOfTaxa()];
                for (int t = 0; t < a.numberOfTaxa(); ++t) {
                    genos[t] = a.genotype(t, samePos[0]);
                }
                this.addSiteToMutableAlignment(chr, currentPos, genos, msa, posBuilder);
            }
            if (!posBuilder.validateOrdering()) {
                System.err.println("Error in order of merged SNPs");
                throw new UnsupportedOperationException("SNP order cannot change in TASSEL5.  Is this a problem?");
            }
            myLogger.info((Object)("Number of sites written after merging duplicate SNPs: " + posBuilder.size()));
            if (this.inputFormat != INPUT_FORMAT.hapmap) continue;
            if (!this.kpUnmergDups) {
                throw new UnsupportedOperationException("kpUnmergDups is not supported in TASSEL 5.  Is this a problem?");
            }
            GenotypeTable aOut = GenotypeTableBuilder.getInstance(msa.build(), posBuilder.build(), a.taxa());
            ExportUtils.writeToHapmap(aOut, false, this.outfile, '\t', this);
        }
        return null;
    }

    private void processSNPsWithSamePosition(Integer[] samePos, GenotypeTable a, int chr, int currentPos, GenotypeCallTableBuilder msa, PositionListBuilder posBuild) {
        boolean[] finished = new boolean[samePos.length];
        for (int i = 0; i < finished.length; ++i) {
            finished[i] = false;
        }
        for (int s1 = 0; s1 < samePos.length - 1; ++s1) {
            if (finished[s1]) continue;
            byte[] currMerge = new byte[a.numberOfTaxa()];
            for (int t = 0; t < a.numberOfTaxa(); ++t) {
                currMerge[t] = a.genotype(t, samePos[s1]);
            }
            byte[] currAlleles = new byte[]{a.majorAllele(samePos[s1]), a.minorAllele(samePos[s1])};
            if (currAlleles[0] == 5 || currAlleles[1] == 5) {
                this.addSiteToMutableAlignment(chr, currentPos, currMerge, msa, posBuild);
                finished[s1] = true;
                continue;
            }
            Arrays.sort(currAlleles);
            for (int s2 = s1 + 1; s2 < samePos.length; ++s2) {
                int t;
                if (finished[s2]) continue;
                byte[] newAlleles = new byte[]{a.majorAllele(samePos[s2]), a.minorAllele(samePos[s2])};
                Arrays.sort(newAlleles);
                if (newAlleles[0] == 5 || newAlleles[1] == 5 || !Arrays.equals(currAlleles, newAlleles)) continue;
                int nMismatch = 0;
                int nCompare = 0;
                byte[] possibleMerge = new byte[a.numberOfTaxa()];
                for (t = 0; t < a.numberOfTaxa(); ++t) {
                    byte geno2 = a.genotype(t, samePos[s2]);
                    if (currMerge[t] != -1 && geno2 != -1) {
                        if (!this.usePedigree || this.useTaxaForCompare[t]) {
                            ++nCompare;
                        }
                        if (!GenotypeTableUtils.isEqual(currMerge[t], geno2)) {
                            if (!this.usePedigree || this.useTaxaForCompare[t]) {
                                ++nMismatch;
                            }
                            try {
                                possibleMerge[t] = this.callHets ? (int)MergeDuplicateSNPsPlugin.resolveHet(currMerge[t], geno2) : -1;
                            }
                            catch (Exception e) {
                                myLogger.warn((Object)("Invalid genotypes (" + a.genotypeAsString(t, samePos[s1]) + " and " + a.genotypeAsString(t, samePos[s2]) + ") at position:" + currentPos + " taxon:" + a.taxaName(t)));
                            }
                            continue;
                        }
                        possibleMerge[t] = currMerge[t];
                        continue;
                    }
                    if (currMerge[t] == -1) {
                        possibleMerge[t] = geno2;
                        continue;
                    }
                    if (geno2 != -1) continue;
                    possibleMerge[t] = currMerge[t];
                }
                if (nCompare != 0 && !((double)nMismatch / (double)nCompare <= this.maxMisMat)) continue;
                for (t = 0; t < a.numberOfTaxa(); ++t) {
                    currMerge[t] = possibleMerge[t];
                }
                double valueMisMat = Double.NaN;
                if (nCompare != 0) {
                    valueMisMat = (double)nMismatch / (double)nCompare;
                }
                this.snpLogging.writeEntry(a, samePos[s2], null, null, "Genotypes Less Max Mismatch", "Merged", String.valueOf(valueMisMat), String.valueOf(this.maxMisMat));
                finished[s2] = true;
            }
            this.addSiteToMutableAlignment(chr, currentPos, currMerge, msa, posBuild);
            finished[s1] = true;
        }
        for (int site = 0; site < finished.length; ++site) {
            if (finished[site]) continue;
            byte[] genos = new byte[a.numberOfTaxa()];
            for (int t = 0; t < a.numberOfTaxa(); ++t) {
                genos[t] = a.genotype(t, samePos[site]);
            }
            this.addSiteToMutableAlignment(chr, currentPos, genos, msa, posBuild);
        }
    }

    private void addSiteToMutableAlignment(int chromosome, int position, byte[] genos, GenotypeCallTableBuilder theMSA, PositionListBuilder posBuilder) {
        int currSite = posBuilder.size();
        posBuilder.add(new GeneralPosition.Builder(new Chromosome(String.valueOf(chromosome)), position).build());
        for (int tx = 0; tx < genos.length; ++tx) {
            theMSA.setBase(tx, currSite, genos[tx]);
        }
    }

    private boolean maskNonInbredTaxa(GenotypeTable a) {
        this.useTaxaForCompare = new boolean[a.numberOfTaxa()];
        this.nInbredTaxa = 0;
        try {
            for (int taxon = 0; taxon < a.numberOfTaxa(); ++taxon) {
                if (this.taxaFs.containsKey(a.taxaName(taxon))) {
                    if (!(this.taxaFs.get(a.taxaName(taxon)) >= 0.8)) continue;
                    this.useTaxaForCompare[taxon] = true;
                    ++this.nInbredTaxa;
                    continue;
                }
                if (a.taxaName(taxon).contentEquals("REFERENCE_GENOME")) {
                    this.useTaxaForCompare[taxon] = false;
                    continue;
                }
                throw new Exception("Taxon " + a.taxaName(taxon) + " not found in the pedigree file");
            }
            myLogger.info((Object)(this.nInbredTaxa + " highly inbred taxa (with an expected F >= 0.8) were found in the input hapmap file (according to the pedigree file)"));
            return true;
        }
        catch (Exception e) {
            myLogger.error((Object)("Mismatch between taxa names in the input hapmap file and the pedigree file e=" + e));
            e.printStackTrace();
            return false;
        }
    }

    private static byte resolveHet(byte geno1, byte geno2) {
        byte[] result = new byte[2];
        result[0] = (byte)(geno1 >>> 4);
        byte temp = (byte)(geno1 & 0xF);
        int count = 1;
        if (temp != result[0]) {
            result[count++] = temp;
        }
        if ((temp = (byte)(geno2 >>> 4)) != result[0]) {
            if (count == 1) {
                result[count++] = temp;
            } else if (temp != result[1]) {
                throw new IllegalStateException();
            }
        }
        if ((temp = (byte)(geno2 & 0xF)) != result[0]) {
            if (count == 1) {
                result[count++] = temp;
            } else if (temp != result[1]) {
                throw new IllegalStateException();
            }
        }
        return (byte)(result[0] << 4 | result[1]);
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static enum INPUT_FORMAT {
        hapmap,
        vcf;

    }
}

