/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractTags;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import org.apache.log4j.Logger;

public class MergeMultipleTagCountPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeMultipleTagCountPlugin.class);
    PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing .cnt files.").build();
    PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().description("Output file name.").build();
    PluginParameter<Integer> myMinCount = new PluginParameter.Builder<Integer>("c", Integer.valueOf(1), Integer.class).guiName("Min Count").description("Minimum count of reads to be output.").build();
    PluginParameter<Boolean> myIsTextOutput = new PluginParameter.Builder<Boolean>("t", Boolean.valueOf(false), Boolean.class).guiName("Text Output").description("Specifies that reads should be output in FASTQ text format.").build();
    private long[][] myCtags;
    private int[] myCtagCnt;
    private byte[] myCtagLength;
    private int[] myChunkTagSizes;
    private int myTagLengthInLong = 2;
    private int myNumTagsRead = 0;
    private int myOutCnt = 0;
    private int myNumInputStreamsOpen = 0;
    private DataInputStream[] myInputStreams;
    private DataOutputStream myOutStream;

    public MergeMultipleTagCountPlugin() {
        super(null, false);
    }

    public MergeMultipleTagCountPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        String[] inputFileNames = DirectoryCrawler.listFileNames(".*\\.cnt", this.inputDirectory());
        if (inputFileNames == null || inputFileNames.length == 0) {
            throw new IllegalArgumentException("Couldn't find any files ending in \".cnt\" in the directory you specified: " + this.inputDirectory());
        }
        myLogger.info((Object)"Merging the following .cnt files...");
        for (String filename : inputFileNames) {
            myLogger.info((Object)filename);
        }
        myLogger.info((Object)("...to \"" + this.outputFile() + "\"."));
        this.mergeChunks(inputFileNames, this.outputFile(), this.minCount());
        return null;
    }

    public void mergeChunks(String[] chunkFileNames, String outputFileName, int minCount) {
        this.myInputStreams = new DataInputStream[chunkFileNames.length];
        this.myChunkTagSizes = new int[this.myInputStreams.length];
        this.myCtagCnt = new int[this.myInputStreams.length];
        this.myCtagLength = new byte[this.myInputStreams.length];
        this.myNumInputStreamsOpen = this.myInputStreams.length;
        try {
            for (int f = 0; f < this.myInputStreams.length; ++f) {
                String infile = chunkFileNames[f];
                this.myInputStreams[f] = new DataInputStream(new BufferedInputStream(new FileInputStream(infile), 4000000));
                this.myChunkTagSizes[f] = this.myInputStreams[f].readInt();
                this.myTagLengthInLong = this.myInputStreams[f].readInt();
                myLogger.info((Object)("Opened :" + infile + " tags=" + this.myChunkTagSizes[f]));
            }
            this.myOutStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFileName + ".fq"), 655360));
            this.myCtags = new long[this.myInputStreams.length][this.myTagLengthInLong];
            this.outStack("B:");
            int t = 0;
            while (this.myNumInputStreamsOpen > 0) {
                long[] minTag = this.updateCurrentTags();
                if (this.textOutput().booleanValue()) {
                    this.writeFASTQ(minTag, minCount);
                } else {
                    this.writeTags(minTag, minCount);
                }
                if (t % 1000000 == 0) {
                    System.out.printf("t=%d tagsRead=%d outCnt=%d rwOpen=%d %n", t, this.myNumTagsRead, this.myOutCnt, this.myNumInputStreamsOpen);
                    this.outStack("A:" + t);
                    myLogger.info((Object)BaseEncoder.getSequenceFromLong(minTag));
                }
                ++t;
            }
            this.myOutStream.flush();
            this.myOutStream.close();
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in reading TagCount file e=" + e));
            e.printStackTrace();
        }
        if (!this.textOutput().booleanValue()) {
            MergeMultipleTagCountPlugin.prependHeader(outputFileName, this.myOutCnt, this.myTagLengthInLong);
        }
    }

    private void outStack(String prefix) {
        myLogger.info((Object)(prefix + ":"));
        for (int f = 0; f < this.myInputStreams.length; ++f) {
            myLogger.info((Object)(this.myCtags[f][0] + ":"));
        }
        myLogger.info((Object)"");
    }

    private void writeTags(long[] writeTag, int minCount) {
        int count = 0;
        int tagLength = -1;
        for (int f = 0; f < this.myInputStreams.length; ++f) {
            if (AbstractTags.compareTags(this.myCtags[f], writeTag) != 0) continue;
            count += this.myCtagCnt[f];
            tagLength = this.myCtagLength[f];
            for (int j = 0; j < this.myTagLengthInLong; ++j) {
                this.myCtags[f][j] = 0L;
            }
        }
        if (count >= minCount) {
            ++this.myOutCnt;
        } else {
            return;
        }
        try {
            for (int i = 0; i < this.myTagLengthInLong; ++i) {
                long test1 = writeTag[i];
                this.myOutStream.writeLong(test1);
            }
            byte test2 = (byte)tagLength;
            int test3 = count;
            this.myOutStream.writeByte(test2);
            this.myOutStream.writeInt(test3);
            if (count == 0) {
                myLogger.info((Object)"");
            }
        }
        catch (IOException e) {
            myLogger.info((Object)("Catch in writing TagCount file e=" + e));
            e.printStackTrace();
        }
    }

    private void writeFASTQ(long[] writeTag, int minCount) {
        int count = 0;
        int tagLength = -1;
        String tagSequence = "";
        for (int f = 0; f < this.myInputStreams.length; ++f) {
            if (AbstractTags.compareTags(this.myCtags[f], writeTag) != 0) continue;
            count += this.myCtagCnt[f];
            tagLength = this.myCtagLength[f];
            for (int j = 0; j < this.myTagLengthInLong; ++j) {
                this.myCtags[f][j] = 0L;
            }
        }
        if (count >= minCount) {
            ++this.myOutCnt;
        } else {
            return;
        }
        try {
            this.myOutStream.writeBytes("@length=" + tagLength + "count=" + count + "\n");
            tagSequence = BaseEncoder.getSequenceFromLong(writeTag);
            tagSequence = tagSequence.substring(0, tagLength);
            this.myOutStream.writeBytes(tagSequence + "\n+\n");
            for (int i = 0; i < tagLength; ++i) {
                this.myOutStream.writeBytes("f");
            }
            this.myOutStream.writeBytes("\n");
        }
        catch (IOException e) {
            myLogger.info((Object)("Catch in writing TagCount file e=" + e));
            e.printStackTrace();
        }
    }

    private static void prependHeader(String fileName, int tagCount, int tagLengthInLong) {
        myLogger.info((Object)("Adding header to " + fileName + "."));
        File inputFile = new File(fileName + ".fq");
        File outputFile = new File(fileName);
        int tagsWritten = 0;
        try {
            DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile), 4000000));
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 65536));
            output.writeInt(tagCount);
            output.writeInt(tagLengthInLong);
            for (int i = 0; i < tagCount; ++i) {
                for (int j = 0; j < tagLengthInLong; ++j) {
                    output.writeLong(input.readLong());
                }
                output.writeByte(input.readByte());
                output.writeInt(input.readInt());
                if (++tagsWritten % 1000000 != 0) continue;
                myLogger.info((Object)("Wrote " + tagsWritten + " records."));
            }
            input.close();
            output.close();
            if (!inputFile.delete()) {
                myLogger.info((Object)("WARNING: Failure to delete file:\n\t" + inputFile.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            myLogger.info((Object)("Caught exception while prepending read count to read count file: " + e));
            e.printStackTrace();
        }
    }

    private long[] updateCurrentTags() {
        long[] minTag = new long[this.myTagLengthInLong];
        minTag[0] = Long.MAX_VALUE;
        for (int f = 0; f < this.myInputStreams.length; ++f) {
            if (this.myCtags[f][0] == 0L) {
                this.readNextTag(f);
            }
            if (AbstractTags.compareTags(this.myCtags[f], minTag) >= 0) continue;
            minTag = (long[])this.myCtags[f].clone();
        }
        return minTag;
    }

    private void readNextTag(int f) {
        if (this.myInputStreams[f] == null) {
            return;
        }
        try {
            for (int j = 0; j < this.myTagLengthInLong; ++j) {
                this.myCtags[f][j] = this.myInputStreams[f].readLong();
            }
            this.myCtagLength[f] = this.myInputStreams[f].readByte();
            this.myCtagCnt[f] = this.myInputStreams[f].readInt();
            ++this.myNumTagsRead;
        }
        catch (IOException eof) {
            try {
                myLogger.info((Object)("Finished reading file " + f + "."));
                this.myInputStreams[f].close();
                this.myInputStreams[f] = null;
                for (int i = 0; i < this.myTagLengthInLong; ++i) {
                    this.myCtags[f][i] = Long.MAX_VALUE;
                }
                --this.myNumInputStreamsOpen;
            }
            catch (IOException eof2) {
                myLogger.info((Object)("Catch closing" + eof2));
                this.myInputStreams[f] = null;
            }
        }
    }

    public String inputDirectory() {
        return this.myInputDir.value();
    }

    public MergeMultipleTagCountPlugin inputDirectory(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public MergeMultipleTagCountPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public Integer minCount() {
        return this.myMinCount.value();
    }

    public MergeMultipleTagCountPlugin minCount(Integer value) {
        this.myMinCount = new PluginParameter<Integer>(this.myMinCount, value);
        return this;
    }

    public Boolean textOutput() {
        return this.myIsTextOutput.value();
    }

    public MergeMultipleTagCountPlugin textOutput(Boolean value) {
        this.myIsTextOutput = new PluginParameter<Boolean>(this.myIsTextOutput, value);
        return this;
    }

    @Override
    public String getToolTipText() {
        return "Merge Multiple Tag Count Files";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Merge Multiple Tag Count Files";
    }
}

