/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public final class SAMConverterPlugin
extends AbstractPlugin {
    boolean cleanCutSites = true;
    private static final Logger myLogger = Logger.getLogger(SAMConverterPlugin.class);
    private PluginParameter<String> myInputFile = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input File").required(true).inFile().description("Name of input file in SAM text format").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().description("Name of output file (Default: output.topm.bin)").build();
    private PluginParameter<Integer> myTagLengthInNumLongs = new PluginParameter.Builder<Integer>("l", Integer.valueOf(2), Integer.class).guiName("Tag Length").description("tag length in integer multiples of 32 bases").build();
    private PluginParameter<Boolean> myTextOutputFormat = new PluginParameter.Builder<Boolean>("t", Boolean.valueOf(false), Boolean.class).guiName("Text Output Format").description("Specifies text output format").build();

    public SAMConverterPlugin() {
        super(null, false);
    }

    public SAMConverterPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void postProcessParameters() {
        if ((this.outputFile() == null || this.outputFile().length() == 0) && this.inputFile() != null) {
            this.outputFile(Utils.getDirectory(this.inputFile()) + File.separator + "output.topm.bin");
        }
        if (this.textOutputFormat() && this.outputFile() != null) {
            this.outputFile(this.outputFile().replace(".bin", ".txt"));
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        TagsOnPhysicalMap topm = new TagsOnPhysicalMap();
        topm.readSAMFile(this.inputFile(), this.tagLength());
        topm.sort();
        try {
            if (this.textOutputFormat()) {
                topm.writeTextFile(new File(this.outputFile()));
            } else {
                topm.writeBinaryFile(new File(this.outputFile()));
            }
        }
        catch (Exception e) {
            System.out.println("Catch in writing binary topm file: " + e);
        }
        this.writeLogFile(topm);
        return null;
    }

    private void writeLogFile(TagsOnPhysicalMap topm) {
        try {
            DataOutputStream report = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile() + ".log"), 65536));
            int[] aligned = topm.mappedTags();
            int unique = 0;
            int multi = 1;
            int unaligned = topm.getTagCount() - aligned[unique] - aligned[multi];
            report.writeBytes("Input file: " + this.inputFile() + "\n" + "Output file: " + this.outputFile() + "\n" + "Total " + topm.getTagCount() + " tags\n\t" + aligned[unique] + " were aligned to unique postions\n\t" + aligned[multi] + " were aligned to multiple postions\n\t" + unaligned + " could not be aligned.\n\n");
            int[] dist = topm.mappingDistribution();
            report.writeBytes("nPositions  nTags\n");
            for (int i = 0; i < dist.length; ++i) {
                if (dist[i] <= 0) continue;
                if (i < 10) {
                    report.writeBytes(i + "           " + dist[i] + "\n");
                    continue;
                }
                if (i < 100) {
                    report.writeBytes(i + "          " + dist[i] + "\n");
                    continue;
                }
                if (i >= 1000) continue;
                report.writeBytes(i + "         " + dist[i] + "\n");
            }
            report.close();
        }
        catch (Exception e) {
            myLogger.warn((Object)("Caught exception while writing log file: " + e));
        }
    }

    public String inputFile() {
        return this.myInputFile.value();
    }

    public SAMConverterPlugin inputFile(String value) {
        this.myInputFile = new PluginParameter<String>(this.myInputFile, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public SAMConverterPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public boolean textOutputFormat() {
        return this.myTextOutputFormat.value();
    }

    public SAMConverterPlugin textOutputFormat(boolean value) {
        this.myTextOutputFormat = new PluginParameter<Boolean>(this.myTextOutputFormat, value);
        return this;
    }

    public int tagLength() {
        return this.myTagLengthInNumLongs.value();
    }

    public SAMConverterPlugin tagLength(int value) {
        this.myTagLengthInNumLongs = new PluginParameter<Integer>(this.myTagLengthInNumLongs, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "SAM to TOPM Converter";
    }

    @Override
    public String getToolTipText() {
        return "SAM to TOPM Converter";
    }
}

