/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.UNetworkFilter;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class UTagCountToTagPairPlugin
extends AbstractPlugin {
    private static final Logger logger = Logger.getLogger(UTagCountToTagPairPlugin.class);
    private PluginParameter<Double> errorTolerance = new PluginParameter.Builder<Double>("errorTolerance", Double.valueOf(0.03), Double.class).description("What fraction of errors to tolerate when filtering by UNEAK").required(false).guiName("Error tolerance").build();
    private PluginParameter<String> infile = new PluginParameter.Builder<String>("inputFile", null, String.class).required(true).inFile().guiName("Input file").description("Input file of merged tag counts").build();
    private PluginParameter<String> outfile = new PluginParameter.Builder<String>("outputFile", null, String.class).required(true).outFile().guiName("Output file").description("Output file of matched tag pairs").build();

    public UTagCountToTagPairPlugin() {
        super(null, false);
    }

    public UTagCountToTagPairPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        String mergedTagCountOfAllS = new File(this.inputFile()).getAbsolutePath();
        String tagPairS = new File(this.outputFile()).getAbsolutePath();
        UNetworkFilter unf = new UNetworkFilter(mergedTagCountOfAllS, this.errorTolerance(), tagPairS);
        return null;
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes a set of merged tag counts from the TASSEL GBS pipeline and converts it into a set of tag pairs according to the UNEAK filter (see citation). This plugin is intended for GBS with organisms that lack a reference genome.";
    }

    @Override
    public String getCitation() {
        return "Lu F, Lipka AE, Elshire RJ, Glaubitz JC, Cherney JH, Casler MD, Buckler ES, Costich DE. (2013) Switchgrass genomic diversity, ploidy and evolution: novel insights from a network-based SNP discovery protocol. PLoS Genetics 9(1):e1003215.";
    }

    public UTagCountToTagPairPlugin inputFile(String filename) {
        this.setParameter(this.infile.cmdLineName(), filename);
        return this;
    }

    public UTagCountToTagPairPlugin outputFile(String filename) {
        this.setParameter(this.outfile.cmdLineName(), filename);
        return this;
    }

    public UTagCountToTagPairPlugin errorTolerance(Double value) {
        this.setParameter(this.errorTolerance.cmdLineName(), (Comparable)value);
        return this;
    }

    public String inputFile() {
        return this.infile.value();
    }

    public String outputFile() {
        return this.outfile.value();
    }

    public double errorTolerance() {
        return this.errorTolerance.value();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Tag Counts to Tag Pairs";
    }

    @Override
    public String getToolTipText() {
        return "Tag Counts to Tag Pairs";
    }
}

