/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.NucleotideImputationUtils;
import net.maizegenetics.analysis.imputation.PopulationData;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.CombineGenotypeTable;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.PluginEvent;
import org.apache.log4j.Logger;

public class WritePopulationAlignmentPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(WritePopulationAlignmentPlugin.class);
    boolean mergeAlignments = true;
    boolean writeParentCalls = true;
    boolean writeNucleotides = true;
    boolean outputDiploid = false;
    double minSnpCoverage = 0.1;
    double maxMafForMono = 0.01;
    String baseFileName;

    public WritePopulationAlignmentPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        List<Datum> theData = input.getDataOfType(PopulationData.class);
        if (theData.size() > 0) {
            if (this.writeParentCalls) {
                this.writeOutput(theData, false);
            }
            if (this.writeNucleotides) {
                this.writeOutput(theData, true);
            }
            this.fireDataSetReturned(new PluginEvent(input, input.getCreator().getClass()));
            return input;
        }
        return null;
    }

    private void writeOutput(List<Datum> theData, boolean asNucleotides) {
        if (this.mergeAlignments) {
            String filename = asNucleotides ? this.baseFileName + "nuc.hmp.txt" : this.baseFileName + "parents.hmp.txt";
            GenotypeTable[] allOfTheAlignments = new GenotypeTable[theData.size()];
            int count = 0;
            for (Datum datum : theData) {
                PopulationData family = (PopulationData)datum.getData();
                allOfTheAlignments[count++] = this.createOutputAlignment(family, asNucleotides);
            }
            GenotypeTable alignment = CombineGenotypeTable.getInstance(allOfTheAlignments, true);
            ExportUtils.writeToHapmap(alignment, this.outputDiploid, filename, '\t', null);
        } else {
            for (Datum datum : theData) {
                PopulationData family = (PopulationData)datum.getData();
                String familyName = family.name.replace('/', '.');
                String filename = asNucleotides ? this.baseFileName + ".family." + familyName + "nuc.hmp.txt" : this.baseFileName + ".family." + familyName + "parents.hmp.txt";
                ExportUtils.writeToHapmap(this.createOutputAlignment(family, asNucleotides), this.outputDiploid, filename, '\t', null);
            }
        }
    }

    private GenotypeTable createOutputAlignment(PopulationData popdata, boolean asNucleotides) {
        GenotypeTable out = null;
        if (!asNucleotides) {
            out = popdata.imputed;
        } else {
            GenotypeTable outPoly = NucleotideImputationUtils.convertParentCallsToNucleotides(popdata);
            if (!Double.isNaN(this.minSnpCoverage) && !Double.isNaN(this.maxMafForMono)) {
                int nsnps = popdata.original.numberOfSites();
                double ngametes = 2 * popdata.original.numberOfTaxa();
                int[] monomorphicSnps = new int[nsnps];
                int snpCount = 0;
                for (int s = 0; s < nsnps; ++s) {
                    double coverage = (double)popdata.original.totalGametesNonMissingForSite(s) / ngametes;
                    if (popdata.snpIndex.fastGet(s) || !(popdata.original.minorAlleleFrequency(s) <= this.maxMafForMono) || !(coverage >= this.minSnpCoverage)) continue;
                    monomorphicSnps[snpCount++] = s;
                }
                FilterGenotypeTable fa = FilterGenotypeTable.getInstance(popdata.original, monomorphicSnps = Arrays.copyOf(monomorphicSnps, snpCount));
                if (fa.numberOfSites() == 0) {
                    out = outPoly;
                } else {
                    GenotypeTableBuilder builder = GenotypeTableBuilder.getSiteIncremental(fa.taxa());
                    nsnps = fa.numberOfSites();
                    int ntaxa = fa.numberOfTaxa();
                    for (int s = 0; s < nsnps; ++s) {
                        byte majorAllele = fa.majorAllele(s);
                        byte major = (byte)(majorAllele << 4 | majorAllele);
                        byte[] snpgeno = new byte[ntaxa];
                        Arrays.fill(snpgeno, major);
                        builder.addSite((Position)fa.positions().get(s), snpgeno);
                    }
                    out = builder.build();
                }
            }
        }
        return out;
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            myLogger.info((Object)this.getUsage());
            return;
        }
        int narg = args.length;
        for (int i = 0; i < narg; ++i) {
            String val;
            if (args[i].equals("-f") || args[i].equalsIgnoreCase("-file")) {
                this.baseFileName = args[++i];
                continue;
            }
            if (args[i].equals("-m") || args[i].equalsIgnoreCase("-merge")) {
                if ((val = args[++i]).toUpperCase().startsWith("T")) {
                    this.mergeAlignments = true;
                    continue;
                }
                this.mergeAlignments = false;
                continue;
            }
            if (args[i].equals("-p") || args[i].equalsIgnoreCase("-parentCalls")) {
                if ((val = args[++i]).toUpperCase().startsWith("T")) {
                    this.writeParentCalls = true;
                    this.writeNucleotides = false;
                    continue;
                }
                this.writeParentCalls = false;
                this.writeNucleotides = true;
                continue;
            }
            if (args[i].equals("-o") || args[i].equalsIgnoreCase("-outputType")) {
                if ((val = args[++i]).toUpperCase().startsWith("P")) {
                    this.writeParentCalls = true;
                    this.writeNucleotides = false;
                    continue;
                }
                if (val.toUpperCase().startsWith("N")) {
                    this.writeParentCalls = false;
                    this.writeNucleotides = true;
                    continue;
                }
                if (val.toUpperCase().startsWith("B")) {
                    this.writeParentCalls = true;
                    this.writeNucleotides = true;
                    continue;
                }
                this.writeParentCalls = true;
                this.writeNucleotides = false;
                continue;
            }
            if (args[i].equals("-d") || args[i].equalsIgnoreCase("-diploid")) {
                if ((val = args[++i]).toUpperCase().startsWith("T")) {
                    this.outputDiploid = true;
                    continue;
                }
                this.outputDiploid = false;
                continue;
            }
            if (args[i].equals("-c") || args[i].equalsIgnoreCase("-minCoverage")) {
                this.minSnpCoverage = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-x") || args[i].equalsIgnoreCase("-maxMono")) {
                this.maxMafForMono = Double.parseDouble(args[++i]);
                continue;
            }
            if (!args[i].equals("?")) continue;
            myLogger.info((Object)this.getUsage());
        }
    }

    public void setMergeAlignments(boolean mergeAlignments) {
        this.mergeAlignments = mergeAlignments;
    }

    public void setWriteParentCalls(boolean writeParentCalls) {
        this.writeParentCalls = writeParentCalls;
    }

    public void setOutputDiploid(boolean outputDiploid) {
        this.outputDiploid = outputDiploid;
    }

    public void setBaseFileName(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Write Populations";
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder("The WritePopulationAlignmentPlugin requires the following parameter:\n");
        usage.append("-f or -file : The base file name for the ouput. .hmp.txt will be appended.\n");
        usage.append("The following parameters are optional:\n");
        usage.append("-m or -merge : if true families are merged into a single file, if false each family is output to a separate file (default = true)\n");
        usage.append("-o or -outputType : parents = output parent calls, nucleotides = output nucleotides, both = output both\n");
        usage.append("-d or -diploid : if true output is AA/CC/AC, if false output is A/C/M\n");
        usage.append("-c or -minCoverage : the minimum coverage for a monomorphic snp to be included in the nucleotide output (default = NaN, no monomorphic SNPs included)\n");
        usage.append("-x or -maxMono : the maximum minor allele frequency used to call monomorphic snps (default = NaN, none called)\n");
        usage.append("? : print the parameter list.\n");
        return usage.toString();
    }

    public void setWriteNucleotides(boolean writeNucleotides) {
        this.writeNucleotides = writeNucleotides;
    }

    public void setMinSnpCoverage(double minSnpCoverage) {
        this.minSnpCoverage = minSnpCoverage;
    }

    public void setMaxMafForMono(double maxMafForMono) {
        this.maxMafForMono = maxMafForMono;
    }
}

