/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.File;
import java.util.Arrays;
import net.maizegenetics.dna.map.AbstractTagsOnPhysicalMap;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TagMappingInfo;
import org.apache.log4j.Logger;

public class TagsOnPhysMapHDF5
extends AbstractTagsOnPhysicalMap
implements TOPMInterface {
    private static final Logger myLogger = Logger.getLogger(TagsOnPhysMapHDF5.class);
    private static final int NUM_UNITS_TO_CACHE_ON_GET = 64;
    private static final int BITS_TO_SHIFT_FOR_CHUNK = 16;
    private static final int CHUNK_SIZE = 65536;
    private static HDF5GenericStorageFeatures genoFeatures = HDF5GenericStorageFeatures.createDeflation((int)5);
    private static HDF5IntStorageFeatures vectorFeatures = HDF5IntStorageFeatures.createDeflation((int)5);
    private int maxMapping = 4;
    private IHDF5Writer myHDF5 = null;
    private int cachedMappingIndex = -1;
    private TagMappingInfo cachedTMI = null;
    private int cachedMappingBlock = -1;
    private TagMappingInfo[][] cachedTMIBlock = null;
    private boolean cleanMap = true;
    private boolean cacheAllMappingBlocks = false;
    private HDF5CompoundType<TagMappingInfo> tmiType = null;
    private boolean hasDetailedMapping = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(AbstractTagsOnPhysicalMap inTags, String newHDF5file, int maxMapping, int maxVariants) {
        byte[] tagLength;
        long[][] tags;
        int tagLengthInLong = inTags.getTagSizeInLong();
        int tagCount = inTags.getTagCount();
        System.gc();
        if (inTags instanceof AbstractTagsOnPhysicalMap) {
            tags = inTags.getTagsArray();
            tagLength = inTags.getTagLengthArray();
        } else {
            tags = new long[tagLengthInLong][tagCount];
            tagLength = new byte[tagCount];
            for (int i = 0; i < tagCount; ++i) {
                long[] ct = inTags.getTag(i);
                for (int j = 0; j < tagLengthInLong; ++j) {
                    tags[j][i] = ct[j];
                }
                tagLength[i] = (byte)inTags.getTagLength(i);
            }
        }
        IHDF5Writer h5 = null;
        try {
            myLogger.info((Object)("Creating HDF5 File: " + newHDF5file));
            System.out.println("Creating HDF5 File: " + newHDF5file);
            IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(newHDF5file));
            config.overwrite();
            config.useUTF8CharacterEncoding();
            h5 = config.writer();
            h5.setIntAttribute("/", "tagCount", tagCount);
            h5.setIntAttribute("/", "maxVariants", maxVariants);
            h5.setIntAttribute("/", "maxMapping", maxMapping);
            h5.setIntAttribute("/", "tagLengthInLong", tagLengthInLong);
            h5.createLongMatrix("tags", (long)inTags.getTagSizeInLong(), (long)tagCount, inTags.getTagSizeInLong(), tagCount, vectorFeatures);
            h5.writeLongMatrix("tags", tags, vectorFeatures);
            tags = null;
            System.gc();
            System.out.println("...Tags written");
            h5.createByteArray("tagLength", tagCount, vectorFeatures);
            h5.writeByteArray("tagLength", tagLength, vectorFeatures);
            tagLength = null;
            System.out.println("...Tags lengths written");
            byte[] mmOut = new byte[tagCount];
            byte[] strandOut = new byte[tagCount];
            int[] chrOut = new int[tagCount];
            int[] posOut = new int[tagCount];
            for (int i = 0; i < tagCount; ++i) {
                mmOut[i] = inTags.getMultiMaps(i);
                strandOut[i] = inTags.getStrand(i);
                chrOut[i] = inTags.getChromosome(i);
                posOut[i] = inTags.getStartPosition(i);
            }
            h5.createByteArray("multimaps", tagCount);
            h5.writeByteArray("multimaps", mmOut, vectorFeatures);
            h5.createByteArray("bestStrand", tagCount);
            h5.writeByteArray("bestStrand", strandOut, vectorFeatures);
            h5.createIntArray("bestChr", tagCount, vectorFeatures);
            h5.writeIntArray("bestChr", chrOut, vectorFeatures);
            h5.createIntArray("bestStartPos", tagCount, vectorFeatures);
            h5.writeIntArray("bestStartPos", posOut, vectorFeatures);
            mmOut = null;
            strandOut = null;
            chrOut = null;
            posOut = null;
            System.gc();
            System.out.println("...multimapping, strand, chr, position  written");
            HDF5CompoundType tmiType = h5.compounds().getInferredType(TagMappingInfo.class);
            System.out.println("Chunk Size for Tags: 65536");
            int numOfChunks = TagsOnPhysMapHDF5.tagsToChunks(tagCount);
            System.out.println("Number of Chunks: " + numOfChunks);
            int numTagsPadded = numOfChunks * 65536;
            for (int mi = 0; mi < 1; ++mi) {
                h5.compounds().createArray("map" + mi, tmiType, (long)numTagsPadded, 65536);
                Object[] thTMI = new TagMappingInfo[65536];
                int block = 0;
                for (int i = 0; i < numTagsPadded; ++i) {
                    thTMI[i % 65536] = mi == 0 && i < tagCount ? new TagMappingInfo(inTags.getChromosome(i), inTags.getStrand(i), inTags.getStartPosition(i), inTags.getEndPosition(i), inTags.getDivergence(i)) : new TagMappingInfo();
                    if ((i + 1) % 65536 != 0) continue;
                    h5.compounds().writeArrayBlock("map" + mi, tmiType, thTMI, (long)block);
                    thTMI = new TagMappingInfo[65536];
                    ++block;
                    System.out.println("Tag locations written: " + (i + 1));
                }
                System.out.println("...map" + mi + " positions written");
            }
            h5.createByteMatrix("variantDef", tagCount, maxVariants);
            int numVariants = inTags.getMaxNumVariants();
            if (numVariants > maxVariants) {
                throw new IllegalArgumentException("TagsOnPhysMapHDF5: createFile: max variants can't be less than original TOPM Variant Defs: " + numVariants);
            }
            TagsOnPhysMapHDF5.writeVariantsToHDF5(h5, inTags, maxVariants);
            System.out.println("Variant offsets written");
        }
        finally {
            try {
                h5.close();
            }
            catch (Exception e) {}
        }
    }

    private static int tagsToChunks(long tags) {
        return (int)((tags - 1L >>> 16) + 1L);
    }

    public TagsOnPhysMapHDF5(String filename) {
        this(filename, true);
    }

    public TagsOnPhysMapHDF5(String theHDF5file, boolean cacheAllMappingBlocks) {
        this.myMaxVariants = 16;
        this.cacheAllMappingBlocks = cacheAllMappingBlocks;
        System.out.println("Opening :" + theHDF5file);
        this.myHDF5 = HDF5Factory.open((String)theHDF5file);
        this.hasDetailedMapping = this.myHDF5.exists("map0");
        this.myNumTags = this.myHDF5.getIntAttribute("/", "tagCount");
        this.tagLengthInLong = this.myHDF5.getIntAttribute("/", "tagLengthInLong");
        this.tags = this.myHDF5.readLongMatrix("tags");
        this.tagLength = this.myHDF5.readByteArray("tagLength");
        this.multimaps = this.myHDF5.readByteArray("multimaps");
        this.maxMapping = this.myHDF5.getIntAttribute("/", "maxMapping");
        this.tmiType = this.myHDF5.compounds().getInferredType(TagMappingInfo.class);
        this.cachedTMIBlock = new TagMappingInfo[this.maxMapping][];
        if (this.hasDetailedMapping) {
            this.cacheMappingInfo(0);
        }
        if (!this.myHDF5.exists("bestStrand")) {
            this.populateBestMappings();
        } else {
            this.bestStrand = this.myHDF5.readByteArray("bestStrand");
            this.bestChr = this.myHDF5.readIntArray("bestChr");
            this.bestStartPos = this.myHDF5.readIntArray("bestStartPos");
        }
        this.loadVariantsIntoMemory();
        System.out.println(theHDF5file + " read with tags:" + this.myNumTags);
        this.populateChrAndVarPositions();
        this.initPhysicalSort();
        System.gc();
    }

    private boolean populateBestMappings() {
        this.bestStrand = new byte[this.myNumTags];
        this.bestChr = new int[this.myNumTags];
        this.bestStartPos = new int[this.myNumTags];
        if (!this.myHDF5.exists("map0")) {
            Arrays.fill(this.bestStrand, (byte)-128);
            Arrays.fill(this.bestChr, Integer.MIN_VALUE);
            Arrays.fill(this.bestStartPos, Integer.MIN_VALUE);
            return false;
        }
        for (int i = 0; i < this.myNumTags; ++i) {
            int[] posArray = this.getPositionArray(i);
            this.bestStrand[i] = (byte)posArray[1];
            this.bestChr[i] = posArray[0];
            this.bestStartPos[i] = posArray[2];
        }
        this.myHDF5.createByteArray("bestStrand", this.myNumTags);
        this.myHDF5.writeByteArray("bestStrand", this.bestStrand, vectorFeatures);
        this.myHDF5.createIntArray("bestChr", this.myNumTags, vectorFeatures);
        this.myHDF5.writeIntArray("bestChr", this.bestChr, vectorFeatures);
        this.myHDF5.createIntArray("bestStartPos", this.myNumTags, vectorFeatures);
        this.myHDF5.writeIntArray("bestStartPos", this.bestStartPos, vectorFeatures);
        return true;
    }

    private boolean loadVariantsIntoMemory() {
        int howManyDef = 0;
        int readBlock = 65536;
        this.variantDefs = new byte[this.myNumTags][];
        this.variantOffsets = new byte[this.myNumTags][];
        if (!this.myHDF5.exists("variantDef")) {
            return false;
        }
        for (int blockStep = 0; blockStep < this.myNumTags; blockStep += readBlock) {
            int blockSize = this.myNumTags - blockStep < readBlock ? this.myNumTags - blockStep : readBlock;
            byte[][] vd = this.myHDF5.readByteMatrixBlockWithOffset("variantDef", blockSize, this.myMaxVariants, (long)blockStep, 0L);
            byte[][] vo = this.myHDF5.readByteMatrixBlockWithOffset("variantPosOff", blockSize, this.myMaxVariants, (long)blockStep, 0L);
            for (int j = 0; j < blockSize; ++j) {
                int cnt = 0;
                for (byte bs : vd[j]) {
                    if (bs == -128) continue;
                    ++cnt;
                }
                if (cnt == 0) continue;
                byte[] vdReDim = new byte[cnt];
                byte[] voReDim = new byte[cnt];
                for (int i = 0; i < cnt; ++i) {
                    vdReDim[i] = vd[j][i];
                    voReDim[i] = vo[j][i];
                    ++howManyDef;
                }
                this.variantDefs[blockStep + j] = vdReDim;
                this.variantOffsets[blockStep + j] = voReDim;
            }
        }
        System.out.println("Real Variant Defs:" + howManyDef);
        return true;
    }

    private static boolean writeVariantsToHDF5(IHDF5Writer aHDF5, AbstractTagsOnPhysicalMap aTOPM, int myMaxVariants) {
        int howManyDef = 0;
        int readBlock = 65536;
        int myNumTags = aTOPM.myNumTags;
        aHDF5.createByteMatrix("variantDef", myNumTags, myMaxVariants);
        aHDF5.createByteMatrix("variantPosOff", myNumTags, myMaxVariants);
        if (!aHDF5.exists("variantDef")) {
            return false;
        }
        byte[][] vd = new byte[readBlock][myMaxVariants];
        byte[][] vo = new byte[readBlock][myMaxVariants];
        for (int blockStep = 0; blockStep < myNumTags; blockStep += readBlock) {
            int blockSize = myNumTags - blockStep < readBlock ? myNumTags - blockStep : readBlock;
            vd = new byte[blockSize][myMaxVariants];
            vo = new byte[blockSize][myMaxVariants];
            for (int j = 0; j < blockSize; ++j) {
                for (int v = 0; v < vo[0].length; ++v) {
                    vd[j][v] = aTOPM.getVariantDef(blockStep + j, v);
                    vo[j][v] = aTOPM.getVariantPosOff(blockStep + j, v);
                }
            }
            aHDF5.writeByteMatrixBlockWithOffset("variantDef", vd, (long)blockStep, 0L);
            aHDF5.writeByteMatrixBlockWithOffset("variantPosOff", vo, (long)blockStep, 0L);
        }
        System.out.println("Real Variant Defs:" + howManyDef);
        return true;
    }

    private void cacheMappingInfo(int index) {
        if (index == this.cachedMappingIndex) {
            return;
        }
        int block = index >> 16;
        if (this.cachedMappingBlock != block) {
            if (!this.cleanMap) {
                this.saveCacheBackToFile();
            }
            for (int mi = 0; mi < this.maxMapping; ++mi) {
                this.cachedTMIBlock[mi] = (TagMappingInfo[])this.myHDF5.compounds().readArrayBlock("map0", this.tmiType, 65536, (long)block);
                this.cachedMappingBlock = block;
                if (!this.cacheAllMappingBlocks) break;
            }
        }
        this.cachedTMI = this.cachedTMIBlock[0][index % 65536];
        this.cachedMappingIndex = index;
    }

    private void saveCacheBackToFile() {
        int block = this.cachedMappingIndex >> 16;
        if (this.cachedMappingBlock != block) {
            for (int mi = 0; mi < this.maxMapping; ++mi) {
                if (!this.cleanMap) {
                    this.myHDF5.compounds().writeArrayBlock("map0", this.tmiType, this.cachedTMIBlock[mi], (long)block);
                }
                if (!this.cacheAllMappingBlocks) break;
            }
            if (!this.cleanMap) {
                this.myHDF5.writeByteArray("multimaps", this.multimaps);
            }
            this.cleanMap = true;
        }
    }

    public void getFileReadyForClosing() {
    }

    public TagMappingInfo getAlternateTagMappingInfo(int index, int mapIndex) {
        if (this.hasDetailedMapping) {
            return null;
        }
        if (!this.cacheAllMappingBlocks) {
            this.cacheMappingInfo(index);
        }
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        return this.cachedTMIBlock[mapIndex][index % 65536];
    }

    public void setAlternateTagMappingInfo(int index, int mapIndex, TagMappingInfo theTMI) {
        if (!this.hasDetailedMapping) {
            throw new IllegalStateException("Detailed mapping not present");
        }
        if (!this.cacheAllMappingBlocks) {
            this.cacheMappingInfo(index);
        }
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        this.cachedTMIBlock[mapIndex][index % 65536] = theTMI;
        if (this.multimaps[index] >= mapIndex) {
            this.multimaps[index] = (byte)(mapIndex + 1);
        }
        this.cleanMap = false;
    }

    public void swapTagMappingInfo(int index, int mapIndex, int mapIndex2) {
        if (!this.hasDetailedMapping) {
            throw new IllegalStateException("Detailed mapping not present");
        }
        if (!this.cacheAllMappingBlocks) {
            this.cacheMappingInfo(index);
        }
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        TagMappingInfo tempTMI = this.cachedTMIBlock[mapIndex][index % 65536];
        this.cachedTMIBlock[mapIndex][index % 65536] = this.cachedTMIBlock[mapIndex2][index % 65536];
        this.cachedTMIBlock[mapIndex2][index % 65536] = tempTMI;
        this.cleanMap = false;
    }

    @Override
    public int addVariant(int tagIndex, byte offset, byte base) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getDcoP(int index) {
        if (!this.hasDetailedMapping) {
            throw new IllegalStateException("Detailed mapping not present");
        }
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        return this.cachedTMI.dcoP;
    }

    @Override
    public byte getDivergence(int index) {
        if (!this.hasDetailedMapping) {
            throw new IllegalStateException("Detailed mapping not present");
        }
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        return this.cachedTMI.divergence;
    }

    @Override
    public int getEndPosition(int index) {
        if (!this.hasDetailedMapping) {
            throw new IllegalStateException("Detailed mapping not present");
        }
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        return this.cachedTMI.endPosition;
    }

    @Override
    public byte getMapP(int index) {
        if (!this.hasDetailedMapping) {
            throw new IllegalStateException("Detailed mapping not present");
        }
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        return this.cachedTMI.mapP;
    }

    @Override
    public int[] getPositionArray(int index) {
        if (this.cachedMappingIndex != index) {
            this.cacheMappingInfo(index);
        }
        int[] r = new int[]{this.cachedTMI.chromosome, this.cachedTMI.strand, this.cachedTMI.startPosition};
        return r;
    }

    @Override
    public int getReadIndexForPositionIndex(int posIndex) {
        return this.indicesOfSortByPosition[posIndex];
    }

    @Override
    public int[] getUniquePositions(int chromosome) {
        if (this.myUniquePositions == null) {
            this.populateChrAndVarPositions();
        }
        return this.myUniquePositions[chromosome];
    }

    public void setMultimaps(int index, byte multimaps) {
        this.multimaps[index] = multimaps;
    }

    @Override
    public void setChromoPosition(int index, int chromosome, byte strand, int positionMin, int positionMax) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDivergence(int index, byte divergence) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMapP(int index, byte mapP) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMapP(int index, double mapP) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void setVariantDef(int tagIndex, int variantIndex, byte def) {
        this.myHDF5.writeByteMatrixBlockWithOffset("variantDef", (byte[][])new byte[][]{{def}}, (long)tagIndex, (long)variantIndex);
        this.variantDefs[tagIndex][variantIndex] = def;
    }

    @Override
    public synchronized void setVariantPosOff(int tagIndex, int variantIndex, byte offset) {
        this.myHDF5.writeByteMatrixBlockWithOffset("variantPosOff", (byte[][])new byte[][]{{offset}}, (long)tagIndex, (long)variantIndex);
        this.variantOffsets[tagIndex][variantIndex] = offset;
    }

    public synchronized void setAllVariantInfo(int tagIndex, byte[][] defAndOffset) {
        this.myHDF5.writeByteMatrixBlockWithOffset("variantDef", (byte[][])new byte[][]{defAndOffset[0]}, (long)tagIndex, 0L);
        this.myHDF5.writeByteMatrixBlockWithOffset("variantPosOff", (byte[][])new byte[][]{defAndOffset[1]}, (long)tagIndex, 0L);
        this.variantDefs[tagIndex] = defAndOffset[1];
        this.variantOffsets[tagIndex] = defAndOffset[1];
    }

    @Override
    public void clearVariants() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

