/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;

public class UpdateTOPMWithGeneticMapping {
    TagsOnPhysicalMap theTOPM = null;
    double minRatioOfBestToNext = 2.0;
    int maxDistBLASTLD = 10000000;

    public UpdateTOPMWithGeneticMapping(String sTOPM, String sMappings, String sOutFile) {
        this.theTOPM = new TagsOnPhysicalMap(sTOPM, sTOPM.contains(".bin"));
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(sMappings));
            int count = 0;
            int revisedGeneticPositions = 0;
            int newGeneticPositions = 0;
            int agreeWithBLAST = 0;
            int hasBLASTPosition = 0;
            int geneticallyMapsSig1e7 = 0;
            int tagsWGeneticOrBLASTSig = 0;
            long readCountTotal = 0L;
            long readCountMap = 0L;
            long readCountNotMap = 0L;
            long readWGeneticOrBLASTSig = 0L;
            while ((temp = br.readLine()) != null) {
                int tagCount;
                double bestPValue;
                double ratioOfBestToNext;
                int countBetterSites;
                int positionLD;
                int chrLD;
                String[] s = temp.split("\\s");
                if (s.length != 17) continue;
                try {
                    chrLD = Integer.parseInt(s[5]);
                    positionLD = Integer.parseInt(s[7]);
                    countBetterSites = Integer.parseInt(s[14]);
                    ratioOfBestToNext = Double.parseDouble(s[12]);
                    bestPValue = Double.parseDouble(s[8]);
                    tagCount = Integer.parseInt(s[10]);
                }
                catch (NumberFormatException nef) {
                    System.err.println("Error in Reading Lines:" + temp);
                    continue;
                }
                ++count;
                long[] tag = BaseEncoder.getLongArrayFromSeq(s[0]);
                int tagIndex = this.theTOPM.getTagIndex(tag);
                if (tagIndex < 0) continue;
                readCountTotal += (long)tagCount;
                if (this.theTOPM.getChromosome(tagIndex) > -1) {
                    ++hasBLASTPosition;
                }
                if (bestPValue < 1.0E-7) {
                    ++geneticallyMapsSig1e7;
                }
                if (this.theTOPM.getChromosome(tagIndex) > -1 || bestPValue < 1.0E-7 || ratioOfBestToNext > this.minRatioOfBestToNext && countBetterSites > 2) {
                    ++tagsWGeneticOrBLASTSig;
                    readWGeneticOrBLASTSig += (long)tagCount;
                }
                int distance = Math.abs(positionLD - this.theTOPM.getStartPosition(tagIndex));
                if (chrLD == this.theTOPM.getChromosome(tagIndex) && distance < this.maxDistBLASTLD) {
                    this.theTOPM.setMapP(tagIndex, bestPValue);
                    ++agreeWithBLAST;
                    readCountMap += (long)tagCount;
                } else if (chrLD != this.theTOPM.getChromosome(tagIndex) && ratioOfBestToNext > this.minRatioOfBestToNext && countBetterSites > 2) {
                    if (this.theTOPM.getChromosome(tagIndex) < 0) {
                        ++newGeneticPositions;
                    } else {
                        ++revisedGeneticPositions;
                    }
                    this.updateTOPM(tag, chrLD, positionLD, positionLD, (byte)-128, (byte)-128, bestPValue);
                    readCountMap += (long)tagCount;
                } else {
                    readCountNotMap += (long)tagCount;
                }
                if (count % 10000 != 0) continue;
                System.out.printf("Count: %d  hasBLAST: %d GeneticLT1e-7: %d hasBLASTorGeneticSig: %d NewPos: %d  RevisedPos: %d ConfirmedPos: %d TotalReads: %d ReadWithBLASTorGenetics: %d TotalReadMapCount: %d TotalReadNoMapCount: %d %n", count, hasBLASTPosition, geneticallyMapsSig1e7, tagsWGeneticOrBLASTSig, newGeneticPositions, revisedGeneticPositions, agreeWithBLAST, readCountTotal, readWGeneticOrBLASTSig, readCountMap, readCountNotMap);
            }
            System.out.printf("Count: %d  hasBLAST: %d GeneticLT1e-7: %d hasBLASTorGeneticSig: %d NewPos: %d  RevisedPos: %d ConfirmedPos: %d TotalReads: %d ReadWithBLASTorGenetics: %d TotalMapCount: %d NoMapCount: %d %n", count, hasBLASTPosition, geneticallyMapsSig1e7, tagsWGeneticOrBLASTSig, newGeneticPositions, revisedGeneticPositions, agreeWithBLAST, readCountTotal, readWGeneticOrBLASTSig, readCountMap, readCountNotMap);
            this.theTOPM.printRows(100000, true, 10);
        }
        catch (IOException e) {
            System.err.println("Error in UpdateTOPMWithGeneticMapping");
        }
    }

    private void updateTOPM(long[] tag, int chr, int minPosition, int maxPosition, byte strand, byte divergence, double mapP) {
        int index = this.theTOPM.getTagIndex(tag);
        if (index > -1) {
            this.theTOPM.setChromoPosition(index, chr, strand, minPosition, maxPosition);
            this.theTOPM.setDivergence(index, divergence);
            this.theTOPM.setMapP(index, mapP);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Input format -topm MapFile -map Mapping -o OutMapFile");
            String[] s = new String[]{"-topm", "/Volumes/LaCie/mergedNam282Ames_072011_mappedOnly.topm.bin", "-map", "/Users/edbuckler/SolexaAnal/GBS/build111217/mapping/Zea20111217_mapping_chr10.txt", "-o", "/Users/edbuckler/SolexaAnal/GBS/build111217/test/C10mergedNam282Ames_072011_mappedOnly.topm.bin"};
            args = s;
        }
        if (args.length != 6) {
            System.err.println("Input format -topm MapFile -map Mapping -o OutMapFile");
            return;
        }
        UpdateTOPMWithGeneticMapping theUTGM = new UpdateTOPMWithGeneticMapping(args[1], args[3], args[5]);
    }
}

