/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.Matrix;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.decomposition.ColtEigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.EJMLEigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.EJMLSingularValueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.QRDecomposition;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.LinearSolver;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public class EJMLDoubleMatrix
implements DoubleMatrix {
    public final DenseMatrix64F myMatrix;

    public EJMLDoubleMatrix(DenseMatrix64F aMatrix) {
        this.myMatrix = aMatrix;
    }

    public EJMLDoubleMatrix(int row, int col) {
        this.myMatrix = new DenseMatrix64F(row, col);
    }

    public EJMLDoubleMatrix(int row, int col, double[] values) {
        this.myMatrix = new DenseMatrix64F(row, col, true, values);
    }

    public EJMLDoubleMatrix(int row, int col, double value) {
        this.myMatrix = new DenseMatrix64F(row, col);
        if (value != 0.0) {
            for (int r = 0; r < row; ++r) {
                for (int c = 0; c < col; ++c) {
                    this.myMatrix.set(r, c, value);
                }
            }
        }
    }

    public EJMLDoubleMatrix(double[][] values) {
        this.myMatrix = new DenseMatrix64F(values);
    }

    public EJMLDoubleMatrix(int size) {
        this.myMatrix = CommonOps.identity((int)size);
    }

    public EJMLDoubleMatrix(double[] diagonal) {
        this.myMatrix = CommonOps.diag((double[])diagonal);
    }

    @Override
    public DoubleMatrix column(int j) {
        int n = this.myMatrix.numRows;
        DenseMatrix64F result = new DenseMatrix64F(n, 1);
        SpecializedOps.subvector((RowD1Matrix64F)this.myMatrix, (int)0, (int)j, (int)n, (boolean)false, (int)0, (RowD1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public int columnRank() {
        if (this.myMatrix.numCols == 1) {
            return 1;
        }
        EJMLSingularValueDecomposition svd = new EJMLSingularValueDecomposition(this.myMatrix);
        return svd.getRank();
    }

    @Override
    public DoubleMatrix concatenate(DoubleMatrix dm, boolean rows) {
        DenseMatrix64F result = null;
        DenseMatrix64F otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        int myNumberOfRows = this.myMatrix.numRows;
        int myNumberOfCols = this.myMatrix.numCols;
        int dmNumberOfRows = otherMatrix.numRows;
        int dmNumberOfCols = otherMatrix.numCols;
        if (rows) {
            if (myNumberOfCols != dmNumberOfCols) {
                StringBuilder sb = new StringBuilder("Non-conformable matrices in concatenate rows: ");
                sb.append(myNumberOfRows).append(" x ").append(myNumberOfCols);
                sb.append(", ").append(dmNumberOfRows).append(" x ").append(dmNumberOfCols);
                throw new IllegalArgumentException(sb.toString());
            }
            int totalRows = myNumberOfRows + dmNumberOfRows;
            result = new DenseMatrix64F(totalRows, myNumberOfCols);
            CommonOps.insert((Matrix64F)this.myMatrix, (Matrix64F)result, (int)0, (int)0);
            CommonOps.insert((Matrix64F)otherMatrix, (Matrix64F)result, (int)dmNumberOfRows, (int)0);
        } else {
            if (myNumberOfRows != dmNumberOfRows) {
                StringBuilder sb = new StringBuilder("Non-conformable matrices in concatenate columns: ");
                sb.append(myNumberOfRows).append(" x ").append(myNumberOfCols);
                sb.append(", ").append(dmNumberOfRows).append(" x ").append(dmNumberOfCols);
                throw new IllegalArgumentException(sb.toString());
            }
            int totalCol = myNumberOfCols + dmNumberOfCols;
            result = new DenseMatrix64F(myNumberOfRows, totalCol);
            CommonOps.insert((Matrix64F)this.myMatrix, (Matrix64F)result, (int)0, (int)0);
            CommonOps.insert((Matrix64F)otherMatrix, (Matrix64F)result, (int)0, (int)myNumberOfCols);
        }
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix copy() {
        return new EJMLDoubleMatrix(this.myMatrix.copy());
    }

    @Override
    public DoubleMatrix crossproduct() {
        int n = this.myMatrix.numCols;
        DenseMatrix64F result = new DenseMatrix64F(n, n);
        CommonOps.multTransA((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix crossproduct(DoubleMatrix dm) {
        int nrow = this.myMatrix.numCols;
        int ncol = dm.numberOfColumns();
        DenseMatrix64F otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        DenseMatrix64F result = new DenseMatrix64F(nrow, ncol);
        CommonOps.multTransA((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)otherMatrix, (RowD1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix generalizedInverse() {
        DenseMatrix64F result = new DenseMatrix64F(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps.pinv((DenseMatrix64F)this.myMatrix, (DenseMatrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix generalizedInverseWithRank(int[] rank) {
        SingularValueDecomposition myDecomposition = DecompositionFactory.svd((int)this.myMatrix.numRows, (int)this.myMatrix.numCols, (boolean)true, (boolean)true, (boolean)false);
        myDecomposition.decompose((Matrix64F)this.myMatrix);
        double tol = 1.0E-10;
        rank[0] = 0;
        DenseMatrix64F W = (DenseMatrix64F)myDecomposition.getW(null);
        int n = W.getNumRows();
        for (int i = 0; i < n; ++i) {
            double val = W.get(i, i);
            if (val < tol) {
                val = 0.0;
            } else {
                val = 1.0 / val;
                rank[0] = rank[0] + 1;
            }
            W.set(i, i, val);
        }
        DenseMatrix64F V = (DenseMatrix64F)myDecomposition.getV(null, false);
        DenseMatrix64F UT = (DenseMatrix64F)myDecomposition.getU(null, true);
        int nrows = V.getNumRows();
        int ncols = W.getNumCols();
        DenseMatrix64F VW = new DenseMatrix64F(nrows, ncols);
        CommonOps.mult((RowD1Matrix64F)V, (RowD1Matrix64F)W, (RowD1Matrix64F)VW);
        ncols = UT.getNumCols();
        DenseMatrix64F inv = new DenseMatrix64F(nrows, ncols);
        CommonOps.mult((RowD1Matrix64F)VW, (RowD1Matrix64F)UT, (RowD1Matrix64F)inv);
        return new EJMLDoubleMatrix(inv);
    }

    @Override
    public double get(int row, int col) {
        return this.myMatrix.get(row, col);
    }

    @Override
    public double getChecked(int row, int col) {
        return this.myMatrix.get(row, col);
    }

    @Override
    public EigenvalueDecomposition getEigenvalueDecomposition() {
        EJMLEigenvalueDecomposition decomposition = new EJMLEigenvalueDecomposition(this.myMatrix);
        if (decomposition.wasSuccessful()) {
            return decomposition;
        }
        return new ColtEigenvalueDecomposition(this.myMatrix);
    }

    @Override
    public DoubleMatrix[] getXtXGM() {
        DoubleMatrix[] dmarray = new DoubleMatrix[3];
        int ncol = this.myMatrix.numCols;
        int nrow = this.myMatrix.numRows;
        DenseMatrix64F result1 = new DenseMatrix64F(ncol, ncol);
        CommonOps.multTransA((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)result1);
        dmarray[0] = new EJMLDoubleMatrix(result1);
        DenseMatrix64F inverse = new DenseMatrix64F(ncol, ncol);
        CommonOps.invert((DenseMatrix64F)result1, (DenseMatrix64F)inverse);
        dmarray[1] = new EJMLDoubleMatrix(inverse);
        DenseMatrix64F result2 = new DenseMatrix64F(ncol, nrow);
        DenseMatrix64F ident = CommonOps.identity((int)nrow);
        CommonOps.multTransB((RowD1Matrix64F)inverse, (RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)result2);
        CommonOps.multAdd((double)-1.0, (RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)result2, (RowD1Matrix64F)ident);
        dmarray[2] = new EJMLDoubleMatrix(ident);
        return dmarray;
    }

    @Override
    public QRDecomposition getQRDecomposition() {
        return null;
    }

    @Override
    public net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition getSingularValueDecomposition() {
        return new EJMLSingularValueDecomposition(this.myMatrix);
    }

    @Override
    public DoubleMatrix inverse() {
        DenseMatrix64F inverse = new DenseMatrix64F(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps.invert((DenseMatrix64F)this.myMatrix, (DenseMatrix64F)inverse);
        return new EJMLDoubleMatrix(inverse);
    }

    @Override
    public void invert() {
        CommonOps.invert((DenseMatrix64F)this.myMatrix);
    }

    @Override
    public DoubleMatrix minus(DoubleMatrix dm) {
        DenseMatrix64F result = new DenseMatrix64F(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps.sub((D1Matrix64F)this.myMatrix, (D1Matrix64F)((EJMLDoubleMatrix)dm).myMatrix, (D1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public void minusEquals(DoubleMatrix dm) {
        CommonOps.subEquals((D1Matrix64F)this.myMatrix, (D1Matrix64F)((EJMLDoubleMatrix)dm).myMatrix);
    }

    @Override
    public DoubleMatrix mult(DoubleMatrix dm, boolean transpose, boolean transposedm) {
        DenseMatrix64F result;
        DenseMatrix64F b = ((EJMLDoubleMatrix)dm).myMatrix;
        if (transpose) {
            int nrow = this.myMatrix.numCols;
            if (transposedm) {
                int ncol = b.numRows;
                result = new DenseMatrix64F(nrow, ncol);
                CommonOps.multTransAB((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)b, (RowD1Matrix64F)result);
            } else {
                int ncol = b.numCols;
                result = new DenseMatrix64F(nrow, ncol);
                CommonOps.multTransA((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)b, (RowD1Matrix64F)result);
            }
        } else {
            int nrow = this.myMatrix.numRows;
            if (transposedm) {
                int ncol = b.numRows;
                result = new DenseMatrix64F(nrow, ncol);
                CommonOps.multTransB((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)b, (RowD1Matrix64F)result);
            } else {
                int ncol = b.numCols;
                result = new DenseMatrix64F(nrow, ncol);
                CommonOps.mult((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)b, (RowD1Matrix64F)result);
            }
        }
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix mult(DoubleMatrix dm) {
        DenseMatrix64F b = ((EJMLDoubleMatrix)dm).myMatrix;
        int nrow = this.myMatrix.numRows;
        int ncol = b.numCols;
        DenseMatrix64F result = new DenseMatrix64F(nrow, ncol);
        CommonOps.mult((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)b, (RowD1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix multadd(DoubleMatrix A, DoubleMatrix B, double alpha, double beta, boolean transpose, boolean transposeA) {
        DoubleMatrix result = this.mult(A, transpose, transposeA);
        if (alpha != 1.0) {
            result.scalarMultEquals(alpha);
        }
        if (B == null) {
            return result;
        }
        if (beta == 1.0) {
            return result.plus(B);
        }
        return result.plus(B.scalarMult(beta));
    }

    @Override
    public int numberOfColumns() {
        return this.myMatrix.numCols;
    }

    @Override
    public int numberOfRows() {
        return this.myMatrix.numRows;
    }

    @Override
    public DoubleMatrix plus(DoubleMatrix dm) {
        DenseMatrix64F result = new DenseMatrix64F(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps.add((D1Matrix64F)this.myMatrix, (D1Matrix64F)((EJMLDoubleMatrix)dm).myMatrix, (D1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public void plusEquals(DoubleMatrix dm) {
        CommonOps.addEquals((D1Matrix64F)this.myMatrix, (D1Matrix64F)((EJMLDoubleMatrix)dm).myMatrix);
    }

    @Override
    public DoubleMatrix row(int i) {
        int n = this.myMatrix.numCols;
        DenseMatrix64F result = new DenseMatrix64F(1, n);
        SpecializedOps.subvector((RowD1Matrix64F)this.myMatrix, (int)0, (int)i, (int)n, (boolean)true, (int)0, (RowD1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix scalarAdd(double s) {
        DenseMatrix64F result = new DenseMatrix64F(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps.add((D1Matrix64F)this.myMatrix, (double)s, (D1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public void scalarAddEquals(double s) {
        CommonOps.add((D1Matrix64F)this.myMatrix, (double)s);
    }

    @Override
    public DoubleMatrix scalarMult(double s) {
        DenseMatrix64F result = new DenseMatrix64F(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps.scale((double)s, (D1Matrix64F)this.myMatrix, (D1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public void scalarMultEquals(double s) {
        CommonOps.scale((double)s, (D1Matrix64F)this.myMatrix);
    }

    @Override
    public void set(int row, int col, double value) {
        this.myMatrix.set(row, col, value);
    }

    @Override
    public void setChecked(int row, int col, double value) {
        this.myMatrix.set(row, col, value);
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix Y) {
        DenseMatrix64F data = ((EJMLDoubleMatrix)Y).myMatrix;
        DenseMatrix64F result = new DenseMatrix64F(this.myMatrix.numCols, data.numCols);
        LinearSolver solver = LinearSolverFactory.leastSquares((int)this.myMatrix.numCols, (int)data.numCols);
        solver.setA((Matrix64F)this.myMatrix);
        solver.solve((Matrix64F)data, (Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix tcrossproduct() {
        int ncol = this.myMatrix.numRows;
        DenseMatrix64F result = new DenseMatrix64F(ncol, ncol);
        CommonOps.multTransB((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix tcrossproduct(DoubleMatrix dm) {
        DenseMatrix64F other = ((EJMLDoubleMatrix)dm).myMatrix;
        int nrow = this.myMatrix.numRows;
        int ncol = other.numRows;
        DenseMatrix64F result = new DenseMatrix64F(nrow, ncol);
        CommonOps.multTransB((RowD1Matrix64F)this.myMatrix, (RowD1Matrix64F)other, (RowD1Matrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix transpose() {
        DenseMatrix64F result = new DenseMatrix64F(this.myMatrix.numCols, this.myMatrix.numRows);
        CommonOps.transpose((DenseMatrix64F)this.myMatrix, (DenseMatrix64F)result);
        return new EJMLDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix getSelection(int[] rows, int[] columns) {
        if (rows == null) {
            if (columns == null) {
                return this.copy();
            }
            int nrow = this.myMatrix.numRows;
            int ncol = columns.length;
            DoubleMatrix result = DoubleMatrixFactory.DEFAULT.make(nrow, ncol);
            for (int r = 0; r < nrow; ++r) {
                for (int c = 0; c < ncol; ++c) {
                    result.set(r, c, this.myMatrix.get(r, columns[c]));
                }
            }
            return result;
        }
        if (columns == null) {
            int nrow = rows.length;
            int ncol = this.myMatrix.numCols;
            DoubleMatrix result = DoubleMatrixFactory.DEFAULT.make(nrow, ncol);
            for (int r = 0; r < nrow; ++r) {
                for (int c = 0; c < ncol; ++c) {
                    result.set(r, c, this.myMatrix.get(rows[r], c));
                }
            }
            return result;
        }
        int nrow = rows.length;
        int ncol = columns.length;
        DoubleMatrix result = DoubleMatrixFactory.DEFAULT.make(nrow, ncol);
        for (int r = 0; r < nrow; ++r) {
            for (int c = 0; c < ncol; ++c) {
                result.set(r, c, this.myMatrix.get(rows[r], columns[c]));
            }
        }
        return result;
    }

    public String toString() {
        int nrows = Math.min(25, this.myMatrix.numRows);
        int ncols = Math.min(25, this.myMatrix.numCols);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nrows; ++i) {
            for (int j = 0; j < ncols; ++j) {
                if (j > 0) {
                    sb.append(" ");
                }
                sb.append(this.myMatrix.get(i, j));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public double columnSum(int column) {
        int n = this.myMatrix.numRows;
        DenseMatrix64F vector = new DenseMatrix64F(n, 1);
        SpecializedOps.subvector((RowD1Matrix64F)this.myMatrix, (int)0, (int)column, (int)n, (boolean)false, (int)0, (RowD1Matrix64F)vector);
        return CommonOps.elementSum((D1Matrix64F)vector);
    }

    @Override
    public double rowSum(int row) {
        int n = this.myMatrix.numCols;
        DenseMatrix64F vector = new DenseMatrix64F(n, 1);
        SpecializedOps.subvector((RowD1Matrix64F)this.myMatrix, (int)row, (int)0, (int)n, (boolean)true, (int)0, (RowD1Matrix64F)vector);
        return CommonOps.elementSum((D1Matrix64F)vector);
    }
}

