/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import java.util.Arrays;
import net.maizegenetics.matrixalgebra.Matrix.BlasDoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;

public class BlasEigenvalueDecomposition
implements EigenvalueDecomposition {
    protected double[] eigenvalues;
    protected double[] eigenvectors;
    protected BlasDoubleMatrix bdm;
    protected int info;

    public BlasEigenvalueDecomposition(DoubleMatrix dm) {
        this.bdm = (BlasDoubleMatrix)dm;
        this.init();
    }

    protected void init() {
        double[] originalMatrix = Arrays.copyOf(this.bdm.getMatrix(), this.bdm.getSize());
        int order = this.bdm.numberOfRows();
        this.eigenvalues = new double[order];
        this.eigenvectors = new double[order * order];
        this.info = BlasDoubleMatrix.eigenValueSymmetricDecomposition(order, originalMatrix, this.eigenvalues, this.eigenvectors);
    }

    @Override
    public double[] getEigenvalues() {
        return this.eigenvalues;
    }

    @Override
    public double getEigenvalue(int i) {
        return this.eigenvalues[i];
    }

    @Override
    public DoubleMatrix getEigenvectors() {
        int nrows = this.bdm.numberOfRows();
        return BlasDoubleMatrix.getInstance(nrows, nrows, this.eigenvectors, true);
    }

    @Override
    public DoubleMatrix getEigenvalueMatrix() {
        return BlasDoubleMatrix.getDiagonalMatrix(this.eigenvalues);
    }
}

