/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class CategoricalAttribute
implements PhenotypeAttribute {
    private final String name;
    private final int[] values;
    private final ImmutableBiMap<String, Integer> labelBimap;
    private final BitSet missing;
    private static final String missingValue = "?";
    private static final List<Phenotype.ATTRIBUTE_TYPE> myAllowedTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();

    public CategoricalAttribute(String name, String[] stringValues) {
        this.name = name;
        int n = stringValues.length;
        this.missing = new OpenBitSet(n);
        this.values = new int[n];
        TreeSet<String> labelSet = new TreeSet<String>();
        for (String label : stringValues) {
            if (label.endsWith(missingValue)) continue;
            labelSet.add(label);
        }
        ImmutableBiMap.Builder bimapBuilder = ImmutableBiMap.builder();
        int count = 0;
        for (String label : labelSet) {
            bimapBuilder.put((Object)label, (Object)count++);
        }
        this.labelBimap = bimapBuilder.build();
        for (int i = 0; i < n; ++i) {
            if (stringValues[i].equals(missingValue)) {
                this.values[i] = -1;
                this.missing.fastSet(i);
                continue;
            }
            this.values[i] = (Integer)this.labelBimap.get((Object)stringValues[i]);
        }
    }

    public int intValue(int obs) {
        return this.values[obs];
    }

    public int[] allIntValues() {
        return this.values;
    }

    public String attributeLabelForIndex(int index) {
        return (String)this.labelBimap.inverse().get((Object)index);
    }

    public int indexForAttrLabel(String label) {
        return (Integer)this.labelBimap.get((Object)label);
    }

    public String label(int obs) {
        return (String)this.labelBimap.inverse().get((Object)this.values[obs]);
    }

    public String[] allLabels() {
        int n = this.values.length;
        String[] labels = new String[n];
        ImmutableBiMap reverseMap = this.labelBimap.inverse();
        for (int i = 0; i < n; ++i) {
            labels[i] = (String)reverseMap.get((Object)this.values[i]);
        }
        return labels;
    }

    public List<String> labelList() {
        int n = this.labelBimap.size();
        ArrayList<String> labelList = new ArrayList<String>();
        ImmutableBiMap reverseMap = this.labelBimap.inverse();
        for (int i = 0; i < n; ++i) {
            labelList.add((String)reverseMap.get((Object)i));
        }
        return labelList;
    }

    @Override
    public Object value(int obs) {
        return this.labelBimap.inverse().get((Object)this.values[obs]);
    }

    @Override
    public Object allValues() {
        return this.allLabels();
    }

    @Override
    public PhenotypeAttribute subset(int[] obs) {
        int n = obs.length;
        String[] labels = new String[n];
        ImmutableBiMap reverseMap = this.labelBimap.inverse();
        for (int i = 0; i < n; ++i) {
            labels[i] = (String)reverseMap.get((Object)obs[i]);
            labels[i] = this.values[obs[i]] == -1 ? missingValue : (String)reverseMap.get((Object)this.values[obs[i]]);
        }
        return new CategoricalAttribute(this.name, labels);
    }

    @Override
    public boolean isMissing(int obs) {
        return this.missing.fastGet(obs);
    }

    @Override
    public BitSet missing() {
        return this.missing;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public List<Phenotype.ATTRIBUTE_TYPE> getCompatibleTypes() {
        return myAllowedTypes;
    }

    @Override
    public boolean isTypeCompatible(Phenotype.ATTRIBUTE_TYPE type) {
        return myAllowedTypes.contains((Object)type);
    }

    static {
        myAllowedTypes.add(Phenotype.ATTRIBUTE_TYPE.factor);
    }
}

