/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.progress;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.progress.ProgressPanel;

public class PluginProgressUnit
extends JPanel
implements PluginListener {
    private final int LABEL_WIDTH = 20;
    private final JProgressBar myProgress;
    private final JButton myCancelButton;
    private final Plugin myPlugin;
    private final Plugin myCancelPlugin;
    private int myCurrentValue = 0;

    public PluginProgressUnit(Plugin plugin, int level) {
        this(plugin, level, true);
    }

    public PluginProgressUnit(Plugin plugin, int level, boolean cancelButton) {
        this(plugin, level, cancelButton, null);
    }

    public PluginProgressUnit(Plugin plugin, int level, boolean cancelButton, Plugin cancelPlugin) {
        this.myPlugin = plugin;
        this.myCancelPlugin = cancelPlugin == null ? this.myPlugin : cancelPlugin;
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        this.setAlignmentX(0.0f);
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout(0));
        this.myProgress = new JProgressBar(0, 100);
        this.setProgress(0);
        if (cancelButton) {
            URL imageURL = PluginProgressUnit.class.getResource("cancel.gif");
            this.myCancelButton = imageURL == null ? new JButton("Cancel") : new JButton(new ImageIcon(imageURL));
            this.myCancelButton.setToolTipText("Cancel");
            this.myCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!PluginProgressUnit.this.myPlugin.cancel()) {
                        PluginProgressUnit.stopThread(PluginProgressUnit.this.myCancelPlugin);
                    }
                    PluginProgressUnit.this.myCancelButton.setEnabled(false);
                    PluginProgressUnit.this.setProgress(100);
                }
            });
        } else {
            this.myCancelButton = null;
        }
        StringBuilder builder = new StringBuilder();
        int n = level * 4;
        for (int i = 0; i < n; ++i) {
            builder.append(" ");
        }
        String buttonName = this.myPlugin.getButtonName();
        if (buttonName.length() <= 20) {
            builder.append(buttonName);
            int n2 = 20 - buttonName.length();
            for (int i = 0; i < n2; ++i) {
                builder.append(" ");
            }
        } else {
            builder.append(buttonName.substring(0, 20));
        }
        JLabel pluginLabel = new JLabel(builder.toString());
        pluginLabel.setFont(new Font("Monospaced", 0, 14));
        top.add(pluginLabel);
        top.add(this.myProgress);
        if (this.myCancelButton != null) {
            top.add(this.myCancelButton);
        }
        this.add(top);
        this.myPlugin.addListener(this);
    }

    private static void stopThread(Plugin plugin) {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        PluginProgressUnit.visit(root, 0, plugin);
    }

    private static void visit(ThreadGroup group, int level, Plugin plugin) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            if (!(thread instanceof ThreadedPluginListener) || plugin != ((ThreadedPluginListener)thread).getPluginListener()) continue;
            try {
                thread.stop();
            }
            catch (Exception e) {
                // empty catch block
            }
            ProgressPanel.getInstance().cleanProgressUnit(plugin);
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            PluginProgressUnit.visit(groups[i], level + 1, plugin);
        }
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        this.setProgress(100);
    }

    @Override
    public void progress(PluginEvent event) {
        DataSet dataSet = (DataSet)event.getSource();
        List<Datum> datum = dataSet.getDataOfType(Integer.class);
        if (datum.size() != 1) {
            throw new IllegalArgumentException("PluginProgressUnit: progress: should be only one interger percent value.");
        }
        Integer percent = (Integer)datum.get(0).getData();
        this.setProgress(percent);
    }

    private void setProgress(int num) {
        if (this.myCurrentValue == num) {
            return;
        }
        this.myCurrentValue = num;
        this.myProgress.setValue(num);
        if (num == 100) {
            ProgressPanel.getInstance().removeProgressUnit(this);
        }
    }
}

