/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.statistics;

import net.maizegenetics.stats.math.ErrorFunction;

public class NormalDistribution {
    public static double pdf(double x, double m, double sd) {
        double a = 1.0 / (Math.sqrt(Math.PI * 2) * sd);
        double b = -(x - m) * (x - m) / (2.0 * sd * sd);
        return a * Math.exp(b);
    }

    public static double cdf(double x, double m, double sd) {
        double a = (x - m) / (Math.sqrt(2.0) * sd);
        return 0.5 * (1.0 + ErrorFunction.erf(a));
    }

    public static double quantile(double z, double m, double sd) {
        return m + Math.sqrt(2.0) * sd * ErrorFunction.inverseErf(2.0 * z - 1.0);
    }

    public static double mean(double m, double sd) {
        return m;
    }

    public static double variance(double m, double sd) {
        return sd * sd;
    }
}

