/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.NodeFactory;
import net.maizegenetics.taxa.tree.NodeUtils;
import net.maizegenetics.taxa.tree.SimpleTree;

public class NeighborJoiningTree
extends SimpleTree {
    private int numClusters;
    private Node newCluster;
    private int besti;
    private int abi;
    private int bestj;
    private int abj;
    private int[] alias;
    private double[][] distance;
    private double[] r;
    private double scale;

    public NeighborJoiningTree(DistanceMatrix m) {
        if (m.getSize() < 3) {
            new IllegalArgumentException("LESS THAN 3 TAXA IN DISTANCE MATRIX");
        }
        if (!m.isSymmetric()) {
            new IllegalArgumentException("UNSYMMETRIC DISTANCE MATRIX");
        }
        this.init(m);
        while (true) {
            this.findNextPair();
            this.newBranchLengths();
            if (this.numClusters == 3) break;
            this.newCluster();
        }
        this.finish();
    }

    private double getDist(int a, int b) {
        return this.distance[this.alias[a]][this.alias[b]];
    }

    private void init(DistanceMatrix m) {
        int i;
        this.numClusters = m.getSize();
        this.distance = m.getClonedDistances();
        for (i = 0; i < this.numClusters; ++i) {
            Node tmp = NodeFactory.createNode();
            tmp.setIdentifier(m.getTaxon(i));
            this.getRoot().addChild(tmp);
        }
        this.alias = new int[this.numClusters];
        for (i = 0; i < this.numClusters; ++i) {
            this.alias[i] = i;
        }
        this.r = new double[this.numClusters];
    }

    private void finish() {
        if (this.besti != 0 && this.bestj != 0) {
            this.getRoot().getChild(0).setBranchLength(this.updatedDistance(this.besti, this.bestj, 0));
        } else if (this.besti != 1 && this.bestj != 1) {
            this.getRoot().getChild(1).setBranchLength(this.updatedDistance(this.besti, this.bestj, 1));
        } else {
            this.getRoot().getChild(2).setBranchLength(this.updatedDistance(this.besti, this.bestj, 2));
        }
        this.distance = null;
        NodeUtils.lengths2Heights(this.getRoot());
    }

    private void findNextPair() {
        for (int i = 0; i < this.numClusters; ++i) {
            this.r[i] = 0.0;
            for (int j = 0; j < this.numClusters; ++j) {
                int n = i;
                this.r[n] = this.r[n] + this.getDist(i, j);
            }
        }
        this.besti = 0;
        this.bestj = 1;
        double smax = -1.0;
        this.scale = 1.0 / (double)(this.numClusters - 2);
        for (int i = 0; i < this.numClusters - 1; ++i) {
            for (int j = i + 1; j < this.numClusters; ++j) {
                double sij = (this.r[i] + this.r[j]) * this.scale - this.getDist(i, j);
                if (!(sij > smax)) continue;
                smax = sij;
                this.besti = i;
                this.bestj = j;
            }
        }
        this.abi = this.alias[this.besti];
        this.abj = this.alias[this.bestj];
    }

    private void newBranchLengths() {
        double dij = this.getDist(this.besti, this.bestj);
        double li = (dij + (this.r[this.besti] - this.r[this.bestj]) * this.scale) * 0.5;
        double lj = dij - li;
        this.getRoot().getChild(this.besti).setBranchLength(li);
        this.getRoot().getChild(this.bestj).setBranchLength(lj);
    }

    private void newCluster() {
        for (int k = 0; k < this.numClusters; ++k) {
            if (k == this.besti || k == this.bestj) continue;
            int ak = this.alias[k];
            double d = this.updatedDistance(this.besti, this.bestj, k);
            this.distance[this.abi][ak] = d;
            this.distance[ak][this.abi] = d;
        }
        this.distance[this.abi][this.abi] = 0.0;
        NodeUtils.joinChilds(this.getRoot(), this.besti, this.bestj);
        for (int i = this.bestj; i < this.numClusters - 1; ++i) {
            this.alias[i] = this.alias[i + 1];
        }
        --this.numClusters;
    }

    private double updatedDistance(int i, int j, int k) {
        return (this.getDist(k, i) + this.getDist(k, j) - this.getDist(i, j)) * 0.5;
    }
}

