/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import java.util.ArrayList;
import net.maizegenetics.trait.MarkerPhenotypeAdapter;

public class MarkerPhenotypeAdapterUtils {
    private MarkerPhenotypeAdapterUtils() {
    }

    public static void updateMissing(boolean[] missing1, boolean[] missing2) {
        int n = missing1.length;
        if (missing2.length != n) {
            throw new IllegalArgumentException("missing1 and missing2 must be the same length");
        }
        for (int i = 0; i < n; ++i) {
            missing1[i] = missing1[i] || missing2[i];
        }
    }

    public static void updateMissing(boolean[] missing, double[] data) {
        int n = missing.length;
        if (data.length != n) {
            throw new IllegalArgumentException("missing and data must be the same length");
        }
        for (int i = 0; i < n; ++i) {
            missing[i] = missing[i] || Double.isNaN(data[i]);
        }
    }

    public static void updateMissing(boolean[] missing, String[] labels) {
        int n = missing.length;
        if (labels.length != n) {
            throw new IllegalArgumentException("missing and labels must be the same length");
        }
        for (int i = 0; i < n; ++i) {
            missing[i] = missing[i] || MarkerPhenotypeAdapterUtils.isMissing(labels[i]);
        }
    }

    public static ArrayList<String[]> getFactorList(MarkerPhenotypeAdapter mpa, int phenotype, boolean[] missing) {
        int n = mpa.getNumberOfFactors();
        if (n == 0) {
            return null;
        }
        ArrayList<String[]> factorList = new ArrayList<String[]>(n);
        for (int i = 0; i < n; ++i) {
            factorList.add(mpa.getFactorValues(phenotype, i));
            MarkerPhenotypeAdapterUtils.updateMissing(missing, mpa.getMissingFactors(phenotype, i));
        }
        return factorList;
    }

    public static ArrayList<double[]> getCovariateList(MarkerPhenotypeAdapter mpa, int phenotype, boolean[] missing) {
        int n = mpa.getNumberOfCovariates();
        if (n == 0) {
            return null;
        }
        ArrayList<double[]> covariateList = new ArrayList<double[]>(n);
        for (int i = 0; i < n; ++i) {
            covariateList.add(mpa.getCovariateValues(phenotype, i));
            MarkerPhenotypeAdapterUtils.updateMissing(missing, mpa.getMissingCovariates(phenotype, i));
        }
        return covariateList;
    }

    public static boolean[] whichAreMissing(double[] doubleArray) {
        int n = doubleArray.length;
        boolean[] missing = new boolean[n];
        for (int i = 0; i < n; ++i) {
            missing[i] = Double.isNaN(doubleArray[i]);
        }
        return missing;
    }

    public static boolean[] whichAreMissing(String[] stringArray) {
        int n = stringArray.length;
        boolean[] missing = new boolean[n];
        for (int i = 0; i < n; ++i) {
            missing[i] = MarkerPhenotypeAdapterUtils.isMissing(stringArray[i]);
        }
        return missing;
    }

    public static boolean[] whichAreMissing(Object[] values) {
        int n = values.length;
        boolean[] missing = new boolean[n];
        if (values instanceof String[]) {
            String[] strvalues = (String[])values;
            for (int i = 0; i < n; ++i) {
                missing[i] = MarkerPhenotypeAdapterUtils.isMissing(strvalues[i]);
            }
        } else if (values instanceof Double[]) {
            Double[] dblvalues = (Double[])values;
            for (int i = 0; i < n; ++i) {
                missing[i] = MarkerPhenotypeAdapterUtils.isMissing(dblvalues[i]);
            }
        } else if (values instanceof Character[]) {
            Character[] chrvalues = (Character[])values;
            for (int i = 0; i < n; ++i) {
                missing[i] = MarkerPhenotypeAdapterUtils.isMissing(chrvalues[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                missing[i] = values[i] == null;
            }
        }
        return missing;
    }

    public static boolean areAnyMissing(Object[] values) {
        if (values instanceof String[]) {
            String[] strvalues;
            for (String str : strvalues = (String[])values) {
                if (!MarkerPhenotypeAdapterUtils.isMissing(str)) continue;
                return true;
            }
            return false;
        }
        if (values instanceof Double[]) {
            Double[] dblvalues;
            for (Double dbl : dblvalues = (Double[])values) {
                if (!MarkerPhenotypeAdapterUtils.isMissing(dbl)) continue;
                return true;
            }
            return false;
        }
        if (values instanceof Character[]) {
            Character[] chrvalues;
            for (Character chr : chrvalues = (Character[])values) {
                if (!MarkerPhenotypeAdapterUtils.isMissing(chr)) continue;
                return true;
            }
            return false;
        }
        for (Object val : values) {
            if (val != null) continue;
            return true;
        }
        return false;
    }

    public static boolean areAnyMissing(double[] values) {
        for (double val : values) {
            if (!Double.isNaN(val)) continue;
            return true;
        }
        return false;
    }

    public static int[] getNonMissingIndex(boolean[] missing) {
        int n = missing.length;
        int ntrue = 0;
        for (boolean miss : missing) {
            if (miss) continue;
            ++ntrue;
        }
        int[] nonmiss = new int[ntrue];
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (missing[i]) continue;
            nonmiss[count++] = i;
        }
        return nonmiss;
    }

    public static int numberNotMissing(boolean[] missing) {
        int numberNotMissing = 0;
        for (boolean m : missing) {
            if (m) continue;
            ++numberNotMissing;
        }
        return numberNotMissing;
    }

    public static boolean isMissing(Object value) {
        if (value instanceof Double) {
            return ((Double)value).isNaN();
        }
        if (value instanceof Character) {
            return value.equals(Character.valueOf('?'));
        }
        if (value instanceof String) {
            String val = (String)value;
            if (val.equals("?")) {
                return true;
            }
            return val.equals("N");
        }
        return false;
    }

    public static boolean isMissing(Double value) {
        return value.isNaN();
    }

    public static boolean isMissing(String value) {
        return value.equals("?") || value.equals("N");
    }

    public static boolean isMissing(Character value) {
        return value.equals(Character.valueOf('?')) || value.equals(Character.valueOf('N'));
    }
}

