/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.HashMap;
import java.util.Map;

public class ArgsEngine {
    private Map<String, Option> options = new HashMap<String, Option>();
    private boolean parseCalled = false;

    public void add(String shortForm, String longForm) {
        this.add(shortForm, longForm, false);
    }

    public void add(String shortForm, String longForm, boolean valued) {
        Option option = new Option(shortForm, longForm, valued);
        this.options.put(shortForm, option);
        this.options.put(longForm, option);
    }

    public void parse(String[] args) {
        this.parseCalled = true;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ((arg.startsWith("--") || arg.startsWith("-")) && this.options.containsKey(arg)) {
                Option option = this.options.get(arg);
                if (option.isValued()) {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                        throw new RuntimeException("Value required for option " + arg);
                    }
                    option.setValue(args[++i]);
                    continue;
                }
                option.setValue("not-null");
                continue;
            }
            throw new RuntimeException("Unrecognized option " + arg);
        }
    }

    public String getString(String key) {
        if (!this.parseCalled) {
            throw new IllegalStateException("Method parse not invoked");
        }
        Option option = this.options.get(key);
        return option != null ? (option.isValued() ? option.getValue() : null) : null;
    }

    public boolean getBoolean(String key) {
        if (!this.parseCalled) {
            throw new IllegalStateException("Method parse not invoked");
        }
        Option option = this.options.get(key);
        return option != null ? option.getValue() != null : false;
    }

    private static class Option {
        private String shortForm;
        private String longForm;
        private boolean valued;
        private String value;

        public Option(String shortForm, String longForm) {
            this.shortForm = shortForm;
            this.longForm = longForm;
        }

        public Option(String shortForm, String longForm, boolean valued) {
            this.shortForm = shortForm;
            this.longForm = longForm;
            this.valued = valued;
        }

        public String getShortForm() {
            return this.shortForm;
        }

        public String getLongForm() {
            return this.longForm;
        }

        public boolean isValued() {
            return this.valued;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

