/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public final class Utils {
    private static final Logger myLogger = Logger.getLogger(Utils.class);
    private static Collection<String> myJavaPackages = null;

    private Utils() {
    }

    public static String getBasename(String str) {
        int index = str.lastIndexOf(46);
        return str.substring(++index);
    }

    public static String getFilename(String str) {
        int indexForwardSlash = str.lastIndexOf(47);
        int indexBackwardSlash = str.lastIndexOf(92);
        int index = 0;
        index = indexForwardSlash == -1 && indexBackwardSlash == -1 ? 0 : (indexForwardSlash > indexBackwardSlash ? indexForwardSlash + 1 : indexBackwardSlash + 1);
        String result = str.substring(index);
        if (result.indexOf(46) > 0) {
            result = result.substring(0, result.indexOf(46));
        }
        return result;
    }

    public static String getFilename(String str, String suffix) {
        int indexForwardSlash = str.lastIndexOf(47);
        int indexBackwardSlash = str.lastIndexOf(92);
        int index = 0;
        index = indexForwardSlash == -1 && indexBackwardSlash == -1 ? 0 : (indexForwardSlash > indexBackwardSlash ? indexForwardSlash + 1 : indexBackwardSlash + 1);
        String result = str.substring(index);
        if (suffix != null && result.lastIndexOf(suffix) > 0) {
            result = result.substring(0, result.lastIndexOf(suffix));
        } else if (result.lastIndexOf(46) > 0) {
            result = result.substring(0, result.lastIndexOf(46));
        }
        return result;
    }

    public static String getDirectory(String str) {
        int index = str.lastIndexOf(File.separator);
        if (index == -1) {
            return ".";
        }
        return str.substring(0, index);
    }

    public static List<String> getFullyQualifiedClassNames(String simpleName) {
        if (myJavaPackages == null) {
            myJavaPackages = Utils.getJavaPackages();
        }
        ArrayList<String> fqns = new ArrayList<String>();
        for (String aPackage : myJavaPackages) {
            try {
                String fqn = aPackage + "." + simpleName;
                Class.forName(fqn);
                fqns.add(fqn);
            }
            catch (Exception e) {}
        }
        return fqns;
    }

    public static Collection<String> getJavaPackages() {
        String classpath = System.getProperty("java.class.path");
        return Utils.getPackagesFromClassPath(classpath);
    }

    public static Set<String> getPackagesFromClassPath(String classpath) {
        String[] paths;
        HashSet<String> packages = new HashSet<String>();
        for (String path : paths = classpath.split(File.pathSeparator)) {
            File file;
            if (path.trim().length() == 0 || !(file = new File(path)).exists()) continue;
            String childPath = file.getAbsolutePath();
            if (childPath.endsWith(".jar")) {
                packages.addAll(Utils.readZipFile(childPath));
                continue;
            }
            packages.addAll(Utils.readDirectory(childPath));
        }
        return packages;
    }

    public static Set<String> readDirectory(String path) {
        HashSet<String> packages = new HashSet<String>();
        File file = new File(path);
        int startIndex = path.length() + 1;
        for (File child : file.listFiles()) {
            Utils.recursiveRead(child, startIndex, packages);
        }
        return packages;
    }

    public static void recursiveRead(File file, int startIndex, Set<String> packages) {
        if (!file.isFile()) {
            packages.add(file.getAbsolutePath().substring(startIndex).replace(File.separator, "."));
            for (File child : file.listFiles()) {
                Utils.recursiveRead(child, startIndex, packages);
            }
        }
    }

    public static Set<String> readZipFile(String path) {
        HashSet<String> packages = new HashSet<String>();
        try {
            ZipFile zFile = new ZipFile(path);
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                String dirName;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (dirName = new File(entry.getName()).getParent()) == null) continue;
                String name = dirName.replace(File.separator, ".");
                if (name.endsWith(".")) {
                    name = name.substring(0, name.length() - 1);
                }
                packages.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packages;
    }

    public static String shortenStrLineLen(String str, int preferredLen) {
        return Utils.shortenStrLineLen(str, preferredLen, -1);
    }

    public static String shortenStrLineLen(String str, int preferredLen, int preferredLines) {
        StringBuilder buffer = new StringBuilder();
        int startIndex = 0;
        int endIndex = preferredLen;
        int strLen = str.length();
        int numLines = 0;
        while (startIndex < strLen - 1) {
            int place = str.indexOf(32, endIndex);
            int newLine = str.indexOf(10, startIndex);
            if (newLine != -1 && newLine < place) {
                place = newLine;
            }
            String part = null;
            if (place == -1) {
                part = str.substring(startIndex);
                buffer.append(part);
                buffer.append("\n");
                break;
            }
            part = str.substring(startIndex, ++place);
            buffer.append(part);
            buffer.append("\n");
            startIndex = place;
            endIndex = place + preferredLen;
            if (preferredLines <= 0 || ++numLines < preferredLines) continue;
            return buffer.toString();
        }
        return buffer.toString();
    }

    public static String addSuffixIfNeeded(String filename, String suffix) {
        String temp = filename.toLowerCase();
        if (suffix.charAt(0) != '.') {
            suffix = '.' + suffix;
        }
        if (temp.endsWith(suffix)) {
            return filename;
        }
        return filename + suffix;
    }

    public static String addSuffixIfNeeded(String filename, String defaultSuffix, String[] possible) {
        String temp = filename.toLowerCase();
        for (int i = 0; i < possible.length; ++i) {
            String current = possible[i].toLowerCase();
            if (current.charAt(0) != '.') {
                current = '.' + current;
            }
            if (!temp.endsWith(current)) continue;
            return filename;
        }
        if (defaultSuffix.charAt(0) != '.') {
            defaultSuffix = '.' + defaultSuffix;
        }
        return filename + defaultSuffix;
    }

    public static BufferedReader getBufferedReader(String inSourceName) {
        try {
            if (inSourceName.startsWith("http")) {
                if (inSourceName.endsWith(".gz")) {
                    return new BufferedReader(new InputStreamReader(new GZIPInputStream(new URL(inSourceName).openStream())));
                }
                return new BufferedReader(new InputStreamReader(new URL(inSourceName).openStream()));
            }
            if (inSourceName.endsWith(".gz")) {
                return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(inSourceName))));
            }
            return new BufferedReader(new InputStreamReader(new FileInputStream(inSourceName)));
        }
        catch (Exception e) {
            myLogger.error((Object)("getBufferedReader: Error getting reader for: " + inSourceName));
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getBufferedReader(String inSourceName, int bufSize) {
        try {
            if (bufSize < 1) {
                return Utils.getBufferedReader(inSourceName);
            }
            if (inSourceName.startsWith("http")) {
                if (inSourceName.endsWith(".gz")) {
                    return new BufferedReader(new InputStreamReader(new GZIPInputStream(new URL(inSourceName).openStream(), bufSize)), bufSize);
                }
                return new BufferedReader(new InputStreamReader(new URL(inSourceName).openStream()), bufSize);
            }
            if (inSourceName.endsWith(".gz")) {
                return new BufferedReader(new InputStreamReader(new GZIPInputStream((InputStream)new FileInputStream(inSourceName), bufSize)), bufSize);
            }
            return new BufferedReader(new InputStreamReader(new FileInputStream(inSourceName)), bufSize);
        }
        catch (Exception e) {
            myLogger.error((Object)("getBufferedReader: Error getting reader for: " + inSourceName));
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getBufferedReader(File file, int bufSize) {
        return Utils.getBufferedReader(file.getAbsolutePath(), bufSize);
    }

    public static BufferedWriter getBufferedWriter(String filename) {
        return Utils.getBufferedWriter(filename, false);
    }

    public static BufferedWriter getBufferedWriter(String filename, boolean append) {
        return Utils.getBufferedWriter(new File(filename), append);
    }

    public static BufferedWriter getBufferedWriter(File file) {
        return Utils.getBufferedWriter(file, false);
    }

    public static BufferedWriter getBufferedWriter(File file, boolean append) {
        String filename = null;
        try {
            filename = file.getCanonicalPath();
            if (filename.endsWith(".gz")) {
                return new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file, append))));
            }
            return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, append)));
        }
        catch (Exception e) {
            myLogger.error((Object)("getBufferedReader: Error getting reader for: " + filename));
            e.printStackTrace();
            return null;
        }
    }

    public static DataOutputStream getDataOutputStream(String filename, int bufSize) {
        try {
            if (filename.endsWith(".gz")) {
                return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream((OutputStream)new FileOutputStream(filename), bufSize)));
            }
            return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename), bufSize));
        }
        catch (Exception e) {
            myLogger.error((Object)("getDataOutputStream: Error getting reader for: " + filename));
            e.printStackTrace();
            return null;
        }
    }

    public static int findNthOccurrenceInString(String str, char match, int n) {
        int result = str.indexOf(match);
        while (--n > 0 && result != -1) {
            result = str.indexOf(match, result + 1);
        }
        return result;
    }

    public static long getMaxHeapSizeMB() {
        return Runtime.getRuntime().maxMemory() / 0x100000L;
    }

    public static InputStream getInputStream(String filename) {
        try {
            if (filename.startsWith("http")) {
                if (filename.endsWith(".gz")) {
                    return new GZIPInputStream(new URL(filename).openStream());
                }
                return new URL(filename).openStream();
            }
            if (filename.endsWith(".gz")) {
                return new GZIPInputStream(new FileInputStream(filename));
            }
            return new FileInputStream(filename);
        }
        catch (Exception e) {
            myLogger.error((Object)("getInputStream: Error getting reader for: " + filename));
            e.printStackTrace();
            return null;
        }
    }

    public static int getNumberLines(String filename) {
        InputStream input = Utils.getInputStream(filename);
        try {
            byte[] buffer = new byte[1024];
            int result = 0;
            int numChrsRead = 0;
            while ((numChrsRead = input.read(buffer)) != -1) {
                for (int i = 0; i < numChrsRead; ++i) {
                    if (buffer[i] != 10) continue;
                    ++result;
                }
            }
            int n = result;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Utils: getNumberLines: Problem getting number lines: " + filename);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
    }

    public static int getNumberLinesNotHashOrBlank(String filename) {
        InputStream input = Utils.getInputStream(filename);
        try {
            byte[] buffer = new byte[1024];
            int result = 0;
            boolean isHash = false;
            boolean isBlank = true;
            int numChrsRead = input.read(buffer);
            if (numChrsRead > 0) {
                boolean bl = isHash = buffer[0] == 35;
            }
            while (numChrsRead > 0) {
                for (int i = 0; i < numChrsRead - 1; ++i) {
                    if (buffer[i] == 10) {
                        if (isHash) {
                            isHash = false;
                        } else if (!isBlank) {
                            ++result;
                        }
                        if (buffer[i + 1] == 35) {
                            isHash = true;
                        }
                        isBlank = true;
                        continue;
                    }
                    isBlank = false;
                }
                if (buffer[numChrsRead - 1] == 10) {
                    if (isHash) {
                        isHash = false;
                    } else if (!isBlank) {
                        ++result;
                    }
                    numChrsRead = input.read(buffer);
                    if (numChrsRead > 0) {
                        isHash = buffer[0] == 35;
                    }
                    isBlank = true;
                    continue;
                }
                numChrsRead = input.read(buffer);
            }
            int n = result;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Utils: getNumberLinesNotHashOrBlank: Problem getting number lines: " + filename);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
    }

    public static String readLineSkipComments(BufferedReader br) throws IOException {
        String s = br.readLine();
        while (s.startsWith("#")) {
            s = br.readLine();
        }
        return s;
    }
}

