/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.io;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class RandomAccessFileImpl
implements IRandomAccessFile {
    private final RandomAccessFile randomAccessFile;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean changeByteOrder = ByteOrder.LITTLE_ENDIAN.equals(this.byteOrder);
    private long markedPosition = -1L;

    public RandomAccessFileImpl(RandomAccessFile randomAccessFile) {
        this.randomAccessFile = randomAccessFile;
    }

    public RandomAccessFileImpl(String name, String mode) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile = new RandomAccessFile(name, mode);
        }
        catch (FileNotFoundException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public RandomAccessFileImpl(File file, String mode) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile = new RandomAccessFile(file, mode);
        }
        catch (FileNotFoundException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    public final FileChannel getChannel() {
        return this.randomAccessFile.getChannel();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.changeByteOrder = ByteOrder.LITTLE_ENDIAN.equals(byteOrder);
    }

    public int read() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.read();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int read(byte[] b, int off, int len) throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.read(b, off, len);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int read(byte[] b) throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.read(b);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void readFully(byte[] b) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.readFully(b);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void readFully(byte[] b, int off, int len) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.readFully(b, off, len);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int skipBytes(int n) throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.skipBytes(n);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void write(int b) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void write(byte[] b) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void write(byte[] b, int off, int len) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.write(b, off, len);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public long getFilePointer() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.getFilePointer();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void seek(long pos) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.seek(pos);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public long length() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.length();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void setLength(long newLength) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.setLength(newLength);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void close() throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final boolean readBoolean() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.readBoolean();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final byte readByte() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.readByte();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final int readUnsignedByte() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.readUnsignedByte();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final short readShort() throws IOExceptionUnchecked {
        try {
            short s = this.randomAccessFile.readShort();
            return this.changeByteOrder ? NativeData.changeByteOrder(s) : s;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final int readUnsignedShort() throws IOExceptionUnchecked {
        return this.readShort() & 0xFFFF;
    }

    public final char readChar() throws IOExceptionUnchecked {
        try {
            char c = this.randomAccessFile.readChar();
            return this.changeByteOrder ? NativeData.changeByteOrder(c) : c;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final int readInt() throws IOExceptionUnchecked {
        try {
            int i = this.randomAccessFile.readInt();
            return this.changeByteOrder ? NativeData.changeByteOrder(i) : i;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final long readLong() throws IOExceptionUnchecked {
        try {
            long l = this.randomAccessFile.readLong();
            return this.changeByteOrder ? NativeData.changeByteOrder(l) : l;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final float readFloat() throws IOExceptionUnchecked {
        try {
            float f = this.randomAccessFile.readFloat();
            return this.changeByteOrder ? NativeData.changeByteOrder(f) : f;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final double readDouble() throws IOExceptionUnchecked {
        try {
            double d = this.randomAccessFile.readDouble();
            return this.changeByteOrder ? NativeData.changeByteOrder(d) : d;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final String readLine() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.readLine();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final String readUTF() throws IOExceptionUnchecked {
        try {
            return this.randomAccessFile.readUTF();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeBoolean(boolean v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeBoolean(v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeByte(int v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeByte(v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeShort(int v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeShort(this.changeByteOrder ? NativeData.changeByteOrder(v) : v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeChar(int v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeChar(this.changeByteOrder ? NativeData.changeByteOrder(v) : v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeInt(int v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeInt(this.changeByteOrder ? NativeData.changeByteOrder(v) : v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeLong(long v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeLong(this.changeByteOrder ? NativeData.changeByteOrder(v) : v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeFloat(float v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeFloat(this.changeByteOrder ? NativeData.changeByteOrder(v) : v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeDouble(double v) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeDouble(this.changeByteOrder ? NativeData.changeByteOrder(v) : v);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeBytes(String s) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeBytes(s);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeChars(String s) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeChars(s);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void writeUTF(String str) throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.writeUTF(str);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public long skip(long n) throws IOExceptionUnchecked {
        if (n <= 0L) {
            return 0L;
        }
        try {
            long pos = this.randomAccessFile.getFilePointer();
            long len = this.randomAccessFile.length();
            long newpos = Math.min(len, pos + n);
            this.randomAccessFile.seek(newpos);
            return (int)(newpos - pos);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int available() throws IOExceptionUnchecked {
        try {
            return (int)Math.min(this.randomAccessFile.length() - this.randomAccessFile.getFilePointer(), Integer.MAX_VALUE);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void mark(int readlimit) {
        try {
            this.markedPosition = this.randomAccessFile.getFilePointer();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void reset() throws IOExceptionUnchecked {
        if (this.markedPosition == -1L) {
            throw new IOExceptionUnchecked(new IOException("mark() not called"));
        }
        try {
            this.randomAccessFile.seek(this.markedPosition);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void flush() throws IOExceptionUnchecked {
    }

    public void synchronize() throws IOExceptionUnchecked {
        try {
            this.randomAccessFile.getFD().sync();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int hashCode() {
        return this.randomAccessFile.hashCode();
    }

    public boolean equals(Object obj) {
        return this.randomAccessFile.equals(obj);
    }

    public String toString() {
        return this.randomAccessFile.toString();
    }
}

