/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.namedthread;

import ch.systemsx.cisd.base.namedthread.PoolNameThread;
import java.util.concurrent.ThreadFactory;

public class NamingThreadFactory
implements ThreadFactory {
    private final String poolName;
    private boolean createDaemonThreads;
    private boolean addPoolName;
    private int threadCount;

    public NamingThreadFactory(String poolName) {
        this.poolName = poolName;
        this.addPoolName = true;
        this.createDaemonThreads = false;
        this.threadCount = 0;
    }

    public Thread newThread(Runnable r) {
        ++this.threadCount;
        String completePoolName = String.valueOf(this.poolName) + "-T" + this.threadCount;
        PoolNameThread thread = new PoolNameThread(r, completePoolName, this.addPoolName);
        thread.setDaemon(this.createDaemonThreads);
        return thread;
    }

    String getPoolName() {
        return this.poolName;
    }

    public final boolean isCreateDaemonThreads() {
        return this.createDaemonThreads;
    }

    public final void setCreateDaemonThreads(boolean createDaemonThreads) {
        this.createDaemonThreads = createDaemonThreads;
    }

    public final int getThreadCount() {
        return this.threadCount;
    }

    public final boolean isAddPoolName() {
        return this.addPoolName;
    }

    public final void setAddPoolName(boolean addPoolName) {
        this.addPoolName = addPoolName;
    }
}

