/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5EnumerationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HDF5EnumerationValue {
    private final HDF5EnumerationType type;
    private final int ordinal;

    public HDF5EnumerationValue(HDF5EnumerationType type, Enum<?> value) throws IllegalArgumentException {
        this(type, value.name());
    }

    public HDF5EnumerationValue(HDF5EnumerationType type, int ordinal) throws IllegalArgumentException {
        assert (type != null);
        if (ordinal < 0 || ordinal >= type.getValueArray().length) {
            throw new IllegalArgumentException("valueIndex " + ordinal + " out of allowed range [0.." + (type.getValueArray().length - 1) + "] of type '" + type.getName() + "'.");
        }
        this.type = type;
        this.ordinal = ordinal;
    }

    public HDF5EnumerationValue(HDF5EnumerationType type, String value) throws IllegalArgumentException {
        assert (type != null);
        assert (value != null);
        Integer valueIndexOrNull = type.tryGetIndexForValue(value);
        if (valueIndexOrNull == null) {
            throw new IllegalArgumentException("Value '" + value + "' is not allowed for type '" + type.getName() + "'.");
        }
        this.type = type;
        this.ordinal = valueIndexOrNull;
    }

    public HDF5EnumerationType getType() {
        return this.type;
    }

    public String getValue() {
        return this.type.getValueArray()[this.ordinal];
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public <T extends Enum<T>> T getValue(Class<T> enumClass) {
        return Enum.valueOf(enumClass, this.getValue());
    }

    public String getDescription() {
        return String.valueOf(this.type.getName()) + " [" + this.type.getValueArray()[this.ordinal] + "]";
    }

    byte[] toStorageForm() {
        return this.type.toStorageForm(this.ordinal);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.ordinal;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5EnumerationValue other = (HDF5EnumerationValue)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return this.ordinal == other.ordinal;
    }

    public String toString() {
        return this.getValue();
    }
}

