/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;

public final class HDF5GenericStorageFeatures
extends HDF5AbstractStorageFeatures {
    public static final HDF5GenericStorageFeatures GENERIC_NO_COMPRESSION = new HDF5GenericStorageFeatures(null, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_NO_COMPRESSION_KEEP = new HDF5GenericStorageFeatures(null, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_NO_COMPRESSION_DELETE = new HDF5GenericStorageFeatures(null, false, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_COMPACT = new HDF5GenericStorageFeatures(HDF5StorageLayout.COMPACT, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_COMPACT_KEEP = new HDF5GenericStorageFeatures(HDF5StorageLayout.COMPACT, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_COMPACT_DELETE = new HDF5GenericStorageFeatures(HDF5StorageLayout.COMPACT, false, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CONTIGUOUS = new HDF5GenericStorageFeatures(HDF5StorageLayout.CONTIGUOUS, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CONTIGUOUS_KEEP = new HDF5GenericStorageFeatures(HDF5StorageLayout.CONTIGUOUS, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CONTIGUOUS_DELETE = new HDF5GenericStorageFeatures(HDF5StorageLayout.CONTIGUOUS, false, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CHUNKED = new HDF5GenericStorageFeatures(HDF5StorageLayout.CHUNKED, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CHUNKED_KEEP = new HDF5GenericStorageFeatures(HDF5StorageLayout.CHUNKED, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CHUNKED_DELETE = new HDF5GenericStorageFeatures(HDF5StorageLayout.CHUNKED, false, true, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE = new HDF5GenericStorageFeatures(null, 6, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_KEEP = new HDF5GenericStorageFeatures(null, true, 6, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_DELETE = new HDF5GenericStorageFeatures(null, false, true, 6, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_MAX = new HDF5GenericStorageFeatures(null, 9, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_MAX_KEEP = new HDF5GenericStorageFeatures(null, true, 9, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_MAX_DELETE = new HDF5GenericStorageFeatures(null, false, true, 9, -1);

    public static HDF5GenericStorageFeatures createDeflation(int deflationLevel) {
        return HDF5GenericStorageFeatures.createDeflation(deflationLevel, false);
    }

    public static HDF5GenericStorageFeatures createDeflationKeep(int deflationLevel) {
        return HDF5GenericStorageFeatures.createDeflation(deflationLevel, true);
    }

    private static HDF5GenericStorageFeatures createDeflation(int deflationLevel, boolean keepExistingDataSetIfExists) {
        if (deflationLevel == 0) {
            return GENERIC_NO_COMPRESSION;
        }
        if (deflationLevel == 6) {
            return GENERIC_DEFLATE;
        }
        if (deflationLevel == 9) {
            return GENERIC_DEFLATE_MAX;
        }
        return new HDF5GenericStorageFeatures(null, keepExistingDataSetIfExists, HDF5GenericStorageFeatures.toByte(deflationLevel), -1);
    }

    static HDF5GenericStorageFeatures getCompression(boolean deflate) {
        return deflate ? GENERIC_DEFLATE : GENERIC_NO_COMPRESSION;
    }

    HDF5GenericStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, byte deflateLevel, byte scalingFactor) {
        this(proposedLayoutOrNull, false, deflateLevel, scalingFactor);
    }

    HDF5GenericStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, boolean keepDataSetIfExists, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, keepDataSetIfExists, false, deflateLevel, scalingFactor);
    }

    HDF5GenericStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, boolean keepDataSetIfExists, boolean deleteDataSetIfExists, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, keepDataSetIfExists, deleteDataSetIfExists, deflateLevel, scalingFactor);
    }

    boolean isCompatibleWithDataClass(int dataClassId) {
        return true;
    }
}

