/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5IntWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

class HDF5IntWriter
implements IHDF5IntWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5IntWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    public void setIntAttribute(String objectPath, String name, int value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_I32LE, HDF5Constants.H5T_NATIVE_INT32, new int[]{value});
    }

    public void setIntArrayAttribute(final String objectPath, final String name, final int[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT32, value.length, registry);
                int storageTypeId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I32LE, value.length, registry);
                HDF5IntWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void setIntMDArrayAttribute(final String objectPath, final String name, final MDIntArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT32, value.dimensions(), registry);
                int storageTypeId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I32LE, value.dimensions(), registry);
                HDF5IntWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    public void setIntMatrixAttribute(String objectPath, String name, int[][] value) {
        this.setIntMDArrayAttribute(objectPath, name, new MDIntArray(value));
    }

    public void writeInt(String objectPath, int value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I32LE, HDF5Constants.H5T_NATIVE_INT32, value);
    }

    public void writeIntArray(String objectPath, int[] data) {
        this.writeIntArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeIntArray(final String objectPath, final int[] data, final HDF5IntStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5IntWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, new long[]{data.length}, 4, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT32, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createIntArray(String objectPath, int size) {
        this.createIntArray(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createIntArray(String objectPath, long size, int blockSize) {
        this.createIntArray(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createIntArray(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5IntWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, features, new long[1], new long[]{size}, 4, registry);
                } else {
                    HDF5IntWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, features, new long[]{size}, null, 4, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createIntArray(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5IntWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, features, new long[]{size}, new long[]{blockSize}, 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeIntArrayBlock(String objectPath, int[] data, long blockNumber) {
        this.writeIntArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeIntArrayBlockWithOffset(final String objectPath, final int[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5IntWriter)HDF5IntWriter.this).baseWriter.fileId, objectPath, ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeIntMatrix(String objectPath, int[][] data) {
        this.writeIntMatrix(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeIntMatrix(String objectPath, int[][] data, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeIntMDArray(objectPath, new MDIntArray(data), features);
    }

    public void createIntMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.createIntMatrix(objectPath, 0L, 0L, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createIntMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.createIntMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createIntMatrix(final String objectPath, final long sizeX, final long sizeY, final int blockSizeX, final int blockSizeY, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{sizeX, sizeY};
                long[] blockDimensions = new long[]{blockSizeX, blockSizeY};
                HDF5IntWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, features, dimensions, blockDimensions, 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeIntMatrixBlock(String objectPath, int[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeIntMDArrayBlock(objectPath, new MDIntArray(data), new long[]{blockNumberX, blockNumberY});
    }

    public void writeIntMatrixBlockWithOffset(String objectPath, int[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeIntMDArrayBlockWithOffset(objectPath, new MDIntArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    public void writeIntMatrixBlockWithOffset(String objectPath, int[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeIntMDArrayBlockWithOffset(objectPath, new MDIntArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    public void writeIntMDArray(String objectPath, MDIntArray data) {
        this.writeIntMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeIntMDArray(final String objectPath, final MDIntArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5IntWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, data.longDimensions(), 4, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT32, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createIntMDArray(String objectPath, int[] dimensions) {
        this.createIntMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createIntMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createIntMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createIntMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5IntWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, features, nullDimensions, MDArray.toLong(dimensions), 4, registry);
                } else {
                    HDF5IntWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, features, MDArray.toLong(dimensions), null, 4, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createIntMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5IntWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I32LE : HDF5Constants.H5T_STD_U32LE, features, dimensions, MDArray.toLong(blockDimensions), 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeIntMDArrayBlock(String objectPath, MDIntArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeIntMDArrayBlockWithOffset(objectPath, data, offset);
    }

    public void writeIntMDArrayBlockWithOffset(final String objectPath, final MDIntArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5IntWriter)HDF5IntWriter.this).baseWriter.fileId, objectPath, ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeIntMDArrayBlockWithOffset(final String objectPath, final MDIntArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5IntWriter)HDF5IntWriter.this).baseWriter.fileId, objectPath, ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5IntWriter)HDF5IntWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

