/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HDF5Utils {
    @Private
    static final int MIN_CHUNK_SIZE = 1;
    private static final long MIN_TOTAL_SIZE_FOR_CHUNKING = 128L;
    static final long[] SCALAR_DIMENSIONS = new long[]{1L};
    static final String TYPE_VARIANT_ATTRIBUTE = "__TYPE_VARIANT__";
    static final String TYPE_VARIANT_MEMBERS_ATTRIBUTE = "__TYPE_VARIANT_MEMBERS__";
    static final String ENUM_TYPE_NAME_ATTRIBUTE = "__ENUM_TYPE_NAME__";
    static final String DATATYPE_GROUP = "/__DATA_TYPES__";
    static final String OPAQUE_PREFIX = "Opaque_";
    static final String ENUM_PREFIX = "Enum_";
    static final String TIMESTAMP_PREFIX = "Timestamp_";
    static final String COMPOUND_PREFIX = "Compound_";
    static final String BOOLEAN_DATA_TYPE = "/__DATA_TYPES__/Enum_Boolean";
    static final String TIMESTAMP_DATA_TYPE = "/__DATA_TYPES__/Timestamp_MilliSecondsSinceStartOfTheEpoch";
    static final String TYPE_VARIANT_DATA_TYPE = "/__DATA_TYPES__/Enum_TypeVariant";
    static final String VARIABLE_LENGTH_STRING_DATA_TYPE = "/__DATA_TYPES__/String_VariableLength";
    static final String DATASET_IS_EMPTY_LEGACY_ATTRIBUTE = "__EMPTY__";
    static Class<?>[] allIntegerTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class};
    static Class<?>[] allFloatTypes = new Class[]{Float.TYPE, Float.class, Double.TYPE, Double.class};
    static Class<?>[] allTimeDurationTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, HDF5TimeDuration.class};

    HDF5Utils() {
    }

    static Class<?> unwrapClass(Class<?> clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return clazz;
    }

    static String getSuperGroup(String path) {
        assert (path != null);
        int lastIndexSlash = path.lastIndexOf(47);
        if (lastIndexSlash <= 0) {
            return "/";
        }
        return path.substring(0, lastIndexSlash);
    }

    static boolean isEmpty(long[] dimensions) {
        long[] lArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            if (d == 0L) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean isNonPositive(long[] dimensions) {
        long[] lArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            if (d <= 0L) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static long[] tryGetChunkSizeForString(int len, boolean tryChunkedDS) {
        if (tryChunkedDS) {
            return (long)len < 128L ? null : SCALAR_DIMENSIONS;
        }
        return null;
    }

    static long[] tryGetChunkSize(long[] dimensions, int elementLength, boolean tryChunkedDS, boolean enforceChunkedDS) {
        assert (dimensions != null);
        if (!enforceChunkedDS && !tryChunkedDS) {
            return null;
        }
        long[] chunkSize = new long[dimensions.length];
        long totalSize = elementLength;
        int i = 0;
        while (i < dimensions.length) {
            totalSize *= dimensions[i];
            chunkSize[i] = Math.max(1L, dimensions[i]);
            ++i;
        }
        if (!enforceChunkedDS && totalSize < 128L) {
            return null;
        }
        return chunkSize;
    }

    static String createDataTypePath(String name, String ... appendices) {
        if (appendices.length == 1 && appendices[0].startsWith("/")) {
            return appendices[0];
        }
        StringBuilder builder = new StringBuilder();
        builder.append(DATATYPE_GROUP);
        builder.append('/');
        builder.append(name);
        String[] stringArray = appendices;
        int n = appendices.length;
        int n2 = 0;
        while (n2 < n) {
            String app = stringArray[n2];
            builder.append(app);
            ++n2;
        }
        return builder.toString();
    }

    static String getDataTypeNameFromPath(String pathOrNull, HDF5DataClass dataClass) {
        return pathOrNull == null ? "UNKNOWN" : HDF5Utils.tryGetDataTypeNameFromPath(pathOrNull, dataClass);
    }

    static String tryGetDataTypeNameFromPath(String pathOrNull, HDF5DataClass dataClass) {
        if (pathOrNull == null) {
            return null;
        }
        String prefix = HDF5Utils.getPrefixForDataClass(dataClass);
        String pathPrefix = HDF5Utils.createDataTypePath(prefix, new String[0]);
        if (pathOrNull.startsWith(pathPrefix)) {
            return pathOrNull.substring(pathPrefix.length());
        }
        int lastPathSepIdx = pathOrNull.lastIndexOf(47);
        if (lastPathSepIdx >= 0) {
            return pathOrNull.substring(lastPathSepIdx + 1);
        }
        return pathOrNull;
    }

    static String getPrefixForDataClass(HDF5DataClass dataClass) {
        switch (dataClass) {
            case COMPOUND: {
                return COMPOUND_PREFIX;
            }
            case ENUM: {
                return ENUM_PREFIX;
            }
            case OPAQUE: {
                return OPAQUE_PREFIX;
            }
        }
        return "";
    }

    static int getOneDimensionalArraySize(int[] dimensions) {
        assert (dimensions != null);
        if (dimensions.length == 0) {
            return 1;
        }
        if (dimensions.length != 1) {
            throw new HDF5JavaException("Data Set is expected to be of rank 1 (rank=" + dimensions.length + ")");
        }
        return dimensions[0];
    }

    static int getOneDimensionalArraySize(long[] dimensions) {
        assert (dimensions != null);
        if (dimensions.length == 0) {
            return 1;
        }
        if (dimensions.length != 1) {
            throw new HDF5JavaException("Data Set is expected to be of rank 1 (rank=" + dimensions.length + ")");
        }
        int length = (int)dimensions[0];
        if ((long)length != dimensions[0]) {
            throw new HDF5JavaException("Length is too large (" + dimensions[0] + ")");
        }
        return length;
    }

    static String createTypeVariantAttributeName(String attributeName) {
        return TYPE_VARIANT_ATTRIBUTE + attributeName + "__";
    }

    static boolean isInternalName(String name) {
        return name.startsWith("__") && name.endsWith("__");
    }

    static List<String> removeInternalNames(List<String> names) {
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String memberName = iterator.next();
            if (!HDF5Utils.isInternalName(memberName)) continue;
            iterator.remove();
        }
        return names;
    }

    static <T> T[] createArray(Class<T> componentClass, int vectorLength) {
        Object[] value = (Object[])Array.newInstance(componentClass, vectorLength);
        return value;
    }

    static boolean mightBeEmptyInStorage(long[] dimensions) {
        long[] lArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            if (d != 1L) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean areMatrixDimensionsConsistent(Object a) {
        if (!a.getClass().isArray()) {
            return false;
        }
        int length = Array.getLength(a);
        if (length == 0) {
            return true;
        }
        Object element = Array.get(a, 0);
        if (element.getClass().isArray()) {
            int elementLength = Array.getLength(element);
            int i = 0;
            while (i < length) {
                Object o = Array.get(a, i);
                if (!HDF5Utils.areMatrixDimensionsConsistent(o)) {
                    return false;
                }
                if (elementLength != Array.getLength(o)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    static boolean isInBounds(long[] dimensions, long[] subDimensions) {
        assert (dimensions.length == subDimensions.length);
        int i = 0;
        while (i < dimensions.length) {
            if (subDimensions[i] > dimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

