/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import java.io.UnsupportedEncodingException;

public final class StringUtils {
    private StringUtils() {
    }

    public static byte[] toBytes0Term(String s, int maxLength, CharacterEncoding encoding) {
        try {
            return (String.valueOf(StringUtils.cut(s, maxLength)) + '\u0000').getBytes(encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return (String.valueOf(StringUtils.cut(s, maxLength)) + '\u0000').getBytes();
        }
    }

    static byte[] toBytes0Term(String[] in, int maxLength, CharacterEncoding encoding) {
        int nelems = in.length;
        int realMaxLength = (encoding == CharacterEncoding.UTF8 ? 2 : 1) * maxLength + 1;
        byte[] out = new byte[nelems * realMaxLength];
        int i = 0;
        while (i < nelems) {
            byte[] bytes = StringUtils.toBytes0Term(in[i], maxLength, encoding);
            System.arraycopy(bytes, 0, out, i * realMaxLength, bytes.length);
            ++i;
        }
        return out;
    }

    static String fromBytes0Term(byte[] data, CharacterEncoding encoding) {
        return StringUtils.fromBytes0Term(data, 0, data.length, encoding);
    }

    static String fromBytes0Term(byte[] data, int startIdx, int maxEndIdx, CharacterEncoding encoding) {
        int termIdx = startIdx;
        while (termIdx < maxEndIdx && data[termIdx] != 0) {
            ++termIdx;
        }
        try {
            return new String(data, startIdx, termIdx - startIdx, encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(data, startIdx, termIdx - startIdx);
        }
    }

    private static String cut(String s, int maxLength) {
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }
}

