/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivingStrategy {
    private List<Pattern> fileWhiteListOrNull;
    private List<Pattern> fileBlackListOrNull;
    private List<Pattern> dirWhiteListOrNull;
    private List<Pattern> dirBlackListOrNull;
    private List<Pattern> compressionWhiteListOrNull;
    private boolean compressAll;
    public static final ArchivingStrategy DEFAULT = new ArchivingStrategy();

    public final void setCompressAll(boolean compressAll) {
        this.compressAll = compressAll;
    }

    private List<Pattern> getOrCreateFileWhiteList() {
        if (this.fileWhiteListOrNull == null) {
            this.fileWhiteListOrNull = new ArrayList<Pattern>();
        }
        return this.fileWhiteListOrNull;
    }

    private List<Pattern> getOrCreateFileBlackList() {
        if (this.fileBlackListOrNull == null) {
            this.fileBlackListOrNull = new ArrayList<Pattern>();
        }
        return this.fileBlackListOrNull;
    }

    private List<Pattern> getOrCreateDirWhiteList() {
        if (this.dirWhiteListOrNull == null) {
            this.dirWhiteListOrNull = new ArrayList<Pattern>();
        }
        return this.dirWhiteListOrNull;
    }

    private List<Pattern> getOrCreateDirBlackList() {
        if (this.dirBlackListOrNull == null) {
            this.dirBlackListOrNull = new ArrayList<Pattern>();
        }
        return this.dirBlackListOrNull;
    }

    private List<Pattern> getOrCreateCompressionWhiteList() {
        if (this.compressionWhiteListOrNull == null) {
            this.compressionWhiteListOrNull = new ArrayList<Pattern>();
        }
        return this.compressionWhiteListOrNull;
    }

    public ArchivingStrategy addToFileWhiteList(Pattern pattern) {
        this.getOrCreateFileWhiteList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToFileWhiteList(String pattern) {
        this.getOrCreateFileWhiteList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToFileBlackList(Pattern pattern) {
        this.getOrCreateFileBlackList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToFileBlackList(String pattern) {
        this.getOrCreateFileBlackList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToDirWhiteList(Pattern pattern) {
        this.getOrCreateDirWhiteList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToDirWhiteList(String pattern) {
        this.getOrCreateDirWhiteList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToDirBlackList(Pattern pattern) {
        this.getOrCreateDirBlackList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToDirBlackList(String pattern) {
        this.getOrCreateDirBlackList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToCompressionWhiteList(Pattern pattern) {
        this.getOrCreateCompressionWhiteList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToCompressionWhiteList(String pattern) {
        this.getOrCreateCompressionWhiteList().add(Pattern.compile(pattern));
        return this;
    }

    public boolean doStoreOwnerAndPermissions() {
        return true;
    }

    public boolean doExclude(String path, boolean isDirectory) {
        if (isDirectory) {
            return !ArchivingStrategy.match(this.dirBlackListOrNull, this.dirWhiteListOrNull, path);
        }
        return !ArchivingStrategy.match(this.fileBlackListOrNull, this.fileWhiteListOrNull, path);
    }

    public HDF5GenericStorageFeatures doCompress(String path) {
        if (this.compressAll) {
            return HDF5GenericStorageFeatures.GENERIC_DEFLATE;
        }
        if (this.compressionWhiteListOrNull == null) {
            return HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION;
        }
        return ArchivingStrategy.match(null, this.compressionWhiteListOrNull, path) ? HDF5GenericStorageFeatures.GENERIC_DEFLATE : HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION;
    }

    private static boolean match(Iterable<Pattern> blackListOrNull, Iterable<Pattern> whiteListOrNull, String path) {
        if (blackListOrNull != null) {
            for (Pattern p : blackListOrNull) {
                if (!p.matcher(path).matches()) continue;
                return false;
            }
        }
        if (whiteListOrNull == null) {
            return true;
        }
        for (Pattern p : whiteListOrNull) {
            if (!p.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }
}

