/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.StringUtils;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.LinkStore;
import ch.systemsx.cisd.hdf5.h5ar.ListArchiveException;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryIndex
implements Iterable<LinkRecord>,
Closeable,
Flushable {
    private static final String CRC32_ATTRIBUTE_NAME = "CRC32";
    private final IHDF5Reader hdf5Reader;
    private final IHDF5Writer hdf5WriterOrNull;
    private final String groupPath;
    private final IErrorStrategy errorStrategy;
    private final Set<Flushable> flushables;
    private LinkStore links;
    private boolean readLinkTargets;
    private boolean dirty;

    public static List<LinkRecord> convertFilesToLinks(File[] files, boolean storeOwnerAndPermissions, IErrorStrategy errorStrategy) {
        LinkedList<LinkRecord> list = new LinkedList<LinkRecord>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            list.add(LinkRecord.tryCreate(file, storeOwnerAndPermissions, errorStrategy));
            ++n2;
        }
        return list;
    }

    private static HDF5EnumerationType getHDF5LinkTypeEnumeration(IHDF5Reader reader) {
        return reader.enums().getType("linkType", DirectoryIndex.getFileLinkTypeValues());
    }

    private static HDF5CompoundType<LinkRecord> getHDF5LinkCompoundType(IHDF5Reader reader) {
        return DirectoryIndex.getHDF5LinkCompoundType(reader, DirectoryIndex.getHDF5LinkTypeEnumeration(reader));
    }

    private static HDF5CompoundType<LinkRecord> getHDF5LinkCompoundType(IHDF5Reader reader, HDF5EnumerationType hdf5LinkTypeEnumeration) {
        return reader.compounds().getType(LinkRecord.class, DirectoryIndex.getMapping(hdf5LinkTypeEnumeration));
    }

    private static String[] getFileLinkTypeValues() {
        FileLinkType[] fileLinkTypes = FileLinkType.values();
        String[] values = new String[fileLinkTypes.length];
        int i = 0;
        while (i < values.length) {
            values[i] = fileLinkTypes[i].name();
            ++i;
        }
        return values;
    }

    private static HDF5CompoundMemberMapping[] getMapping(HDF5EnumerationType linkEnumerationType) {
        return new HDF5CompoundMemberMapping[]{HDF5CompoundMemberMapping.mapping("linkNameLength"), HDF5CompoundMemberMapping.mapping("linkType").enumType(linkEnumerationType), HDF5CompoundMemberMapping.mapping("size"), HDF5CompoundMemberMapping.mapping("lastModified"), HDF5CompoundMemberMapping.mapping("uid"), HDF5CompoundMemberMapping.mapping("gid"), HDF5CompoundMemberMapping.mapping("permissions"), HDF5CompoundMemberMapping.mapping("checksum").fieldName("crc32")};
    }

    DirectoryIndex(IHDF5Reader hdf5Reader, String groupPath, IErrorStrategy errorStrategy, boolean readLinkTargets) {
        assert (hdf5Reader != null);
        assert (groupPath != null);
        this.hdf5Reader = hdf5Reader;
        IHDF5Writer iHDF5Writer = this.hdf5WriterOrNull = hdf5Reader instanceof IHDF5Writer ? (IHDF5Writer)hdf5Reader : null;
        if (this.hdf5WriterOrNull != null) {
            this.hdf5WriterOrNull.addFlushable(this);
        }
        this.groupPath = groupPath.length() == 0 ? "/" : groupPath;
        this.errorStrategy = errorStrategy;
        this.flushables = new LinkedHashSet<Flushable>();
        this.readIndex(readLinkTargets);
    }

    boolean addFlushable(Flushable flushable) {
        return this.flushables.add(flushable);
    }

    boolean removeFlushable(Flushable flushable) {
        return this.flushables.remove(flushable);
    }

    void flushExternals() {
        for (Flushable f : this.flushables) {
            try {
                f.flush();
            }
            catch (Exception ex) {
                System.err.println("External flushable throws an exception:");
                ex.printStackTrace();
            }
        }
    }

    public void amendLinkTargets() {
        if (this.readLinkTargets) {
            return;
        }
        this.links.amendLinkTargets(this.hdf5Reader, this.groupPath);
        this.readLinkTargets = true;
    }

    private String getIndexDataSetName() {
        return String.valueOf(this.groupPath) + "/__INDEX__";
    }

    private String getIndexNamesDataSetName() {
        return String.valueOf(this.groupPath) + "/__INDEXNAMES__";
    }

    private void readIndex(boolean withLinkTargets) {
        boolean readingH5ArIndexWorked = false;
        try {
            if (this.hdf5Reader.exists(this.getIndexDataSetName()) && this.hdf5Reader.exists(this.getIndexNamesDataSetName())) {
                int crc32Stored;
                HDF5CompoundType<LinkRecord> linkCompoundType = DirectoryIndex.getHDF5LinkCompoundType(this.hdf5Reader);
                final CRC32 crc32Digester = new CRC32();
                String indexDataSetName = this.getIndexDataSetName();
                LinkRecord[] work = this.hdf5Reader.compounds().readArray(indexDataSetName, linkCompoundType, new IHDF5CompoundInformationRetriever.IByteArrayInspector(){

                    public void inspect(byte[] byteArray) {
                        crc32Digester.update(byteArray);
                    }
                });
                int crc32 = (int)crc32Digester.getValue();
                if (crc32 != (crc32Stored = this.hdf5Reader.getIntAttribute(indexDataSetName, CRC32_ATTRIBUTE_NAME))) {
                    throw new ListArchiveException(this.groupPath, "CRC checksum mismatch on index (links). Expected: " + Utils.crc32ToString(crc32Stored) + ", found: " + Utils.crc32ToString(crc32));
                }
                String indexNamesDataSetName = this.getIndexNamesDataSetName();
                String concatenatedNames = this.hdf5Reader.readString(indexNamesDataSetName);
                crc32 = this.calcCrc32(concatenatedNames);
                if (crc32 != (crc32Stored = this.hdf5Reader.getIntAttribute(indexNamesDataSetName, CRC32_ATTRIBUTE_NAME))) {
                    throw new ListArchiveException(this.groupPath, "CRC checksum mismatch on index (names). Expected: " + Utils.crc32ToString(crc32Stored) + ", found: " + Utils.crc32ToString(crc32));
                }
                this.initLinks(work, concatenatedNames, withLinkTargets);
                this.links = new LinkStore(work);
                readingH5ArIndexWorked = true;
            }
        }
        catch (RuntimeException ex) {
            this.errorStrategy.dealWithError(new ListArchiveException(this.groupPath, ex));
        }
        if (!readingH5ArIndexWorked) {
            if (this.hdf5Reader.isGroup(this.groupPath, false)) {
                List<HDF5LinkInformation> hdf5LinkInfos = this.hdf5Reader.getGroupMemberInformation(this.groupPath, withLinkTargets);
                Object[] work = new LinkRecord[hdf5LinkInfos.size()];
                int idx = 0;
                for (HDF5LinkInformation linfo : hdf5LinkInfos) {
                    long size = linfo.isDataSet() ? this.hdf5Reader.getSize(linfo.getPath()) : -1L;
                    work[idx++] = new LinkRecord(linfo, size);
                }
                Arrays.sort(work);
                this.links = new LinkStore((LinkRecord[])work);
            } else {
                this.links = new LinkStore();
            }
        }
        this.readLinkTargets = withLinkTargets;
        this.dirty = false;
    }

    private void initLinks(LinkRecord[] work, String concatenatedNames, boolean withLinkTargets) {
        int namePos = 0;
        LinkRecord[] linkRecordArray = work;
        int n = work.length;
        int n2 = 0;
        while (n2 < n) {
            LinkRecord link = linkRecordArray[n2];
            namePos = link.initAfterReading(concatenatedNames, namePos, this.hdf5Reader, this.groupPath, withLinkTargets);
            ++n2;
        }
    }

    public boolean exists(String name) {
        return this.links.exists(name);
    }

    public boolean isDirectory(String name) {
        LinkRecord link = this.links.tryGetLink(name);
        return link != null && link.isDirectory();
    }

    public LinkRecord tryGetLink(String name) {
        LinkRecord linkOrNull = this.links.tryGetLink(name);
        if (linkOrNull != null) {
            linkOrNull.resetVerification();
        }
        return linkOrNull;
    }

    public boolean hasLinkTargets() {
        return this.readLinkTargets;
    }

    @Override
    public Iterator<LinkRecord> iterator() {
        return this.links.iterator();
    }

    @Override
    public void flush() {
        this.flushExternals();
        if (!this.dirty) {
            return;
        }
        this.ensureWriteMode();
        try {
            StringBuilder concatenatedNames = new StringBuilder();
            for (LinkRecord link : this.links) {
                link.prepareForWriting(concatenatedNames);
            }
            String indexNamesDataSetName = this.getIndexNamesDataSetName();
            String concatenatedNamesStr = concatenatedNames.toString();
            this.hdf5WriterOrNull.writeStringVariableLength(indexNamesDataSetName, concatenatedNamesStr);
            this.hdf5WriterOrNull.setIntAttribute(indexNamesDataSetName, CRC32_ATTRIBUTE_NAME, this.calcCrc32(concatenatedNamesStr));
            String indexDataSetName = this.getIndexDataSetName();
            final CRC32 crc32 = new CRC32();
            this.hdf5WriterOrNull.compounds().writeArray(indexDataSetName, DirectoryIndex.getHDF5LinkCompoundType(this.hdf5WriterOrNull), this.links.getLinkArray(), HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION, new IHDF5CompoundInformationRetriever.IByteArrayInspector(){

                public void inspect(byte[] byteArray) {
                    crc32.update(byteArray);
                }
            });
            this.hdf5WriterOrNull.setIntAttribute(indexDataSetName, CRC32_ATTRIBUTE_NAME, (int)crc32.getValue());
        }
        catch (HDF5Exception ex) {
            this.errorStrategy.dealWithError(new ListArchiveException(this.groupPath, ex));
        }
        this.dirty = false;
    }

    public void updateIndex(LinkRecord[] entries) {
        this.ensureWriteMode();
        this.links.update(entries);
        this.dirty = true;
    }

    public void updateIndex(Collection<LinkRecord> entries) {
        this.ensureWriteMode();
        this.links.update(entries);
        this.dirty = true;
    }

    public void updateIndex(LinkRecord entry) {
        this.ensureWriteMode();
        this.links.update(entry);
        this.dirty = true;
    }

    public boolean remove(String linkName) {
        this.ensureWriteMode();
        boolean storeChanged = this.links.remove(linkName);
        this.dirty |= storeChanged;
        return storeChanged;
    }

    private void ensureWriteMode() {
        if (this.hdf5WriterOrNull == null) {
            throw new IllegalStateException("Cannot write index in read-only mode.");
        }
    }

    private int calcCrc32(String names) {
        CRC32 crc32 = new CRC32();
        crc32.update(StringUtils.toBytes0Term(names, names.length(), CharacterEncoding.UTF8));
        return (int)crc32.getValue();
    }

    @Override
    public void close() throws IOExceptionUnchecked {
        this.flush();
        if (this.hdf5WriterOrNull != null) {
            this.hdf5WriterOrNull.removeFlushable(this);
        }
        this.flushables.clear();
    }
}

