/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

import com.sun.xml.parser.AttributeDecl;
import com.sun.xml.parser.ContentModel;
import com.sun.xml.parser.ContentModelState;
import com.sun.xml.parser.ElementDecl;
import com.sun.xml.parser.ElementValidator;
import com.sun.xml.parser.EndOfInputException;
import com.sun.xml.parser.ExternalEntity;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.SimpleHashtable;
import com.sun.xml.util.XmlNames;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingParser
extends Parser {
    private SimpleHashtable ids = new SimpleHashtable();
    private final EmptyValidator EMPTY = new EmptyValidator();

    public ValidatingParser() {
        this.setIsValidating(true);
    }

    public ValidatingParser(boolean rejectValidityErrors) {
        this();
        if (rejectValidityErrors) {
            this.setErrorHandler(new HandlerBase(){

                public void error(SAXParseException x) throws SAXException {
                    throw x;
                }
            });
        }
    }

    void afterDocument() {
        this.ids.clear();
    }

    void afterRoot() throws SAXException {
        Enumeration e = this.ids.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            Boolean value = (Boolean)this.ids.get(id);
            if (!Boolean.FALSE.equals(value)) continue;
            this.error("V-024", new Object[]{id});
        }
    }

    private boolean isUnparsedEntity(String name) {
        Object e = this.entities.get(name);
        if (e == null || !(e instanceof ExternalEntity)) {
            return false;
        }
        return ((ExternalEntity)e).notation != null;
    }

    ContentModel newContentModel(char type, ContentModel next) {
        return new ContentModel(type, next);
    }

    ContentModel newContentModel(String tag) {
        return new ContentModel(tag);
    }

    ElementValidator newValidator(ElementDecl element) {
        if (element.contentType == null || element.contentType == "ANY") {
            return ElementValidator.ANY;
        }
        if (element.contentType == "EMPTY") {
            return this.EMPTY;
        }
        if (element.contentType.charAt(1) == '#') {
            return new MixedValidator(element);
        }
        return new ChildrenValidator(element);
    }

    void validateAttributeSyntax(AttributeDecl attr, String value) throws SAXException {
        if (attr.type == "ID") {
            Boolean b;
            if (!XmlNames.isName(value)) {
                this.error("V-025", new Object[]{value});
            }
            if ((b = (Boolean)this.ids.get(value)) == null || b.equals(Boolean.FALSE)) {
                this.ids.put(value, Boolean.TRUE);
            } else {
                this.error("V-026", new Object[]{value});
            }
        } else if (attr.type == "IDREF") {
            Boolean b;
            if (!XmlNames.isName(value)) {
                this.error("V-027", new Object[]{value});
            }
            if ((b = (Boolean)this.ids.get(value)) == null) {
                this.ids.put(value, Boolean.FALSE);
            }
        } else if (attr.type == "IDREFS") {
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                Boolean b;
                value = tokenizer.nextToken();
                if (!XmlNames.isName(value)) {
                    this.error("V-027", new Object[]{value});
                }
                if ((b = (Boolean)this.ids.get(value)) != null) continue;
                this.ids.put(value, Boolean.FALSE);
            }
        } else if (attr.type == "NMTOKEN") {
            if (!XmlNames.isNmtoken(value)) {
                this.error("V-028", new Object[]{value});
            }
        } else if (attr.type == "NMTOKENS") {
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                if (XmlNames.isNmtoken(value)) continue;
                this.error("V-028", new Object[]{value});
            }
        } else if (attr.type == "ENUMERATION") {
            int i = 0;
            while (i < attr.values.length) {
                if (value.equals(attr.values[i])) {
                    return;
                }
                ++i;
            }
            this.error("V-029", new Object[]{value});
        } else if (attr.type == "NOTATION") {
            int i = 0;
            while (i < attr.values.length) {
                if (value.equals(attr.values[i])) {
                    return;
                }
                ++i;
            }
            this.error("V-030", new Object[]{value});
        } else if (attr.type == "ENTITY") {
            if (!this.isUnparsedEntity(value)) {
                this.error("V-031", new Object[]{value});
            }
        } else if (attr.type == "ENTITIES") {
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                if (this.isUnparsedEntity(value)) continue;
                this.error("V-031", new Object[]{value});
            }
        } else if (attr.type != "CDATA") {
            throw new InternalError(attr.type);
        }
    }

    class EmptyValidator
    extends ElementValidator {
        EmptyValidator() {
        }

        public void consume(String token) throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }
    }

    class MixedValidator
    extends ElementValidator {
        private ElementDecl element;

        MixedValidator(ElementDecl element) {
            this.element = element;
        }

        public void consume(String type) throws SAXException {
            String model = this.element.contentType;
            int index = 8;
            while ((index = model.indexOf(type, index + 1)) >= 9) {
                char c;
                if (model.charAt(index - 1) != '|' || (c = model.charAt(index + type.length())) != '|' && c != ')') continue;
                return;
            }
            ValidatingParser.this.error("V-034", new Object[]{this.element.name, type, model});
        }
    }

    class ChildrenValidator
    extends ElementValidator {
        private ContentModelState state;
        private String name;

        ChildrenValidator(ElementDecl element) {
            this.state = new ContentModelState(element.model);
            this.name = element.name;
        }

        public void consume(String token) throws SAXException {
            if (this.state == null) {
                ValidatingParser.this.error("V-035", new Object[]{this.name, token});
            } else {
                try {
                    this.state = this.state.advance(token);
                }
                catch (EndOfInputException endOfInputException) {
                    ValidatingParser.this.error("V-036", new Object[]{this.name, token});
                }
            }
        }

        public void done() throws SAXException {
            if (this.state != null && !this.state.terminate()) {
                ValidatingParser.this.error("V-038", new Object[]{this.name});
            }
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-037", new Object[]{this.name});
        }
    }
}

