/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.compound;

import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.AbstractNucleotideCompoundSet;

public class DNACompoundSet
extends AbstractNucleotideCompoundSet<NucleotideCompound> {
    public static DNACompoundSet getDNACompoundSet() {
        return InitaliseOnDemand.INSTANCE;
    }

    public DNACompoundSet() {
        this.addNucleotideCompound("A", "T", new String[0]);
        this.addNucleotideCompound("T", "A", new String[0]);
        this.addNucleotideCompound("G", "C", new String[0]);
        this.addNucleotideCompound("C", "G", new String[0]);
        this.addNucleotideCompound("N", "N", new String[0]);
        this.addNucleotideCompound("-", "-", new String[0]);
    }

    @Override
    public NucleotideCompound newNucleotideCompound(String base, String complement, String ... equivalents) {
        if (equivalents.length == 0) {
            return new NucleotideCompound(base, this, complement);
        }
        NucleotideCompound[] compounds = new NucleotideCompound[equivalents.length];
        for (int i = 0; i < compounds.length; ++i) {
            compounds[i] = (NucleotideCompound)this.getCompoundForString(equivalents[i]);
        }
        return new NucleotideCompound(base, this, complement, compounds);
    }

    private static class InitaliseOnDemand {
        public static final DNACompoundSet INSTANCE = new DNACompoundSet();

        private InitaliseOnDemand() {
        }
    }
}

