/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.apache.batik.css.AbstractCSSRule;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMImportRule;
import org.apache.batik.css.CSSOMMediaRule;
import org.apache.batik.css.CSSOMStyleDeclaration;
import org.apache.batik.css.CSSOMStyleRule;
import org.apache.batik.css.CSSOMStyleSheet;
import org.apache.batik.css.CSSOMUnknownRule;
import org.apache.batik.css.CSSRuleListOwner;
import org.apache.batik.css.DOMMediaList;
import org.apache.batik.css.value.ValueFactory;
import org.apache.batik.css.value.ValueFactoryMap;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;

public class CSSDocumentHandler
implements DocumentHandler {
    protected static Class parserClass = class$org$apache$batik$css$parser$Parser == null ? (class$org$apache$batik$css$parser$Parser = CSSDocumentHandler.class$("org.apache.batik.css.parser.Parser")) : class$org$apache$batik$css$parser$Parser;
    protected Parser parser;
    protected ValueFactoryMap factories;
    protected CSSRule currentRule;
    protected CSSOMStyleSheet styleSheet;
    protected boolean append;
    protected String uri;
    static /* synthetic */ Class class$org$apache$batik$css$parser$Parser;

    public static void setParserClassName(String string) {
        try {
            parserClass = Class.forName(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static Parser createParser() {
        try {
            return (Parser)parserClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static void parseStyleSheet(CSSOMStyleSheet cSSOMStyleSheet, String string) throws DOMException {
        try {
            Parser parser = cSSOMStyleSheet.getParser();
            InputSource inputSource = new InputSource(string);
            parser.setSelectorFactory(AbstractCSSRule.SELECTOR_FACTORY);
            parser.setConditionFactory(AbstractCSSRule.CONDITION_FACTORY);
            parser.setDocumentHandler((DocumentHandler)new CSSDocumentHandler(cSSOMStyleSheet, string, true));
            parser.parseStyleSheet(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string2 = exception.getMessage();
            throw CSSDOMExceptionFactory.createDOMException((short)12, "syntax.error.at", new Object[]{string, string2 == null ? "" : string2});
        }
    }

    public static void parseRules(CSSOMStyleSheet cSSOMStyleSheet, String string) throws DOMException {
        try {
            Parser parser = cSSOMStyleSheet.getParser();
            parser.setSelectorFactory(AbstractCSSRule.SELECTOR_FACTORY);
            parser.setConditionFactory(AbstractCSSRule.CONDITION_FACTORY);
            parser.setDocumentHandler((DocumentHandler)new CSSDocumentHandler(cSSOMStyleSheet, null, true));
            parser.parseStyleSheet(new InputSource((Reader)new StringReader(string)));
        }
        catch (DOMException dOMException) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "rules.syntax.error", new Object[]{string + "\n" + dOMException.getMessage()});
        }
        catch (Exception exception) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "rules.syntax.error", new Object[]{string});
        }
    }

    public static CSSRule parseRule(CSSOMStyleSheet cSSOMStyleSheet, String string) throws DOMException {
        try {
            Parser parser = cSSOMStyleSheet.getParser();
            parser.setSelectorFactory(AbstractCSSRule.SELECTOR_FACTORY);
            parser.setConditionFactory(AbstractCSSRule.CONDITION_FACTORY);
            CSSDocumentHandler cSSDocumentHandler = new CSSDocumentHandler(cSSOMStyleSheet, null, false);
            parser.setDocumentHandler((DocumentHandler)cSSDocumentHandler);
            parser.parseRule(new InputSource((Reader)new StringReader(string)));
            return cSSDocumentHandler.currentRule;
        }
        catch (DOMException dOMException) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "rule.syntax.error", new Object[]{string + "\n" + dOMException.getMessage()});
        }
        catch (Exception exception) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "rule.syntax.error", new Object[]{string});
        }
    }

    protected CSSDocumentHandler(CSSOMStyleSheet cSSOMStyleSheet, String string, boolean bl) {
        this(cSSOMStyleSheet, string, null, bl);
    }

    protected CSSDocumentHandler(CSSOMStyleSheet cSSOMStyleSheet, String string, CSSRule cSSRule, boolean bl) {
        this.parser = cSSOMStyleSheet.getParser();
        this.factories = cSSOMStyleSheet.getValueFactoryMap();
        this.styleSheet = cSSOMStyleSheet;
        this.currentRule = cSSRule;
        this.append = bl;
        this.uri = string;
    }

    public void startDocument(InputSource inputSource) throws CSSException {
    }

    public void endDocument(InputSource inputSource) throws CSSException {
    }

    public void comment(String string) throws CSSException {
    }

    public void ignorableAtRule(String string) throws CSSException {
        this.currentRule = new CSSOMUnknownRule(this.styleSheet, this.currentRule, string, this.parser);
        if (this.append) {
            this.styleSheet.appendRule(this.currentRule);
        }
    }

    public void namespaceDeclaration(String string, String string2) throws CSSException {
    }

    public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
        DOMMediaList dOMMediaList = new DOMMediaList();
        int n = 0;
        while (n < sACMediaList.getLength()) {
            dOMMediaList.appendMedium(sACMediaList.item(n));
            ++n;
        }
        String string3 = string;
        try {
            string3 = new URL(new URL(this.uri), string).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentRule = new CSSOMImportRule(this.styleSheet, string3, dOMMediaList);
        if (this.append) {
            this.styleSheet.appendRule(this.currentRule);
        }
        this.currentRule = null;
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
        DOMMediaList dOMMediaList = new DOMMediaList();
        int n = 0;
        while (n < sACMediaList.getLength()) {
            dOMMediaList.appendMedium(sACMediaList.item(n));
            ++n;
        }
        CSSRuleListOwner cSSRuleListOwner = (CSSRuleListOwner)((Object)this.currentRule);
        this.currentRule = new CSSOMMediaRule(this.styleSheet, this.currentRule, dOMMediaList, this.parser, this.factories);
        if (this.append && cSSRuleListOwner == null) {
            this.styleSheet.appendRule(this.currentRule);
        } else if (this.append && cSSRuleListOwner != null) {
            cSSRuleListOwner.appendRule(this.currentRule);
        }
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
        this.currentRule = this.currentRule.getParentRule();
    }

    public void startPage(String string, String string2) throws CSSException {
        throw new CSSException("!!! TODO");
    }

    public void endPage(String string, String string2) throws CSSException {
    }

    public void startFontFace() throws CSSException {
        throw new CSSException("!!! TODO");
    }

    public void endFontFace() throws CSSException {
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
        CSSRuleListOwner cSSRuleListOwner = (CSSRuleListOwner)((Object)this.currentRule);
        this.currentRule = new CSSOMStyleRule(this.styleSheet, this.currentRule, this.parser, this.factories);
        if (this.append && cSSRuleListOwner == null) {
            this.styleSheet.appendRule(this.currentRule);
        } else if (this.append && cSSRuleListOwner != null) {
            cSSRuleListOwner.appendRule(this.currentRule);
        }
        ((CSSOMStyleRule)this.currentRule).setSelectors(selectorList);
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
        this.currentRule = this.currentRule.getParentRule();
    }

    public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
        CSSOMStyleDeclaration cSSOMStyleDeclaration = (CSSOMStyleDeclaration)((CSSOMStyleRule)this.currentRule).getStyle();
        ValueFactory valueFactory = this.factories.get(string);
        if (valueFactory == null) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "invalid.property", new Object[]{string});
        }
        valueFactory.createCSSValue(lexicalUnit, cSSOMStyleDeclaration, bl ? "!important" : "");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

