/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class strip {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("\nstrip: Wrong number of arguments.\n");
            System.out.println("Usage: \"strip <infile> <outfile> <options> [name1] [name2] ... OR [phylogenyfile]\"\n");
            System.out.println(" Options: -k to keep listed nodes");
            System.out.println("          -r to remove listed nodes");
            System.out.println("          -kp to keep nodes found in [phylogenyfile]");
            System.out.println("          -rp to remove nodes found in [phylogenyfile]\n");
            System.exit(-1);
        }
        File infile = new File(args[0]);
        File outfile = new File(args[1]);
        String options = args[2];
        Phylogeny p = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser pp = ForesterUtil.createParserDependingOnFileType(infile, true);
            p = factory.create(infile, pp)[0];
        }
        catch (Exception e) {
            System.out.println("\nCould not read \"" + infile + "\" [" + e.getMessage() + "]\n");
            System.exit(-1);
        }
        boolean keep = false;
        boolean from_p0 = false;
        if (options.trim().toLowerCase().equals("-k")) {
            keep = true;
        } else if (options.trim().toLowerCase().equals("-kp")) {
            keep = true;
            from_p0 = true;
        } else if (options.trim().toLowerCase().equals("-rp")) {
            from_p0 = true;
        } else if (!options.trim().toLowerCase().equals("-r")) {
            System.out.println("\nUnknown option \"" + options + "\"\n");
            System.exit(-1);
        }
        String[] names = null;
        if (from_p0) {
            names = strip.readInNamesFromPhylogeny(args[3]);
        } else {
            names = new String[args.length - 3];
            int i = 0;
            while (i < args.length - 3) {
                names[i] = args[i + 3];
                ++i;
            }
        }
        if (keep) {
            PhylogenyMethods.deleteExternalNodesPositiveSelection(names, p);
        } else {
            PhylogenyMethods.deleteExternalNodesNegativeSelection(names, p);
        }
        try {
            PhylogenyWriter w = new PhylogenyWriter();
            w.toPhyloXML(outfile, p, 1);
        }
        catch (IOException e) {
            System.out.println("\nFailure to write output [" + e.getMessage() + "]\n");
            System.exit(-1);
        }
    }

    private static String[] readInNamesFromPhylogeny(String file) {
        Phylogeny p0 = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            File f = new File(file);
            PhylogenyParser pp = ForesterUtil.createParserDependingOnFileType(f, true);
            p0 = factory.create(f, pp)[0];
        }
        catch (Exception e) {
            System.out.println("\nCould not read \"" + file + "\" [" + e.getMessage() + "]\n");
            System.exit(-1);
        }
        return p0.getAllExternalNodeNames();
    }
}

