/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import java.io.IOException;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;

final class PdfExporter {
    private static final int HEIGHT_LIMIT = 100;
    private static final int WIDTH_LIMIT = 60;

    private PdfExporter() {
    }

    static String writePhylogenyToPdf(String file_name, TreePanel tree_panel, int width, int height) throws IOException {
        Phylogeny phylogeny;
        if (height < 100) {
            height = 100;
        }
        if (width < 60) {
            width = 60;
        }
        if ((phylogeny = tree_panel.getPhylogeny()) == null || phylogeny.isEmpty()) {
            return "";
        }
        if (tree_panel.getMainPanel().getTreeFontSet().getSmallFont().getSize() < 1) {
            throw new IOException("fonts are too small for PDF export");
        }
        File file = new File(file_name);
        if (file.isDirectory()) {
            throw new IOException("[" + file_name + "] is a directory");
        }
        String msg = file.toString();
        if (width > 0 && height > 0) {
            msg = String.valueOf(msg) + " [size: " + width + ", " + height + "]";
        }
        return msg;
    }
}

