/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.forester.go.BasicGoRelationship;
import org.forester.go.BasicGoSubset;
import org.forester.go.BasicGoTerm;
import org.forester.go.BasicGoXRef;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoRelationship;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.GoXRef;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.surfacing.DomainId;
import org.forester.util.ForesterUtil;

public class TestGo {
    private static final double ZERO_DIFF = 1.0E-9;

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static boolean test(File test_dir) {
        System.out.print("  GO ID: ");
        if (!TestGo.testGoId()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Namespace: ");
        if (!TestGo.testNamespace()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic GO term: ");
        if (!TestGo.testBasicGoTerm()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  OBO parser: ");
        if (!TestGo.testOBOparser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Pfam to GO mapping: ");
        if (!TestGo.testPfamToGoMapping()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Pfam to GO parser: ");
        if (!TestGo.testPfamToGoParser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Super terms: ");
        if (!TestGo.testSuperTermGetting(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Super term counting: ");
        if (!TestGo.testSuperTermCounting(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static boolean testBasicGoTerm() {
        BasicGoTerm gt5;
        block11: {
            BasicGoTerm gt1;
            block10: {
                BasicGoTerm gt4;
                block9: {
                    block8: {
                        BasicGoTerm gt3;
                        block7: {
                            try {
                                gt1 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "molecular_function", false);
                                BasicGoTerm gt2 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "molecular_function", false);
                                gt3 = new BasicGoTerm("GO:0047579", "?", "molecular_function", true);
                                gt4 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "biological_process", false);
                                gt5 = new BasicGoTerm("GO:0047578", "4-hydroxymandelate oxidase activity", "molecular_function", false);
                                if (((Object)gt1).equals(gt2)) break block7;
                                return false;
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                                return false;
                            }
                        }
                        if (((Object)gt1).equals(gt3)) break block8;
                        return false;
                    }
                    if (!((Object)gt1).equals(gt4)) break block9;
                    return false;
                }
                if (((Object)gt1).hashCode() == ((Object)gt4).hashCode()) break block10;
                return false;
            }
            if (!((Object)gt1).equals(gt5)) break block11;
            return false;
        }
        GoTerm gt6 = (GoTerm)gt5.copy();
        return gt6.equals(gt5);
    }

    private static boolean testGoId() {
        GoId id2;
        GoId id1;
        block9: {
            GoId id3;
            block8: {
                block7: {
                    block6: {
                        try {
                            id1 = new GoId("GO:0042617");
                            id2 = new GoId("GO:0042630");
                            id3 = new GoId("GO:0042630");
                            if (!id1.equals(id2)) break block6;
                            return false;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                            return false;
                        }
                    }
                    if (id2.equals(id3)) break block7;
                    return false;
                }
                if (id1.toString().equals("GO:0042617")) break block8;
                return false;
            }
            if (id2.hashCode() == id3.hashCode()) break block9;
            return false;
        }
        return id1.hashCode() != id2.hashCode();
    }

    private static boolean testNamespace() {
        GoNameSpace m;
        block9: {
            GoNameSpace c;
            block8: {
                GoNameSpace b;
                block7: {
                    GoNameSpace m2;
                    block6: {
                        try {
                            b = new GoNameSpace("Biological_process");
                            c = new GoNameSpace("Cellular_Component");
                            m = new GoNameSpace("molecular_function");
                            m2 = new GoNameSpace(GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION);
                            if (!b.equals(c)) break block6;
                            return false;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                            return false;
                        }
                    }
                    if (m.equals(m2)) break block7;
                    return false;
                }
                if (b.toString().equals("biological_process")) break block8;
                return false;
            }
            if (c.toString().equals("cellular_component")) break block9;
            return false;
        }
        return m.toString().equals("molecular_function");
    }

    private static boolean testOBOparser(File test_dir) {
        GoTerm g3;
        block91: {
            block90: {
                block89: {
                    block88: {
                        block87: {
                            GoTerm g2;
                            block86: {
                                block85: {
                                    block84: {
                                        block83: {
                                            GoTerm g1;
                                            block82: {
                                                block81: {
                                                    block80: {
                                                        block79: {
                                                            block78: {
                                                                block77: {
                                                                    block76: {
                                                                        block75: {
                                                                            block74: {
                                                                                block73: {
                                                                                    block72: {
                                                                                        block71: {
                                                                                            block70: {
                                                                                                block69: {
                                                                                                    block68: {
                                                                                                        block67: {
                                                                                                            block66: {
                                                                                                                block65: {
                                                                                                                    block64: {
                                                                                                                        block63: {
                                                                                                                            block62: {
                                                                                                                                block61: {
                                                                                                                                    block60: {
                                                                                                                                        block59: {
                                                                                                                                            block58: {
                                                                                                                                                block57: {
                                                                                                                                                    GoTerm g0;
                                                                                                                                                    block56: {
                                                                                                                                                        block55: {
                                                                                                                                                            block54: {
                                                                                                                                                                block53: {
                                                                                                                                                                    block52: {
                                                                                                                                                                        block51: {
                                                                                                                                                                            block50: {
                                                                                                                                                                                block49: {
                                                                                                                                                                                    block48: {
                                                                                                                                                                                        List<GoTerm> go_terms;
                                                                                                                                                                                        block47: {
                                                                                                                                                                                            try {
                                                                                                                                                                                                OBOparser parser = new OBOparser(new File(test_dir + ForesterUtil.getFileSeparator() + "obo_test"), OBOparser.ReturnType.BASIC_GO_TERM);
                                                                                                                                                                                                go_terms = parser.parse();
                                                                                                                                                                                                if (parser.getGoTermCount() == 26) break block47;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                                e.printStackTrace(System.out);
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                        g0 = go_terms.get(0);
                                                                                                                                                                                        g1 = go_terms.get(1);
                                                                                                                                                                                        g3 = go_terms.get(2);
                                                                                                                                                                                        g2 = go_terms.get(25);
                                                                                                                                                                                        if (g0.getComment().equals("")) break block48;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (g0.getDefinition().equals("\"The distribution of mitochondria, including the mitochondrial genome, into daughter cells after mitosis or meiosis, mediated by interactions between mitochondria and the cytoskeleton.\" [GOC:mcc, PMID:10873824, PMID:11389764]")) break block49;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (g0.getGoId().getId().equals("GO:0000001")) break block50;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (!g0.getGoNameSpace().equals((Object)GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) break block51;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (g0.getGoNameSpace().getType() == GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS) break block52;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (g0.getGoRelationships().size() == 0) break block53;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (g0.getGoXRefs().size() == 0) break block54;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (g0.getName().equals("mitochondrion inheritance")) break block55;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (g0.getSuperGoIds().size() == 2) break block56;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (g0.isObsolete()) break block57;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (g1.getComment().equals("comment")) break block58;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (g1.getDefinition().equals("\"The maintenance of the structure and integrity of the mitochondrial genome.\" [GOC:ai]")) break block59;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (g1.getGoId().getId().equals("GO:0000002")) break block60;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (!g1.getGoNameSpace().equals((Object)GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) break block61;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (g1.getGoNameSpace().getType() == GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS) break block62;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (g1.getGoRelationships().size() == 1) break block63;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (g1.getGoXRefs().size() == 5) break block64;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (g1.getName().equals("mitochondrial genome maintenance")) break block65;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (g1.getSuperGoIds().size() == 1) break block66;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (!g1.isObsolete()) break block67;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (g1.getGoXRefs().get(0).equals(new BasicGoXRef("EC:2.4.1.-"))) break block68;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (g1.getGoXRefs().get(0).getXRef().equals("2.4.1.-")) break block69;
                                                                                                    return false;
                                                                                                }
                                                                                                if (g1.getGoXRefs().get(0).getType() == GoXRef.Type.EC) break block70;
                                                                                                return false;
                                                                                            }
                                                                                            if (!g1.getGoXRefs().get(0).equals(new BasicGoXRef("EC:2.4.1.1"))) break block71;
                                                                                            return false;
                                                                                        }
                                                                                        if (!g1.getGoXRefs().get(0).equals(new BasicGoXRef("Reactome:2.4.1.-"))) break block72;
                                                                                        return false;
                                                                                    }
                                                                                    if (g1.getGoXRefs().get(1).equals(new BasicGoXRef("Reactome:7672"))) break block73;
                                                                                    return false;
                                                                                }
                                                                                if (g1.getGoXRefs().get(2).equals(new BasicGoXRef("MetaCyc:SIROHEME-FERROCHELAT-RXN"))) break block74;
                                                                                return false;
                                                                            }
                                                                            if (g1.getGoXRefs().get(3).equals(new BasicGoXRef("RESID:AA02376"))) break block75;
                                                                            return false;
                                                                        }
                                                                        if (g1.getGoXRefs().get(4).equals(new BasicGoXRef("UM-BBD_enzymeID:e0271"))) break block76;
                                                                        return false;
                                                                    }
                                                                    if (g1.getGoRelationships().get(0).equals(new BasicGoRelationship("part_of GO:0007052"))) break block77;
                                                                    return false;
                                                                }
                                                                if (g1.getGoRelationships().get(0).getGoId().equals(new GoId("GO:0007052"))) break block78;
                                                                return false;
                                                            }
                                                            if (g1.getGoRelationships().get(0).getGoId().getId().equals("GO:0007052")) break block79;
                                                            return false;
                                                        }
                                                        if (g1.getGoRelationships().get(0).getType() == GoRelationship.Type.PART_OF) break block80;
                                                        return false;
                                                    }
                                                    if (!g1.getGoRelationships().get(0).equals(new BasicGoRelationship("part_of GO:1007052"))) break block81;
                                                    return false;
                                                }
                                                if (g1.getSuperGoIds().get(0).equals(new GoId("GO:0007005"))) break block82;
                                                return false;
                                            }
                                            if (!g1.getSuperGoIds().get(0).equals(new GoId("GO:1007005"))) break block83;
                                            return false;
                                        }
                                        if (g2.getGoId().getId().equals("GO:0000030")) break block84;
                                        return false;
                                    }
                                    if (g2.getGoId().equals(new GoId("GO:0000030"))) break block85;
                                    return false;
                                }
                                if (!g2.getGoId().getId().equals("GO:0000031")) break block86;
                                return false;
                            }
                            if (!g2.getGoId().equals(new GoId("GO:0000031"))) break block87;
                            return false;
                        }
                        if (g3.getGoSubsets().size() == 3) break block88;
                        return false;
                    }
                    if (g3.getGoSubsets().contains(new BasicGoSubset("goslim_generic"))) break block89;
                    return false;
                }
                if (g3.getGoSubsets().contains(new BasicGoSubset("goslim_plant"))) break block90;
                return false;
            }
            if (g3.getGoSubsets().contains(new BasicGoSubset("gosubset_prok"))) break block91;
            return false;
        }
        return !g3.getGoSubsets().contains(new BasicGoSubset("goslim_candida"));
    }

    private static boolean testPfamToGoMapping() {
        PfamToGoMapping pg2;
        PfamToGoMapping pg0;
        block15: {
            block14: {
                PfamToGoMapping pg3;
                block13: {
                    PfamToGoMapping pg4;
                    block12: {
                        block11: {
                            block10: {
                                PfamToGoMapping pg1;
                                block9: {
                                    try {
                                        pg0 = new PfamToGoMapping(new DomainId("A"), new GoId("GO:0000001"));
                                        pg1 = new PfamToGoMapping(new DomainId("A"), new GoId("GO:0000001"));
                                        pg2 = new PfamToGoMapping(new DomainId("B"), new GoId("GO:0000001"));
                                        pg3 = new PfamToGoMapping(new DomainId("A"), new GoId("GO:0000002"));
                                        pg4 = new PfamToGoMapping(new DomainId("B"), new GoId("GO:0000002"));
                                        if (pg0.equals(pg0)) break block9;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace(System.out);
                                        return false;
                                    }
                                }
                                if (pg0.equals(pg1)) break block10;
                                return false;
                            }
                            if (!pg0.equals(pg2)) break block11;
                            return false;
                        }
                        if (!pg0.equals(pg3)) break block12;
                        return false;
                    }
                    if (!pg0.equals(pg4)) break block13;
                    return false;
                }
                if (pg0.compareTo(pg3) == 0) break block14;
                return false;
            }
            if (pg0.compareTo(pg2) < 0) break block15;
            return false;
        }
        return pg2.compareTo(pg0) > 0;
    }

    private static boolean testPfamToGoParser(File test_dir) {
        PfamToGoMapping m425;
        block39: {
            block38: {
                PfamToGoMapping m424;
                block37: {
                    block36: {
                        PfamToGoMapping m5;
                        block35: {
                            block34: {
                                PfamToGoMapping m4;
                                block33: {
                                    block32: {
                                        PfamToGoMapping m3;
                                        block31: {
                                            block30: {
                                                PfamToGoMapping m2;
                                                block29: {
                                                    block28: {
                                                        PfamToGoMapping m1;
                                                        block27: {
                                                            block26: {
                                                                PfamToGoMapping m0;
                                                                block25: {
                                                                    block24: {
                                                                        block23: {
                                                                            List<PfamToGoMapping> mappings;
                                                                            block22: {
                                                                                block21: {
                                                                                    try {
                                                                                        PfamToGoParser parser = new PfamToGoParser(new File(test_dir + ForesterUtil.getFileSeparator() + "pfam_to_go_test"));
                                                                                        mappings = parser.parse();
                                                                                        if (parser.getMappingCount() == 426) break block21;
                                                                                        return false;
                                                                                    }
                                                                                    catch (Exception e) {
                                                                                        e.printStackTrace(System.out);
                                                                                        return false;
                                                                                    }
                                                                                }
                                                                                if (mappings.size() == 426) break block22;
                                                                                return false;
                                                                            }
                                                                            m0 = mappings.get(0);
                                                                            m1 = mappings.get(1);
                                                                            m2 = mappings.get(2);
                                                                            m3 = mappings.get(3);
                                                                            m4 = mappings.get(4);
                                                                            m5 = mappings.get(5);
                                                                            m424 = mappings.get(424);
                                                                            m425 = mappings.get(425);
                                                                            if (m0.getKey().equals(new DomainId("7tm_1"))) break block23;
                                                                            return false;
                                                                        }
                                                                        if (m0.getValue().equals(new GoId("GO:0001584"))) break block24;
                                                                        return false;
                                                                    }
                                                                    if (!m0.getKey().equals(new DomainId("7tm_x"))) break block25;
                                                                    return false;
                                                                }
                                                                if (!m0.getValue().equals(new GoId("GO:0001585"))) break block26;
                                                                return false;
                                                            }
                                                            if (m1.getKey().equals(new DomainId("7tm_1"))) break block27;
                                                            return false;
                                                        }
                                                        if (m1.getValue().equals(new GoId("GO:0007186"))) break block28;
                                                        return false;
                                                    }
                                                    if (m2.getKey().equals(new DomainId("7tm_1"))) break block29;
                                                    return false;
                                                }
                                                if (m2.getValue().equals(new GoId("GO:0016021"))) break block30;
                                                return false;
                                            }
                                            if (m3.getKey().equals(new DomainId("7tm_2"))) break block31;
                                            return false;
                                        }
                                        if (m3.getValue().equals(new GoId("GO:0004930"))) break block32;
                                        return false;
                                    }
                                    if (m4.getKey().equals(new DomainId("7tm_2"))) break block33;
                                    return false;
                                }
                                if (m4.getValue().equals(new GoId("GO:0016020"))) break block34;
                                return false;
                            }
                            if (m5.getKey().equals(new DomainId("7tm_3"))) break block35;
                            return false;
                        }
                        if (m5.getValue().equals(new GoId("GO:0008067"))) break block36;
                        return false;
                    }
                    if (m424.getKey().equals(new DomainId("OMPdecase"))) break block37;
                    return false;
                }
                if (m424.getValue().equals(new GoId("GO:0006207"))) break block38;
                return false;
            }
            if (m425.getKey().equals(new DomainId("Bac_DNA_binding"))) break block39;
            return false;
        }
        return m425.getValue().equals(new GoId("GO:0003677"));
    }

    private static boolean testSuperTermCounting(File test_dir) {
        LinkedHashMap<GoId, Integer> counts_id;
        block39: {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    Map<GoId, GoTerm> goid_to_term_map;
                                    block32: {
                                        LinkedHashMap<GoId, Integer> counts;
                                        block31: {
                                            block30: {
                                                block29: {
                                                    block28: {
                                                        block27: {
                                                            block26: {
                                                                block25: {
                                                                    block24: {
                                                                        block23: {
                                                                            block22: {
                                                                                List<GoTerm> all_go_terms;
                                                                                block21: {
                                                                                    try {
                                                                                        OBOparser parser = new OBOparser(new File(test_dir + ForesterUtil.getFileSeparator() + "gene_ontology_edit.obo"), OBOparser.ReturnType.BASIC_GO_TERM);
                                                                                        all_go_terms = parser.parse();
                                                                                        if (parser.getGoTermCount() == 27748) break block21;
                                                                                        return false;
                                                                                    }
                                                                                    catch (Exception e) {
                                                                                        e.printStackTrace(System.out);
                                                                                        return false;
                                                                                    }
                                                                                }
                                                                                goid_to_term_map = GoUtils.createGoIdToGoTermMap(all_go_terms);
                                                                                ArrayList<GoTerm> categories = new ArrayList<GoTerm>();
                                                                                ArrayList<GoTerm> experiment_set = new ArrayList<GoTerm>();
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0005690"), "snRNP U4atac", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0009698"), "phenylpropanoid metabolic process", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0008150"), "biological_process", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0006915"), "apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0001783"), "B cell apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0010658"), "striated muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                experiment_set.add(new BasicGoTerm(new GoId("GO:0043065"), "positive regulation of apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0016265"), "death", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0006915"), "apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0008150"), "biological_process", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0010658"), "striated muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0046242"), "o-xylene biosynthetic process", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0016326"), "kinesin motor activity", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0005575"), "cellular_component", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0032502"), "developmental process", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0051094"), "positive regulation of developmental process", GoNameSpace.createUnassigned(), false));
                                                                                categories.add(new BasicGoTerm(new GoId("GO:0048522"), "positive regulation of cellular process", GoNameSpace.createUnassigned(), false));
                                                                                counts = GoUtils.countCategories(categories, experiment_set, goid_to_term_map);
                                                                                if ((Integer)counts.get(new GoId("GO:0016265")) == 5) break block22;
                                                                                return false;
                                                                            }
                                                                            if ((Integer)counts.get(new GoId("GO:0006915")) == 5) break block23;
                                                                            return false;
                                                                        }
                                                                        if ((Integer)counts.get(new GoId("GO:0008150")) == 8) break block24;
                                                                        return false;
                                                                    }
                                                                    if ((Integer)counts.get(new GoId("GO:0010657")) == 3) break block25;
                                                                    return false;
                                                                }
                                                                if ((Integer)counts.get(new GoId("GO:0010658")) == 1) break block26;
                                                                return false;
                                                            }
                                                            if ((Integer)counts.get(new GoId("GO:0046242")) == 0) break block27;
                                                            return false;
                                                        }
                                                        if ((Integer)counts.get(new GoId("GO:0016326")) == 0) break block28;
                                                        return false;
                                                    }
                                                    if ((Integer)counts.get(new GoId("GO:0005575")) == 1) break block29;
                                                    return false;
                                                }
                                                if ((Integer)counts.get(new GoId("GO:0032502")) == 5) break block30;
                                                return false;
                                            }
                                            if ((Integer)counts.get(new GoId("GO:0051094")) == 1) break block31;
                                            return false;
                                        }
                                        if ((Integer)counts.get(new GoId("GO:0048522")) == 1) break block32;
                                        return false;
                                    }
                                    ArrayList<GoId> categories_id = new ArrayList<GoId>();
                                    ArrayList<GoId> experiment_set_id = new ArrayList<GoId>();
                                    experiment_set_id.add(new GoId("GO:0005690"));
                                    experiment_set_id.add(new GoId("GO:0009698"));
                                    experiment_set_id.add(new GoId("GO:0008150"));
                                    experiment_set_id.add(new GoId("GO:0006915"));
                                    experiment_set_id.add(new GoId("GO:0001783"));
                                    experiment_set_id.add(new GoId("GO:0010657"));
                                    experiment_set_id.add(new GoId("GO:0010657"));
                                    experiment_set_id.add(new GoId("GO:0010658"));
                                    categories_id.add(new GoId("GO:0016265"));
                                    categories_id.add(new GoId("GO:0006915"));
                                    categories_id.add(new GoId("GO:0008150"));
                                    categories_id.add(new GoId("GO:0010657"));
                                    categories_id.add(new GoId("GO:0010658"));
                                    categories_id.add(new GoId("GO:0046242"));
                                    categories_id.add(new GoId("GO:0016326"));
                                    categories_id.add(new GoId("GO:0005575"));
                                    counts_id = GoUtils.countCategoriesId(categories_id, experiment_set_id, goid_to_term_map);
                                    if ((Integer)counts_id.get(new GoId("GO:0016265")) == 5) break block33;
                                    return false;
                                }
                                if ((Integer)counts_id.get(new GoId("GO:0006915")) == 5) break block34;
                                return false;
                            }
                            if ((Integer)counts_id.get(new GoId("GO:0008150")) == 7) break block35;
                            return false;
                        }
                        if ((Integer)counts_id.get(new GoId("GO:0010657")) == 3) break block36;
                        return false;
                    }
                    if ((Integer)counts_id.get(new GoId("GO:0010658")) == 1) break block37;
                    return false;
                }
                if ((Integer)counts_id.get(new GoId("GO:0046242")) == 0) break block38;
                return false;
            }
            if ((Integer)counts_id.get(new GoId("GO:0016326")) == 0) break block39;
            return false;
        }
        return (Integer)counts_id.get(new GoId("GO:0005575")) == 1;
    }

    private static boolean testSuperTermGetting(File test_dir) {
        Map<GoId, GoTerm> goid_to_term_map;
        block13: {
            block12: {
                block11: {
                    SortedSet<GoTerm> b_cell_selection;
                    block10: {
                        block9: {
                            List<GoTerm> go_terms;
                            block8: {
                                try {
                                    OBOparser parser = new OBOparser(new File(test_dir + ForesterUtil.getFileSeparator() + "gene_ontology_edit.obo"), OBOparser.ReturnType.BASIC_GO_TERM);
                                    go_terms = parser.parse();
                                    if (parser.getGoTermCount() == 27748) break block8;
                                    return false;
                                }
                                catch (Exception e) {
                                    e.printStackTrace(System.out);
                                    return false;
                                }
                            }
                            goid_to_term_map = GoUtils.createGoIdToGoTermMap(go_terms);
                            b_cell_selection = GoUtils.getAllSuperGoTerms(new GoId("GO:0002339"), goid_to_term_map);
                            if (b_cell_selection.size() == 2) break block9;
                            return false;
                        }
                        if (b_cell_selection.contains(new BasicGoTerm(new GoId("GO:0002376"), "immune system process", GoNameSpace.createBiologicalProcess(), false))) break block10;
                        return false;
                    }
                    if (b_cell_selection.contains(new BasicGoTerm(new GoId("GO:0008150"), "biological process", GoNameSpace.createBiologicalProcess(), false))) break block11;
                    return false;
                }
                SortedSet<GoTerm> b_cell_differentation = GoUtils.getAllSuperGoTerms(new GoId("GO:0030183"), goid_to_term_map);
                if (b_cell_differentation.size() == 12) break block12;
                return false;
            }
            SortedSet<GoTerm> biological_process = GoUtils.getAllSuperGoTerms(new GoId("GO:0008150"), goid_to_term_map);
            if (biological_process.size() == 0) break block13;
            return false;
        }
        SortedSet<GoTerm> protein_aa_phosphorylation = GoUtils.getAllSuperGoTerms(new GoId("GO:0006468"), goid_to_term_map);
        return protein_aa_phosphorylation.size() == 16;
    }
}

