/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.ParserUtils;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class NexusPhylogeniesParser
implements PhylogenyParser {
    private static final String begin_trees = "Begin Trees;".toLowerCase();
    private static final String taxlabels = "TaxLabels".toLowerCase();
    private static final String translate = "Translate".toLowerCase();
    private static final String tree = "Tree".toLowerCase();
    private static final String utree = "UTREE".toLowerCase();
    private static final String end = "End;".toLowerCase();
    private static final String endblock = "endblock";
    private static final Pattern TREE_NAME_PATTERN = Pattern.compile("\\s*.?Tree\\s+(.+?)\\s*=.+", 2);
    private static final Pattern ROOTEDNESS_PATTERN = Pattern.compile(".+=\\s*\\[&([R|U])\\].*");
    private Object _nexus_source;
    private List<Phylogeny> _phylogenies;
    private List<String> _taxlabels;
    private Map<String, String> _translate_map;
    private boolean _replace_underscores = false;
    private boolean _ignore_quotes_in_nh_data = true;

    private void createPhylogeny(String name, StringBuffer nhx, boolean rooted_info_present, boolean is_rooted) throws IOException {
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        NHXParser pars = new NHXParser();
        pars.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
        pars.setReplaceUnderscores(this.isReplaceUnderscores());
        pars.setIgnoreQuotes(this.isIgnoreQuotes());
        if (rooted_info_present) {
            pars.setGuessRootedness(false);
        }
        Phylogeny p = factory.create(nhx, pars)[0];
        p.setName(name);
        if (rooted_info_present) {
            p.setRooted(is_rooted);
        }
        if (this.getTaxlabels().size() > 0 || this.getTranslateMap().size() > 0) {
            PhylogenyNodeIterator it = p.iteratorExternalForward();
            while (it.hasNext()) {
                PhylogenyNode node = it.next();
                if (this.getTranslateMap().size() > 0 && this.getTranslateMap().containsKey(node.getNodeName())) {
                    node.setName(this.getTranslateMap().get(node.getNodeName()).replaceAll("['\"]+", ""));
                    continue;
                }
                if (this.getTaxlabels().size() <= 0) continue;
                int i = -1;
                try {
                    i = Integer.parseInt(node.getNodeName());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (i <= 0) continue;
                node.setName(this.getTaxlabels().get(i - 1).replaceAll("['\"]+", ""));
            }
        }
        this.getPhylogenies().add(p);
    }

    private Object getNexusSource() {
        return this._nexus_source;
    }

    private List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private Phylogeny[] getPhylogeniesAsArray() {
        Phylogeny[] p = new Phylogeny[this.getPhylogenies().size()];
        int i = 0;
        while (i < this.getPhylogenies().size()) {
            p[i] = this.getPhylogenies().get(i);
            ++i;
        }
        return p;
    }

    private List<String> getTaxlabels() {
        return this._taxlabels;
    }

    private Map<String, String> getTranslateMap() {
        return this._translate_map;
    }

    private boolean isIgnoreQuotes() {
        return this._ignore_quotes_in_nh_data;
    }

    private boolean isReplaceUnderscores() {
        return this._replace_underscores;
    }

    @Override
    public Phylogeny[] parse() throws IOException, NHXFormatException {
        String line;
        this.reset();
        BufferedReader reader = ParserUtils.createReader(this.getNexusSource());
        String name = "";
        StringBuffer nhx = new StringBuffer();
        StringBuffer translate_sb = new StringBuffer();
        boolean in_trees_block = false;
        boolean in_taxalabels = false;
        boolean in_translate = false;
        boolean in_tree = false;
        boolean rooted_info_present = false;
        boolean is_rooted = false;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(">")) continue;
            line = ForesterUtil.collapseWhiteSpace(line);
            String line_lc = (line = NexusPhylogeniesParser.removeWhiteSpaceBeforeSemicolon(line)).toLowerCase();
            if (line_lc.startsWith(begin_trees)) {
                in_trees_block = true;
                in_taxalabels = false;
                in_translate = false;
            } else if (line_lc.startsWith(taxlabels)) {
                in_trees_block = false;
                in_taxalabels = true;
                in_translate = false;
            } else if (line_lc.startsWith(translate)) {
                in_taxalabels = false;
                in_translate = true;
            } else if (in_trees_block) {
                if (line_lc.startsWith(end) || line_lc.startsWith(endblock)) {
                    in_trees_block = false;
                    in_tree = false;
                    in_translate = false;
                    if (nhx.length() > 0) {
                        this.createPhylogeny(name, nhx, rooted_info_present, is_rooted);
                        nhx = new StringBuffer();
                        name = "";
                        rooted_info_present = false;
                        is_rooted = false;
                    }
                } else if (line_lc.startsWith(tree) || line_lc.startsWith(utree)) {
                    Matcher rootedness_matcher;
                    if (nhx.length() > 0) {
                        this.createPhylogeny(name, nhx, rooted_info_present, is_rooted);
                        nhx = new StringBuffer();
                        name = "";
                        rooted_info_present = false;
                        is_rooted = false;
                    }
                    in_tree = true;
                    nhx.append(line.substring(line.indexOf(61)));
                    Matcher name_matcher = TREE_NAME_PATTERN.matcher(line);
                    if (name_matcher.matches()) {
                        name = name_matcher.group(1);
                        name = name.replaceAll("['\"]+", "");
                    }
                    if ((rootedness_matcher = ROOTEDNESS_PATTERN.matcher(line)).matches()) {
                        String s = rootedness_matcher.group(1);
                        line = line.replaceAll("\\[\\&.\\]", "");
                        rooted_info_present = true;
                        if (s.toUpperCase().equals("R")) {
                            is_rooted = true;
                        }
                    }
                } else if (in_tree && !in_translate) {
                    nhx.append(line);
                }
                if (!in_translate && !line_lc.startsWith(end) && !line_lc.startsWith(endblock) && line_lc.endsWith(";")) {
                    in_tree = false;
                    in_translate = false;
                    this.createPhylogeny(name, nhx, rooted_info_present, is_rooted);
                    nhx = new StringBuffer();
                    name = "";
                    rooted_info_present = false;
                    is_rooted = false;
                }
            }
            if (in_taxalabels) {
                if (line_lc.startsWith(end) || line_lc.startsWith(endblock)) {
                    in_taxalabels = false;
                } else {
                    String[] labels;
                    String[] stringArray = labels = line.split("\\s+");
                    int n = labels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String label = stringArray[n2];
                        if (!label.toLowerCase().equals(taxlabels)) {
                            if (label.endsWith(";")) {
                                in_taxalabels = false;
                                label = label.substring(0, label.length() - 1);
                            }
                            if (label.length() > 0) {
                                this.getTaxlabels().add(label);
                            }
                        }
                        ++n2;
                    }
                }
            }
            if (!in_translate) continue;
            if (line_lc.startsWith(end) || line_lc.startsWith(endblock)) {
                in_translate = false;
                continue;
            }
            translate_sb.append(" ");
            translate_sb.append(line.trim());
            if (!line.endsWith(";")) continue;
            in_translate = false;
            this.setTranslateKeyValuePairs(translate_sb);
        }
        if (nhx.length() > 0) {
            this.createPhylogeny(name, nhx, rooted_info_present, is_rooted);
        }
        return this.getPhylogeniesAsArray();
    }

    private void reset() {
        this.setPhylogenies(new ArrayList<Phylogeny>());
        this.setTaxlabels(new ArrayList<String>());
        this.setTranslateMap(new HashMap<String, String>());
    }

    public void setIgnoreQuotes(boolean ignore_quotes_in_nh_data) {
        this._ignore_quotes_in_nh_data = ignore_quotes_in_nh_data;
    }

    private void setPhylogenies(ArrayList<Phylogeny> phylogenies) {
        this._phylogenies = phylogenies;
    }

    public void setReplaceUnderscores(boolean replace_underscores) {
        this._replace_underscores = replace_underscores;
    }

    @Override
    public void setSource(Object nexus_source) throws PhylogenyParserException, IOException {
        if (nexus_source == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = nexus_source;
    }

    private void setTaxlabels(List<String> taxlabels) {
        this._taxlabels = taxlabels;
    }

    private void setTranslateKeyValuePairs(StringBuffer translate_sb) throws IOException {
        String s = translate_sb.toString().trim();
        if (s.endsWith(";")) {
            s = s.substring(0, s.length() - 1).trim();
        }
        String[] stringArray = s.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] kv = pair.trim().split("\\s+");
            if (kv.length < 2 || kv.length > 3) {
                throw new IOException("ill formatted translate values: " + translate_sb);
            }
            if (kv.length == 3 && !kv[0].toLowerCase().trim().equals(translate)) {
                throw new IOException("ill formatted translate values: " + translate_sb);
            }
            String key = "";
            String value = "";
            if (kv.length == 3) {
                key = kv[1];
                value = kv[2];
            } else {
                key = kv[0];
                value = kv[1];
            }
            if (value.endsWith(";")) {
                value = value.substring(0, value.length() - 1);
            }
            this.getTranslateMap().put(key, value);
            ++n2;
        }
    }

    private void setTranslateMap(Map<String, String> translate_map) {
        this._translate_map = translate_map;
    }

    private static String removeWhiteSpaceBeforeSemicolon(String s) {
        return s.replaceAll("\\s+;", ";");
    }
}

