/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.util.ArrayList;
import java.util.HashMap;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;

public class XmlElement {
    public static final boolean DEBUG = false;
    private final String _namespaceUri;
    private final String _localName;
    private final String _qualifiedName;
    private String _value;
    private final HashMap<String, String> _attributes;
    private final ArrayList<XmlElement> _childElements;
    private XmlElement _parent;

    public XmlElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) {
        this._namespaceUri = namespaceUri;
        this._localName = localName;
        this._qualifiedName = qualifiedName;
        if (attributes != null) {
            this._attributes = new HashMap(attributes.getLength());
            int i = 0;
            while (i < attributes.getLength()) {
                this.getAttributes().put(new String(attributes.getQName(i)), new String(attributes.getValue(i)));
                ++i;
            }
        } else {
            this._attributes = new HashMap();
        }
        this._childElements = new ArrayList();
        this._parent = null;
    }

    public void addChildElement(XmlElement element) {
        element.setParent(this);
        this.getChildElements().add(element);
    }

    public void appendValue(String value) {
        this._value = String.valueOf(this._value) + value;
    }

    public String getAttribute(String attribute_name) {
        if (!this.isHasAttribute(attribute_name)) {
            throw new IllegalArgumentException("no attribute named [" + attribute_name + "] present in element [" + this.getQualifiedName() + "]");
        }
        return this.getAttributes().get(attribute_name);
    }

    public HashMap<String, String> getAttributes() {
        return this._attributes;
    }

    public XmlElement getChildElement(int i) {
        if (i < 0 || i >= this.getNumberOfChildElements()) {
            throw new IllegalArgumentException("attempt to get child element with index " + i + " for element with " + this.getNumberOfChildElements() + " child elements");
        }
        return this.getChildElements().get(i);
    }

    ArrayList<XmlElement> getChildElements() {
        return this._childElements;
    }

    String getLocalName() {
        return this._localName;
    }

    String getNamespaceUri() {
        return this._namespaceUri;
    }

    public int getNumberOfChildElements() {
        return this.getChildElements().size();
    }

    public XmlElement getParent() {
        return this._parent;
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    XmlElement getRoot() {
        XmlElement e = this;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        return e;
    }

    public boolean getValueAsBoolean() throws PhylogenyParserException {
        boolean b = false;
        try {
            b = new Boolean(this.getValueAsString());
        }
        catch (NumberFormatException ex) {
            throw new PhylogenyParserException("attempt to parse [" + this.getValueAsString() + "] into boolean, in " + this.toString());
        }
        return b;
    }

    public double getValueAsDouble() throws PhylogenyParserException {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.getValueAsString());
        }
        catch (NumberFormatException ex) {
            throw new PhylogenyParserException("attempt to parse [" + this.getValueAsString() + "] into double, in " + this.toString());
        }
        return d;
    }

    public int getValueAsInt() throws PhylogenyParserException {
        int i = 0;
        try {
            i = Integer.parseInt(this.getValueAsString());
        }
        catch (NumberFormatException ex) {
            throw new PhylogenyParserException("attempt to parse [" + this.getValueAsString() + "] into integer, in " + this.toString());
        }
        return i;
    }

    public String getValueAsString() {
        if (this._value == null) {
            return "";
        }
        return this._value.replaceAll("\\s+", " ").trim();
    }

    public boolean isHasAttribute(String attribute_name) {
        return this.getAttributes().containsKey(attribute_name);
    }

    public boolean isHasValue() {
        return !ForesterUtil.isEmpty(this._value);
    }

    void setParent(XmlElement parent) {
        this._parent = parent;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String toString() {
        if (this.getParent() != null) {
            return "\"" + this.getQualifiedName() + "\" [value: " + this.getValueAsString() + ", parent element: \"" + this.getParent().getQualifiedName() + "\"]";
        }
        return "\"" + this.getQualifiedName() + "\" [value: " + this.getValueAsString() + "]";
    }
}

