/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.PhylogenyNodeI;
import org.forester.phylogeny.data.BranchData;
import org.forester.phylogeny.data.NodeData;
import org.forester.phylogeny.iterators.ChildNodeIteratorForward;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

public class PhylogenyNode
implements PhylogenyNodeI,
Comparable<PhylogenyNode> {
    public static final double DISTANCE_DEFAULT = -1024.0;
    private static int _node_count = 0;
    private byte _indicator;
    private int _id;
    private int _sum_ext_nodes;
    private float _x;
    private float _y;
    private String _node_name;
    private double _distance_parent;
    private boolean _collapse;
    private PhylogenyNode _parent;
    private PhylogenyNode _link;
    private ArrayList<PhylogenyNode> _descendants;
    private NodeData _node_data;
    private BranchData _branch_data;
    private float _x_secondary;
    private float _y_secondary;
    private boolean _pathToParent = false;

    public PhylogenyNode() {
        this.init();
        this.setNodeId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public PhylogenyNode(String nhx) throws NHXFormatException {
        this(nhx, NHXParser.TAXONOMY_EXTRACTION.NO);
    }

    public PhylogenyNode(String nhx, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) throws NHXFormatException {
        this.init();
        NHXParser.parseNHX(nhx, this, taxonomy_extraction, false);
        this.setNodeId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public PhylogenyNode(String nhx, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction, boolean replace_underscores) throws NHXFormatException {
        this.init();
        NHXParser.parseNHX(nhx, this, taxonomy_extraction, replace_underscores);
        this.setNodeId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public void setPathToParent(boolean value) {
        this._pathToParent = value;
    }

    public boolean getPathToParent() {
        return this._pathToParent;
    }

    @Override
    public final void addAsChild(PhylogenyNodeI node) {
        PhylogenyNode n = (PhylogenyNode)node;
        this.addChildNode(n);
        n.setParent(this);
    }

    private final void addChildNode(PhylogenyNode child) {
        this.getDescendants().add(child);
    }

    @Override
    public final int compareTo(PhylogenyNode o) {
        PhylogenyNode n = o;
        if (this.getNodeName() == null || n.getNodeName() == null) {
            return 0;
        }
        return this.getNodeName().compareTo(n.getNodeName());
    }

    public final PhylogenyNode copyNodeData() {
        PhylogenyNode node = new PhylogenyNode();
        PhylogenyNode.decreaseNodeCount();
        node._id = this._id;
        node._sum_ext_nodes = this._sum_ext_nodes;
        node._indicator = this._indicator;
        node._x = this._x;
        node._y = this._y;
        if (this._node_name != null) {
            node._node_name = new String(this._node_name);
        }
        node._distance_parent = this._distance_parent;
        node._collapse = this._collapse;
        node._link = this._link;
        if (this._node_data != null) {
            node._node_data = (NodeData)this._node_data.copy();
        }
        if (this._branch_data != null) {
            node._branch_data = (BranchData)this._branch_data.copy();
        }
        return node;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        PhylogenyNode other = (PhylogenyNode)o;
        if (!this.getNodeName().equals(other.getNodeName())) {
            return false;
        }
        NodeData this_data = this.getNodeData();
        NodeData other_data = other.getNodeData();
        if (this_data.isHasSequence() && other_data.isHasSequence() && this_data.isHasTaxonomy() && other_data.isHasTaxonomy()) {
            return this_data.getTaxonomy().isEqual(other_data.getTaxonomy()) && this_data.getSequence().isEqual(other_data.getSequence());
        }
        if (this_data.isHasSequence() && other_data.isHasSequence()) {
            return this_data.getSequence().isEqual(other_data.getSequence());
        }
        if (this_data.isHasTaxonomy() && other_data.isHasTaxonomy()) {
            return this_data.getTaxonomy().isEqual(other_data.getTaxonomy());
        }
        return this.getNodeName().length() > 0;
    }

    public final List<PhylogenyNode> getAllExternalDescendants() {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        if (this.isExternal()) {
            nodes.add(this);
            return nodes;
        }
        PhylogenyNode node1 = this;
        while (!node1.isExternal()) {
            node1 = node1.getFirstChildNode();
        }
        PhylogenyNode node2 = this;
        while (!node2.isExternal()) {
            node2 = node2.getLastChildNode();
        }
        while (node1 != node2) {
            nodes.add(node1);
            node1 = node1.getNextExternalNode();
        }
        nodes.add(node2);
        return nodes;
    }

    public final List<String> getAllExternalDescendantsNames() {
        List<PhylogenyNode> c = this.getAllExternalDescendants();
        ArrayList<String> n = new ArrayList<String>(c.size());
        for (PhylogenyNode phylogenyNode : c) {
            n.add(phylogenyNode.getNodeName());
        }
        return n;
    }

    public final BranchData getBranchData() {
        if (this._branch_data == null) {
            this._branch_data = new BranchData();
        }
        return this._branch_data;
    }

    final BranchData getBranchDataDirectly() {
        return this._branch_data;
    }

    @Override
    public final PhylogenyNode getChildNode(int i) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("attempt to get the child node of an external node.");
        }
        if (i >= this.getNumberOfDescendants() || i < 0) {
            throw new IllegalArgumentException("attempt to get child node " + i + " of a node with " + this.getNumberOfDescendants() + " child nodes");
        }
        return this.getDescendants().get(i);
    }

    public final PhylogenyNode getChildNode1() {
        return this.getChildNode(0);
    }

    public final PhylogenyNode getChildNode2() {
        return this.getChildNode(1);
    }

    public final int getChildNodeIndex() {
        return this.getChildNodeIndex(this.getParent());
    }

    public final int getChildNodeIndex(PhylogenyNode parent) {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the child index for a root node.");
        }
        int i = 0;
        while (i < parent.getNumberOfDescendants()) {
            if (parent.getChildNode(i) == this) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Unexpected exception: Could not determine the child index for node: " + this);
    }

    public final List<PhylogenyNode> getDescendants() {
        return this._descendants;
    }

    @Override
    public final double getDistanceToParent() {
        return this._distance_parent;
    }

    public final PhylogenyNode getFirstChildNode() {
        return this.getChildNode(0);
    }

    public final byte getIndicator() {
        return this._indicator;
    }

    public final PhylogenyNode getLastChildNode() {
        return this.getChildNode(this.getNumberOfDescendants() - 1);
    }

    public final PhylogenyNode getLink() {
        return this._link;
    }

    public final PhylogenyNode getNextExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("attempt to get next external node of an internal node");
        }
        if (this.isLastExternalNode()) {
            return null;
        }
        int index = this.getChildNodeIndex();
        PhylogenyNode previous_node = this;
        PhylogenyNode current_node = this.getParent();
        while (!current_node.isRoot() && (current_node.getNumberOfDescendants() == 1 || previous_node.isLastChildNode())) {
            index = current_node.getChildNodeIndex();
            previous_node = current_node;
            current_node = current_node.getParent();
        }
        current_node = current_node.getChildNode(index + 1);
        while (current_node.isInternal()) {
            current_node = current_node.getFirstChildNode();
        }
        return current_node;
    }

    public final NodeData getNodeData() {
        if (this._node_data == null) {
            this._node_data = new NodeData();
        }
        return this._node_data;
    }

    final NodeData getNodeDataDirectly() {
        return this._node_data;
    }

    @Override
    public final int getNodeId() {
        return this._id;
    }

    @Override
    public final String getNodeName() {
        return this._node_name;
    }

    public final int getNumberOfDescendants() {
        return this._descendants.size();
    }

    public final int getNumberOfExternalNodes() {
        return this._sum_ext_nodes;
    }

    public final int getNumberOfParents() {
        return 1;
    }

    public final PhylogenyNode getParent() {
        return this._parent;
    }

    public final PhylogenyNode getPreviousExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for an internal node.");
        }
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for a root node.");
        }
        if (this.isFirstExternalNode()) {
            throw new UnsupportedOperationException("Attempt to get previous external node of the first external node.");
        }
        int index = this.getChildNodeIndex();
        PhylogenyNode previous_node = this;
        PhylogenyNode current_node = this.getParent();
        while (!current_node.isRoot() && (current_node.getNumberOfDescendants() == 1 || previous_node.isFirstChildNode())) {
            index = current_node.getChildNodeIndex();
            previous_node = current_node;
            current_node = current_node.getParent();
        }
        current_node = current_node.getChildNode(index - 1);
        while (current_node.isInternal()) {
            current_node = current_node.getLastChildNode();
        }
        return current_node;
    }

    public final float getXcoord() {
        return this._x;
    }

    public final float getXSecondary() {
        return this._x_secondary;
    }

    public final float getYcoord() {
        return this._y;
    }

    public final float getYSecondary() {
        return this._y_secondary;
    }

    public final int hashCode() {
        NodeData data = this.getNodeData();
        if (this.getNodeName().length() < 1 && !data.isHasSequence() && !data.isHasTaxonomy()) {
            return super.hashCode();
        }
        int result = this.getNodeName().hashCode();
        if (data.isHasSequence()) {
            result ^= data.getSequence().hashCode();
        }
        if (data.isHasTaxonomy()) {
            result ^= data.getTaxonomy().hashCode();
        }
        return result;
    }

    private final void init() {
        this._descendants = new ArrayList();
        this._parent = null;
        this._id = 0;
        this.initializeData();
    }

    public final void initializeData() {
        this._indicator = 0;
        this._x = 0.0f;
        this._y = 0.0f;
        this._node_name = "";
        this._distance_parent = -1024.0;
        this._collapse = false;
        this._link = null;
        this._branch_data = null;
        this._node_data = null;
    }

    public final boolean isCollapse() {
        return this._collapse;
    }

    public final boolean isDuplication() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isDuplication();
    }

    public final boolean isExternal() {
        return this.getNumberOfDescendants() < 1;
    }

    public final boolean isFirstChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the first child node of its _parent.");
        }
        return this.getChildNodeIndex() == 0;
    }

    public final boolean isFirstExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode node = this;
        while (!node.isRoot()) {
            if (!node.isFirstChildNode()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    public final boolean isHasAssignedEvent() {
        if (!this.getNodeData().isHasEvent()) {
            return false;
        }
        return !this.getNodeData().getEvent().isUnassigned();
    }

    public final boolean isInternal() {
        return !this.isExternal();
    }

    public final boolean isLastChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the last child node of its _parent.");
        }
        return this.getChildNodeIndex() == this.getParent().getNumberOfDescendants() - 1;
    }

    public final boolean isLastExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode node = this;
        while (!node.isRoot()) {
            if (!node.isLastChildNode()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    public final boolean isRoot() {
        return this._parent == null;
    }

    public final boolean isSpeciation() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isSpeciation();
    }

    public final PhylogenyNodeIterator iterateChildNodesForward() {
        return new ChildNodeIteratorForward(this);
    }

    public void preorderPrint() {
        System.out.println(this + "\n");
        if (this.isInternal()) {
            int i = 0;
            while (i < this.getNumberOfDescendants()) {
                this.getChildNode(i).preorderPrint();
                ++i;
            }
        }
    }

    public final void removeChildNode(int i) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("cannot get the child node for a external node.");
        }
        if (i >= this.getNumberOfDescendants() || i < 0) {
            throw new IllegalArgumentException("attempt to get child node " + i + " of a node with " + this.getNumberOfDescendants() + " child nodes.");
        }
        this.getDescendants().remove(i);
    }

    public final void removeChildNode(PhylogenyNode remove_me) {
        this.removeChildNode(remove_me.getChildNodeIndex());
    }

    public final void setBranchData(BranchData branch_data) {
        this._branch_data = branch_data;
    }

    public final void setChild1(PhylogenyNode n) {
        this.setChildNode(0, n);
    }

    public final void setChild2(PhylogenyNode n) {
        this.setChildNode(1, n);
    }

    public final void setChildNode(int i, PhylogenyNode node) {
        node.setParent(this);
        if (this.getNumberOfDescendants() <= i) {
            this.addChildNode(node);
        } else {
            this.getDescendants().set(i, node);
        }
    }

    final void setChildNodeOnly(int i, PhylogenyNode node) {
        if (this.getNumberOfDescendants() <= i) {
            this.addChildNode(node);
        } else {
            this.getDescendants().set(i, node);
        }
    }

    public final void setCollapse(boolean b) {
        this._collapse = b;
    }

    @Override
    public final void setDistanceToParent(double d) {
        this._distance_parent = d;
    }

    public final void setIndicator(byte i) {
        this._indicator = i;
    }

    final void setIndicatorsToZero() {
        PreorderTreeIterator it = new PreorderTreeIterator(this);
        while (it.hasNext()) {
            it.next().setIndicator((byte)0);
        }
    }

    public final void setLink(PhylogenyNode n) {
        this._link = n;
    }

    @Override
    public final void setName(String node_name) {
        this._node_name = node_name;
    }

    protected final void setNodeId(int i) {
        this._id = i;
    }

    @Override
    public final void setParent(PhylogenyNode n) {
        this._parent = n;
    }

    public final void setSumExtNodes(int i) {
        this._sum_ext_nodes = i;
    }

    public final void setXcoord(float x) {
        this._x = x;
    }

    public final void setXSecondary(float x_secondary) {
        this._x_secondary = x_secondary;
    }

    public final void setYcoord(float y) {
        this._y = y;
    }

    public final void setYSecondary(float y_secondary) {
        this._y_secondary = y_secondary;
    }

    public final String toNewHampshire(boolean simple_nh, boolean write_distance_to_parent) {
        StringBuilder sb = new StringBuilder();
        String data = "";
        if (!ForesterUtil.isEmpty(this.getNodeName())) {
            data = this.getNodeName();
        } else if (this.getNodeData().isHasTaxonomy()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getTaxonomyCode())) {
                data = this.getNodeData().getTaxonomy().getTaxonomyCode();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getScientificName())) {
                data = this.getNodeData().getTaxonomy().getScientificName();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getCommonName())) {
                data = this.getNodeData().getTaxonomy().getCommonName();
            } else if (this.getNodeData().getTaxonomy().getTaxonomyCode() != null) {
                data = this.getNodeData().getTaxonomy().getTaxonomyCode();
            }
        } else if (this.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(this.getNodeData().getSequence().getName())) {
            data = this.getNodeData().getSequence().getName();
        }
        if (data.length() > 0) {
            data = ForesterUtil.replaceIllegalNhCharacters(data);
            if (simple_nh) {
                if (data.length() > 10) {
                    data = data.substring(0, 11);
                }
                if (data.indexOf(47) > 0) {
                    data = data.substring(0, data.indexOf(47));
                }
                sb.append(data);
            } else {
                sb.append(data);
            }
        }
        if (this.getDistanceToParent() != -1024.0 && write_distance_to_parent) {
            sb.append(":");
            sb.append(this.getDistanceToParent());
        }
        return sb.toString();
    }

    public final String toNewHampshireX() {
        StringBuffer s = new StringBuffer();
        StringBuffer s_nhx = new StringBuffer();
        if (!this.getNodeName().equals("")) {
            s.append(ForesterUtil.replaceIllegalNhxCharacters(this.getNodeName()));
        }
        if (this.getDistanceToParent() != -1024.0) {
            s.append(":");
            s.append(this.getDistanceToParent());
        }
        if (this.getNodeDataDirectly() != null) {
            s_nhx.append(this.getNodeDataDirectly().toNHX());
        }
        if (this.getBranchDataDirectly() != null) {
            s_nhx.append(this.getBranchDataDirectly().toNHX());
        }
        if (s_nhx.length() > 0) {
            s.append("[&&NHX");
            s.append(s_nhx);
            s.append("]");
        }
        return s.toString();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (!ForesterUtil.isEmpty(this.getNodeName())) {
            sb.append(this.getNodeName());
            sb.append(" ");
        }
        sb.append("[");
        sb.append(this.getNodeId());
        sb.append("]");
        return sb.toString();
    }

    static final synchronized void decreaseNodeCount() {
        --_node_count;
    }

    public static final int getNodeCount() {
        return _node_count;
    }

    private static final synchronized void increaseNodeCount() {
        ++_node_count;
    }

    public static final synchronized void setNodeCount(int i) {
        _node_count = i;
    }
}

