/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Confidence
implements PhylogenyData,
Comparable<Confidence> {
    public static final double CONFIDENCE_DEFAULT_VALUE = -9999.0;
    private double _value;
    private String _type;

    public Confidence() {
        this.init();
    }

    public Confidence(double value, String type) {
        this.setValue(value);
        this.setType(type);
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer().append(ForesterUtil.FORMATTER_6.format(this.getValue()));
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getType())) {
            sb.append("[");
            sb.append(this.getType());
            sb.append("] ");
        }
        sb.append(ForesterUtil.FORMATTER_6.format(this.getValue()));
        return sb;
    }

    @Override
    public int compareTo(Confidence confidence) {
        if (this == confidence) {
            return 0;
        }
        return this.getType().compareToIgnoreCase(confidence.getType());
    }

    @Override
    public PhylogenyData copy() {
        return new Confidence(this.getValue(), new String(this.getType()));
    }

    public String getType() {
        return this._type;
    }

    public double getValue() {
        return this._value;
    }

    public void init() {
        this.setValue(-9999.0);
        this.setType("");
    }

    @Override
    public boolean isEqual(PhylogenyData confidence) {
        if (confidence == null) {
            return false;
        }
        if (!(confidence instanceof Confidence)) {
            return false;
        }
        Confidence s = (Confidence)confidence;
        if (s.getValue() != this.getValue()) {
            return false;
        }
        return s.getType().equals(this.getType());
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setValue(double value) {
        this._value = value;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append("B=");
        sb.append(this.getValue());
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.getValue() == -9999.0) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendElement(writer, "confidence", String.valueOf(ForesterUtil.round(this.getValue(), 9)), "type", ForesterUtil.isEmpty(this.getType()) ? "unknown" : this.getType());
    }

    public String toString() {
        return this.asText().toString();
    }
}

