/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.awt.Graphics;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.ForesterUtil;

public final class PhylogenyDataUtil {
    public static void appendClose(Writer w, String element_name) throws IOException {
        w.write("</");
        w.write(element_name);
        w.write(">");
    }

    public static void appendElement(Writer w, String element_name, String value) throws IOException {
        PhylogenyDataUtil.appendOpen(w, element_name);
        w.write(PhylogenyDataUtil.replaceIllegalXmlCharacters(value));
        PhylogenyDataUtil.appendClose(w, element_name);
    }

    public static void appendElement(Writer w, String element_name, String value, String indentation) throws IOException {
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(indentation);
        w.write("  ");
        PhylogenyDataUtil.appendElement(w, element_name, value);
    }

    public static void appendElement(Writer w, String element_name, String value, String attribute_name, String attribute_value) throws IOException {
        PhylogenyDataUtil.appendOpen(w, element_name, attribute_name, attribute_value);
        w.write(PhylogenyDataUtil.replaceIllegalXmlCharacters(value));
        PhylogenyDataUtil.appendClose(w, element_name);
    }

    public static void appendElement(Writer w, String element_name, String value, String attribute_name, String attribute_value, String indentation) throws IOException {
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(indentation);
        w.write("  ");
        PhylogenyDataUtil.appendOpen(w, element_name, attribute_name, attribute_value);
        w.write(PhylogenyDataUtil.replaceIllegalXmlCharacters(value));
        PhylogenyDataUtil.appendClose(w, element_name);
    }

    public static void appendElement(Writer w, String element_name, String value, String attribute1_name, String attribute1_value, String attribute2_name, String attribute2_value, String indentation) throws IOException {
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(indentation);
        w.write("  ");
        PhylogenyDataUtil.appendOpen(w, element_name, attribute1_name, attribute1_value, attribute2_name, attribute2_value);
        w.write(PhylogenyDataUtil.replaceIllegalXmlCharacters(value));
        PhylogenyDataUtil.appendClose(w, element_name);
    }

    public static void appendElement(Writer w, String element_name, String attribute1_name, String attribute1_value, String attribute2_name, String attribute2_value, String attribute3_name, String attribute3_value, String attribute4_name, String attribute4_value, String indentation) throws IOException {
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(indentation);
        PhylogenyDataUtil.appendOpen(w, element_name, attribute1_name, attribute1_value, attribute2_name, attribute2_value, attribute3_name, attribute3_value, attribute4_name, attribute4_value);
        PhylogenyDataUtil.appendClose(w, element_name);
    }

    public static void appendElement(Writer w, String element_name, String value, String attribute1_name, String attribute1_value, String attribute2_name, String attribute2_value, String attribute3_name, String attribute3_value, String attribute4_name, String attribute4_value, String attribute5_name, String attribute5_value, String indentation) throws IOException {
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(indentation);
        w.write("  ");
        PhylogenyDataUtil.appendOpen(w, element_name, attribute1_name, attribute1_value, attribute2_name, attribute2_value, attribute3_name, attribute3_value, attribute4_name, attribute4_value, attribute5_name, attribute5_value);
        w.write(PhylogenyDataUtil.replaceIllegalXmlCharacters(value));
        PhylogenyDataUtil.appendClose(w, element_name);
    }

    public static void appendOpen(Writer w, String element_name) throws IOException {
        w.write("<");
        w.write(element_name);
        w.write(">");
    }

    public static void appendOpen(Writer w, String element_name, String attribute_name, String attribute_value) throws IOException {
        w.write("<");
        w.write(element_name);
        if (!ForesterUtil.isEmpty(attribute_value)) {
            w.write(" ");
            w.write(attribute_name);
            w.write("=\"");
            w.write(attribute_value);
            w.write("\"");
        }
        w.write(">");
    }

    public static void appendOpen(Writer w, String element_name, String attribute1_name, String attribute1_value, String attribute2_name, String attribute2_value) throws IOException {
        w.write("<");
        w.write(element_name);
        if (!ForesterUtil.isEmpty(attribute1_value)) {
            w.write(" ");
            w.write(attribute1_name);
            w.write("=\"");
            w.write(attribute1_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute2_value)) {
            w.write(" ");
            w.write(attribute2_name);
            w.write("=\"");
            w.write(attribute2_value);
            w.write("\"");
        }
        w.write(">");
    }

    public static void appendOpen(Writer w, String element_name, String attribute1_name, String attribute1_value, String attribute2_name, String attribute2_value, String attribute3_name, String attribute3_value) throws IOException {
        w.write("<");
        w.write(element_name);
        if (!ForesterUtil.isEmpty(attribute1_value)) {
            w.write(" ");
            w.write(attribute1_name);
            w.write("=\"");
            w.write(attribute1_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute2_value)) {
            w.write(" ");
            w.write(attribute2_name);
            w.write("=\"");
            w.write(attribute2_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute2_value)) {
            w.write(" ");
            w.write(attribute3_name);
            w.write("=\"");
            w.write(attribute3_value);
            w.write("\"");
        }
        w.write(">");
    }

    public static void appendOpen(Writer w, String element_name, String attribute1_name, String attribute1_value, String attribute2_name, String attribute2_value, String attribute3_name, String attribute3_value, String attribute4_name, String attribute4_value) throws IOException {
        w.write("<");
        w.write(element_name);
        if (!ForesterUtil.isEmpty(attribute1_value)) {
            w.write(" ");
            w.write(attribute1_name);
            w.write("=\"");
            w.write(attribute1_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute2_value)) {
            w.write(" ");
            w.write(attribute2_name);
            w.write("=\"");
            w.write(attribute2_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute3_value)) {
            w.write(" ");
            w.write(attribute3_name);
            w.write("=\"");
            w.write(attribute3_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute4_value)) {
            w.write(" ");
            w.write(attribute4_name);
            w.write("=\"");
            w.write(attribute4_value);
            w.write("\"");
        }
        w.write(">");
    }

    public static void appendOpen(Writer w, String element_name, String attribute1_name, String attribute1_value, String attribute2_name, String attribute2_value, String attribute3_name, String attribute3_value, String attribute4_name, String attribute4_value, String attribute5_name, String attribute5_value) throws IOException {
        w.write("<");
        w.write(element_name);
        if (!ForesterUtil.isEmpty(attribute1_value)) {
            w.write(" ");
            w.write(attribute1_name);
            w.write("=\"");
            w.write(attribute1_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute2_value)) {
            w.write(" ");
            w.write(attribute2_name);
            w.write("=\"");
            w.write(attribute2_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute3_value)) {
            w.write(" ");
            w.write(attribute3_name);
            w.write("=\"");
            w.write(attribute3_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute4_value)) {
            w.write(" ");
            w.write(attribute4_name);
            w.write("=\"");
            w.write(attribute4_value);
            w.write("\"");
        }
        if (!ForesterUtil.isEmpty(attribute5_value)) {
            w.write(" ");
            w.write(attribute5_name);
            w.write("=\"");
            w.write(attribute5_value);
            w.write("\"");
        }
        w.write(">");
    }

    public static ArrayList<PhylogenyData> copy(ArrayList<PhylogenyData> list) {
        ArrayList<PhylogenyData> l = new ArrayList<PhylogenyData>(list.size());
        int i = 0;
        while (i < list.size()) {
            l.add(list.get(i).copy());
            ++i;
        }
        return l;
    }

    public static void drawLine(double x1, double y1, double x2, double y2, Graphics g) {
        g.drawLine(ForesterUtil.roundToInt(x1), ForesterUtil.roundToInt(y1), ForesterUtil.roundToInt(x2), ForesterUtil.roundToInt(y2));
    }

    public static void drawString(String str, double x, double y, Graphics g) {
        g.drawString(str, ForesterUtil.roundToInt(x), ForesterUtil.roundToInt(y));
    }

    public static String replaceIllegalXmlCharacters(String value) {
        String v = value.replaceAll("&", "&amp;");
        v = v.replaceAll("<", "&lt;");
        v = v.replaceAll(">", "&gt;");
        v = v.replaceAll("'", "&apos;");
        v = v.replaceAll("\"", "&quot;");
        return v;
    }
}

