/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import java.util.Stack;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class PreorderTreeIterator
implements PhylogenyNodeIterator {
    private final Phylogeny _tree;
    private final Stack<PhylogenyNode> _stack;

    public PreorderTreeIterator(Phylogeny tree) throws IllegalArgumentException {
        if (tree.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use PreorderTreeIterator on empty tree.");
        }
        this._stack = new Stack();
        this._tree = tree;
        this.reset();
    }

    public PreorderTreeIterator(PhylogenyNode node) throws IllegalArgumentException {
        this._stack = new Stack();
        this._tree = null;
        this.reset(node);
    }

    private Stack<PhylogenyNode> getStack() {
        return this._stack;
    }

    private Phylogeny getTree() {
        return this._tree;
    }

    @Override
    public boolean hasNext() {
        return !this.getStack().isEmpty();
    }

    @Override
    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode node = this.getStack().pop();
        if (!node.isExternal()) {
            int i = node.getNumberOfDescendants() - 1;
            while (i >= 0) {
                this.getStack().push(node.getChildNode(i));
                --i;
            }
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.getStack().clear();
        this.getStack().push(this.getTree().getRoot());
    }

    private void reset(PhylogenyNode node) {
        this.getStack().clear();
        this.getStack().push(node);
    }
}

