/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.PhylogenyNodeI;
import org.forester.phylogenyinference.BasicSymmetricalDistanceMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.util.ForesterUtil;

public class NeighborJoining {
    private static final boolean VERBOSE_DEFAULT = false;
    private DistanceMatrix _d;
    private DistanceMatrix _m;
    private double[] _r;
    private int _n;
    private PhylogenyNodeI[] _external_nodes;
    private int[] _mappings;
    private boolean _verbose;

    private NeighborJoining() {
        this.init();
    }

    private void calculateDistancesFromNewNode(int otu1, int otu2, double d) {
        int i = 0;
        while (i < this._n) {
            if (i != otu1 && i != otu2) {
                double nd = (this.getValueFromD(otu1, i) + this.getValueFromD(i, otu2) - d) / 2.0;
                this.setValueInD(nd, otu1, i);
            }
            ++i;
        }
    }

    private double calculateM(int i, int j) {
        return this.getValueFromD(i, j) - (this._r[i] + this._r[j]) / (double)(this._n - 2);
    }

    private void calculateNetDivergences() {
        int i = 0;
        while (i < this._n) {
            double d = 0.0;
            int n = 0;
            while (n < this._n) {
                d += this.getValueFromD(i, n);
                ++n;
            }
            this._r[i] = d;
            ++i;
        }
    }

    public Phylogeny execute(DistanceMatrix distance) {
        this.reset(distance);
        Phylogeny phylogeny = new Phylogeny();
        while (this._n > 2) {
            this.updateM();
            int[] s = this.findMinimalDistance();
            int otu1 = s[0];
            int otu2 = s[1];
            if (otu1 > otu2) {
                throw new AssertionError((Object)"NJ code is faulty: otu1 > otu2");
            }
            PhylogenyNode node = new PhylogenyNode();
            double d = this.getValueFromD(otu1, otu2);
            double d1 = d / 2.0 + (this._r[otu1] - this._r[otu2]) / (double)(2 * (this._n - 2));
            double d2 = d - d1;
            this.getExternalPhylogenyNode(otu1).setDistanceToParent(d1);
            this.getExternalPhylogenyNode(otu2).setDistanceToParent(d2);
            node.addAsChild(this.getExternalPhylogenyNode(otu1));
            node.addAsChild(this.getExternalPhylogenyNode(otu2));
            if (this.isVerbose()) {
                this.printProgress(otu1, otu2);
            }
            this.calculateDistancesFromNewNode(otu1, otu2, d);
            this.setExternalPhylogenyNode(node, otu1);
            this.updateMappings(otu2);
            --this._n;
        }
        double d = this.getValueFromD(0, 1) / 2.0;
        this.getExternalPhylogenyNode(0).setDistanceToParent(d);
        this.getExternalPhylogenyNode(1).setDistanceToParent(d);
        PhylogenyNode root = new PhylogenyNode();
        root.addAsChild(this.getExternalPhylogenyNode(0));
        root.addAsChild(this.getExternalPhylogenyNode(1));
        if (this.isVerbose()) {
            this.printProgress(0, 1);
        }
        phylogeny.setRoot(root);
        phylogeny.setRooted(false);
        return phylogeny;
    }

    public List<Phylogeny> execute(List<DistanceMatrix> distances_list) {
        ArrayList<Phylogeny> pl = new ArrayList<Phylogeny>();
        for (DistanceMatrix distances : distances_list) {
            pl.add(this.execute(distances));
        }
        return pl;
    }

    private int[] findMinimalDistance() {
        double minimum = Double.MAX_VALUE;
        int otu_1 = -1;
        int otu_2 = -1;
        int j = 1;
        while (j < this._n) {
            int i = 0;
            while (i < j) {
                if (this._m.getValue(i, j) < minimum) {
                    minimum = this._m.getValue(i, j);
                    otu_1 = i;
                    otu_2 = j;
                }
                ++i;
            }
            ++j;
        }
        return new int[]{otu_1, otu_2};
    }

    private PhylogenyNodeI getExternalPhylogenyNode(int i) {
        return this._external_nodes[this._mappings[i]];
    }

    private double getValueFromD(int otu1, int otu2) {
        return this._d.getValue(this._mappings[otu1], this._mappings[otu2]);
    }

    private void init() {
        this.setVerbose(false);
    }

    private void initExternalNodes() {
        this._external_nodes = new PhylogenyNodeI[this._n];
        int i = 0;
        while (i < this._n) {
            this._external_nodes[i] = new PhylogenyNode();
            String id = this._d.getIdentifier(i);
            if (id != null) {
                this._external_nodes[i].setName(id);
            } else {
                this._external_nodes[i].setName("" + i);
            }
            this._mappings[i] = i;
            ++i;
        }
    }

    private boolean isVerbose() {
        return this._verbose;
    }

    private void printProgress(int otu1, int otu2) {
        PhylogenyNodeI n1 = this.getExternalPhylogenyNode(otu1);
        PhylogenyNodeI n2 = this.getExternalPhylogenyNode(otu2);
        System.out.println("Node " + (ForesterUtil.isEmpty(n1.getNodeName()) ? Integer.valueOf(n1.getNodeId()) : n1.getNodeName()) + " joins " + (ForesterUtil.isEmpty(n2.getNodeName()) ? Integer.valueOf(n2.getNodeId()) : n2.getNodeName()));
    }

    private void reset(DistanceMatrix distances) {
        this._n = distances.getSize();
        this._d = distances;
        this._m = new BasicSymmetricalDistanceMatrix(this._n);
        this._r = new double[this._n];
        this._mappings = new int[this._n];
        this.initExternalNodes();
    }

    private void setExternalPhylogenyNode(PhylogenyNodeI node, int i) {
        this._external_nodes[this._mappings[i]] = node;
    }

    private void setValueInD(double d, int otu1, int otu2) {
        this._d.setValue(this._mappings[otu1], this._mappings[otu2], d);
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    private void updateM() {
        this.calculateNetDivergences();
        int j = 1;
        while (j < this._n) {
            int i = 0;
            while (i < j) {
                this._m.setValue(i, j, this.calculateM(i, j));
                ++i;
            }
            ++j;
        }
    }

    private void updateMappings(int otu2) {
        int i = otu2;
        while (i < this._mappings.length - 1) {
            this._mappings[i] = this._mappings[i + 1];
            ++i;
        }
    }

    public static NeighborJoining createInstance() {
        return new NeighborJoining();
    }
}

