/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.SDIR;
import org.forester.util.ForesterUtil;

public class SDIdirectory {
    private static void errorInCommandLine() {
        System.out.println("\nSDIdirectory: Error in command line.\n");
        System.out.println("Usage: \"SDIdirectory  [-options] <gene tree directory> <suffix for gene trees>");
        System.out.println("        <species tree file name> <output directory> <outputfile name>\"");
        System.out.println("\nOptions:");
        System.out.println(" -n input trees are in New Hampshire format instead of NHX -- or");
        System.out.println("    gene trees are in NHX, but species information is");
        System.out.println("    only present in the form of SWISS-PROT sequence names");
        System.out.println(" -l to root by minimizing the mapping cost L (and also the sum of duplications)");
        System.out.println(" -d to root by minimizing the sum of duplications");
        System.out.println(" -h to root by minimizing tree height (can be used together with -l or -d)");
        System.out.println(" -w to write assigned gene trees into output directory");
        System.out.println("\nGene tree directory");
        System.out.println(" The directory from which to read gene trees. The gene trees ");
        System.out.println(" can either be rooted, in which case no rooting with -l, -d, or -h ");
        System.out.println(" is necessary, or they can be unrooted, in which case rooting ");
        System.out.println(" is mandatory.");
        System.out.println("\nSuffix for gene trees");
        System.out.println(" Suffix of the gene trees to analyze (e.g. \"NHX\").");
        System.out.println("\nSpecies tree file");
        System.out.println(" In NHX format, with species names in species name fields; unless -n option");
        System.out.println(" is used.");
        System.out.println("\nOutput directory");
        System.out.println(" The directory into which the assigned gene trees will be written.");
        System.out.println("\nOutputfile name");
        System.out.println(" File name for summary output files.");
        System.out.println("");
        System.exit(-1);
    }

    public static void infer(File indir, File species_tree_file, File outdir, File outfile, String suffix, boolean write_trees, boolean minimize_mapping_cost, boolean minimize_sum_of_dup, boolean minimize_height) throws IOException {
        int MIN_EXT_NODES = 4;
        int MAX_EXT_NODES = 5000;
        int MAX_DUP_DIST = 50;
        int MAX_EXT_NODE_DIST = 1000;
        int successful = 0;
        int number_of_too_small_trees = 0;
        int number_of_too_large_trees = 0;
        int dups = 0;
        int c = 0;
        int ext_nodes = 0;
        int removed = 0;
        int nodecount0 = 0;
        int j = 0;
        long total_number_of_d = 0L;
        long total_number_of_ext_nodes = 0L;
        long sum_costs = 0L;
        long time0 = 0L;
        long time_for_sdi = 0L;
        double sum_tree_heights = 0.0;
        double sum_subtree_diff = 0.0;
        Phylogeny species_tree = null;
        Object filename = null;
        Object[] filenames = null;
        Phylogeny[] trees = null;
        int[] duplications = new int[4999];
        int[] sizes = new int[4999];
        File outtree = null;
        PrintWriter out = null;
        PrintWriter out_ddist = null;
        PrintWriter out_sdist = null;
        File ddist_outfile = new File(outfile + "_Ddist");
        File sdist_outfile = new File(outfile + "_Sdist");
        SDIR sdiunrooted = null;
        DecimalFormat df = new DecimalFormat("0.0#####");
        df.setDecimalSeparatorAlwaysShown(true);
        if (!indir.exists() || !indir.isDirectory()) {
            throw new IllegalArgumentException(indir + " does not exist or is not a directory.");
        }
        if (!outdir.exists() || !outdir.isDirectory()) {
            throw new IllegalArgumentException(outdir + " does not exist or is not a directory.");
        }
        if (outfile.exists()) {
            throw new IllegalArgumentException(outfile + " does already exist.");
        }
        if (ddist_outfile.exists()) {
            throw new IllegalArgumentException(ddist_outfile + " does already exist.");
        }
        if (sdist_outfile.exists()) {
            throw new IllegalArgumentException(sdist_outfile + " does already exist.");
        }
        if (!species_tree_file.exists() || !species_tree_file.isFile()) {
            throw new IllegalArgumentException(species_tree_file + " does not exist or is not a file.");
        }
        if (minimize_mapping_cost && minimize_sum_of_dup) {
            minimize_sum_of_dup = false;
        }
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        PhylogenyParser pp = ForesterUtil.createParserDependingOnFileType(species_tree_file, true);
        species_tree = factory.create(species_tree_file, pp)[0];
        filenames = indir.list();
        Arrays.sort(filenames);
        suffix = suffix.trim();
        out = new PrintWriter((Writer)new FileWriter(outfile), true);
        nodecount0 = PhylogenyNode.getNodeCount();
        time0 = System.currentTimeMillis();
        int i = 0;
        while (i < filenames.length) {
            File gene_tree_file;
            filename = filenames[i];
            if ((suffix.length() < 1 || ((String)filename).endsWith(suffix)) && (gene_tree_file = new File(indir.getPath(), (String)filename)).exists() && gene_tree_file.isFile()) {
                out.print(String.valueOf(j) + "\t" + (String)filename);
                System.out.println(String.valueOf(j) + ": " + (String)filename);
                ++j;
                Phylogeny gene_tree = null;
                PhylogenyParser pp_g = ForesterUtil.createParserDependingOnFileType(gene_tree_file, true);
                gene_tree = factory.create(gene_tree_file, pp_g)[0];
                removed = PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(species_tree, gene_tree);
                if (((String)filename).length() < 8) {
                    out.print("\t\t\t[-" + removed + "]");
                } else if (((String)filename).length() < 16) {
                    out.print("\t\t[-" + removed + "]");
                } else {
                    out.print("\t[-" + removed + "]");
                }
                if (gene_tree.getNumberOfExternalNodes() < 4) {
                    out.print("\t<4en\n");
                    ++number_of_too_small_trees;
                } else if (gene_tree.getNumberOfExternalNodes() > 5000) {
                    out.print("\t>5000en\n");
                    ++number_of_too_large_trees;
                } else {
                    PhylogenyNode.setNodeCount(nodecount0);
                    sdiunrooted = new SDIR();
                    trees = sdiunrooted.infer(gene_tree, species_tree, minimize_mapping_cost, minimize_sum_of_dup, minimize_height, write_trees, 1);
                    ++successful;
                    ext_nodes = gene_tree.getNumberOfExternalNodes();
                    total_number_of_ext_nodes += (long)ext_nodes;
                    int n = ext_nodes;
                    sizes[n] = sizes[n] + 1;
                    out.print("\t " + ext_nodes + "en");
                    dups = sdiunrooted.getMinimalDuplications();
                    total_number_of_d += (long)dups;
                    int n2 = dups;
                    duplications[n2] = duplications[n2] + 1;
                    out.print("\t " + dups + "d");
                    if (minimize_mapping_cost) {
                        c = sdiunrooted.getMinimalMappingCost();
                        sum_costs += (long)c;
                        out.print("\t L=" + c);
                    }
                    if (minimize_height) {
                        out.print("\t h=" + df.format(sdiunrooted.getMinimalTreeHeight()));
                        out.print("\t d=" + df.format(sdiunrooted.getMinimalDiffInSubTreeHeights()));
                        sum_tree_heights += sdiunrooted.getMinimalTreeHeight();
                        sum_subtree_diff += sdiunrooted.getMinimalDiffInSubTreeHeights();
                    }
                    out.println();
                    time_for_sdi += sdiunrooted.getTimeSumSDI();
                    if (write_trees) {
                        outtree = new File(outdir, new File((String)filenames[i]).getName());
                        PhylogenyWriter writer = new PhylogenyWriter();
                        writer.toPhyloXML(outtree, trees[0], 1);
                    }
                }
            }
            ++i;
        }
        PhylogenyNode.setNodeCount(nodecount0);
        out.println("\nInput trees were in NHX format.");
        System.out.println("\nInput trees were in NHX format.");
        if (minimize_mapping_cost) {
            out.println("\nRooted by minimizing mapping cost L.");
            System.out.println("\nRooted by minimizing mapping cost L.");
            if (minimize_height) {
                out.println("Selected tree(s) with minimal height out of resulting trees.");
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
        } else if (minimize_sum_of_dup) {
            out.println("\nRooted by minimizing sum of duplications.");
            System.out.println("\nRooted by minimizing sum of duplications.");
            if (minimize_height) {
                out.println("Selected tree(s) with minimal height out of resulting trees.");
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
        } else if (minimize_height) {
            out.println("\nRooted by minimizing tree height.");
            System.out.println("\nRooted by minimizing tree height.");
        } else {
            out.println("\nNo (re) rooting was performed.");
            System.out.println("\nNo (re) rooting was performed.");
        }
        time0 = (System.currentTimeMillis() - time0) / 1000L;
        out.println("\nTrees directory  : " + indir);
        out.println("Suffix for trees : " + suffix);
        out.println("Species tree     : " + species_tree_file);
        out.println("Output directory : " + outdir);
        out.println("Output file      : " + outfile);
        out.println("\nTotal number of attempts (tree files read)       : " + j);
        out.println("Total number of successfully assigned trees      : " + successful);
        out.println("Number of too small trees                        : " + number_of_too_small_trees);
        out.println("Number of too large trees                        : " + number_of_too_large_trees);
        out.println("\nSum of duplications                                   : " + total_number_of_d);
        if (minimize_mapping_cost) {
            out.println("Sum of mapping costs L                                : " + sum_costs);
        }
        if (minimize_height) {
            out.println("Sum of tree heights                                   : " + sum_tree_heights);
            out.println("Sum of differences in subtree heights                 : " + sum_subtree_diff);
        }
        out.println("Sum of external nodes (in successfully assigned trees): " + total_number_of_ext_nodes);
        out.println("\nTime sum for actual SDI: " + time_for_sdi + "ms");
        out.println("\nTotal time             : " + time0 + "s");
        out.close();
        System.out.println("\nTotal number of attempts (tree files read)       : " + j);
        System.out.println("Total number of successfully assigned trees      : " + successful);
        System.out.println("Number of too small trees                        : " + number_of_too_small_trees);
        System.out.println("Number of too large trees                        : " + number_of_too_large_trees);
        System.out.println("\nSum of duplications                                   : " + total_number_of_d);
        if (minimize_mapping_cost) {
            System.out.println("Sum of mapping costs L                                : " + sum_costs);
        }
        if (minimize_height) {
            System.out.println("Sum of tree heights                                   : " + sum_tree_heights);
            System.out.println("Sum of differences in subtree heights                 : " + sum_subtree_diff);
        }
        System.out.println("Sum of external nodes (in successfully assigned trees): " + total_number_of_ext_nodes);
        System.out.println("\nTime sum for actual SDI: " + time_for_sdi + "ms");
        System.out.println("\nTotal time             : " + time0 + "s");
        out_ddist = new PrintWriter((Writer)new FileWriter(ddist_outfile), true);
        i = 0;
        while (i < duplications.length && i <= 50) {
            out_ddist.println(String.valueOf(i) + " " + duplications[i]);
            ++i;
        }
        out_ddist.close();
        out_sdist = new PrintWriter((Writer)new FileWriter(sdist_outfile), true);
        i = 0;
        while (i < sizes.length && i <= 1000) {
            out_sdist.println(String.valueOf(i) + " " + sizes[i]);
            ++i;
        }
        out_sdist.close();
        System.out.println("\nDone.");
    }

    public static void main(String[] args) {
        boolean minimize_mapping_cost = false;
        boolean minimize_sum_of_dup = true;
        boolean minimize_height = true;
        boolean write_trees = false;
        File indir = null;
        File speciestree_file = null;
        File outdir = null;
        File outfile = null;
        String suffix = null;
        if (args.length == 5) {
            indir = new File(args[0]);
            suffix = args[1];
            speciestree_file = new File(args[2]);
            outdir = new File(args[3]);
            outfile = new File(args[4]);
        } else if (args.length == 6) {
            if (args[0].startsWith("-")) {
                minimize_mapping_cost = false;
                minimize_sum_of_dup = false;
                minimize_height = false;
                write_trees = false;
                if (args[0].toLowerCase().indexOf("w") != -1) {
                    write_trees = true;
                }
                if (args[0].toLowerCase().indexOf("l") != -1) {
                    minimize_mapping_cost = true;
                }
                if (args[0].toLowerCase().indexOf("d") != -1) {
                    minimize_sum_of_dup = true;
                }
                if (args[0].toLowerCase().indexOf("h") != -1) {
                    minimize_height = true;
                }
            } else {
                SDIdirectory.errorInCommandLine();
            }
            indir = new File(args[1]);
            suffix = args[2];
            speciestree_file = new File(args[3]);
            outdir = new File(args[4]);
            outfile = new File(args[5]);
        } else {
            SDIdirectory.errorInCommandLine();
        }
        if (minimize_mapping_cost && minimize_sum_of_dup) {
            minimize_sum_of_dup = false;
        }
        try {
            SDIdirectory.infer(indir, speciestree_file, outdir, outfile, suffix, write_trees, minimize_mapping_cost, minimize_sum_of_dup, minimize_height);
        }
        catch (Exception e) {
            System.err.println("\nSDIdirectory: Error: " + e + "\n");
            System.exit(-1);
        }
    }
}

