/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.Species;
import org.forester.util.ForesterUtil;

public class BasicSpecies
implements Species {
    private final String _species_id;

    public BasicSpecies(String species_id) {
        if (ForesterUtil.isEmpty(species_id)) {
            throw new IllegalArgumentException("attempt to create new species from empty or null string");
        }
        this._species_id = species_id.trim();
    }

    @Override
    public int compareTo(Species species) {
        if (this == species) {
            return 0;
        }
        return this.getSpeciesId().toLowerCase().compareTo(species.getSpeciesId().toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getSpeciesId().equals(((Species)o).getSpeciesId());
    }

    @Override
    public String getSpeciesId() {
        return this._species_id;
    }

    public int hashCode() {
        return this.getSpeciesId().hashCode();
    }

    public String toString() {
        return this.getSpeciesId();
    }
}

