/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.forester.util.ForesterUtil;

public final class CommandLineArguments {
    private static final String OPTIONS_PREFIX = "-";
    private static final String EXTENDED_OPTIONS_PREFIX = "--";
    private static final String OPTIONS_SEPARATOR = "=";
    private Map<String, String> _options;
    private Map<String, String> _extended_options;
    private List<String> _names;
    private String _command_line_str;

    public CommandLineArguments(String[] args) throws IOException {
        this.init();
        this.parseCommandLineArguments(args);
    }

    private Map<String, String> getAllOptions() {
        HashMap<String, String> o = new HashMap<String, String>();
        o.putAll(this.getOptionsList());
        o.putAll(this.getExtendedOptionsList());
        return o;
    }

    public String getCommandLineArgsAsString() {
        return this._command_line_str;
    }

    private Map<String, String> getExtendedOptionsList() {
        return this._extended_options;
    }

    public File getFile(int i) {
        return new File(this.getNames()[i]);
    }

    public String getName(int i) {
        return this.getNames()[i];
    }

    public String[] getNames() {
        String[] a = new String[this.getNamesList().size()];
        return this.getNamesList().toArray(a);
    }

    private List<String> getNamesList() {
        return this._names;
    }

    public int getNumberOfNames() {
        return this.getNames().length;
    }

    private Map<String, String> getOptionsList() {
        return this._options;
    }

    public String getOptionValue(String option_name) throws IllegalArgumentException {
        Map<String, String> o = this.getAllOptions();
        if (o.containsKey(option_name)) {
            String value = o.get(option_name);
            if (!ForesterUtil.isEmpty(value)) {
                return value;
            }
            throw new IllegalArgumentException("value for \"" + option_name + "\" is not set");
        }
        throw new IllegalArgumentException("option \"" + option_name + "\" is not set");
    }

    public String getOptionValueAsCleanString(String option_name) throws IllegalArgumentException {
        return this.getOptionValue(option_name).replaceAll("\"", "").replaceAll("'", "");
    }

    public double getOptionValueAsDouble(String option_name) throws IOException {
        double d = -1.7976931348623157E308;
        try {
            d = new Double(this.getOptionValue(option_name));
        }
        catch (NumberFormatException e) {
            throw new IOException("value for option \"" + option_name + "\" is expected to be of type double");
        }
        return d;
    }

    public int getOptionValueAsInt(String option_name) throws IOException {
        int i = Integer.MIN_VALUE;
        try {
            i = new Integer(this.getOptionValue(option_name));
        }
        catch (NumberFormatException e) {
            throw new IOException("value for option \"" + option_name + "\" is expected to be of type integer");
        }
        return i;
    }

    public long getOptionValueAsLong(String option_name) throws IOException {
        long l = Long.MIN_VALUE;
        try {
            l = new Long(this.getOptionValue(option_name));
        }
        catch (NumberFormatException e) {
            throw new IOException("value for option \"" + option_name + "\" is expected to be of type long");
        }
        return l;
    }

    private void init() {
        this._options = new HashMap<String, String>();
        this._extended_options = new HashMap<String, String>();
        this._names = new ArrayList<String>();
        this._command_line_str = "";
    }

    public boolean isOptionHasAValue(String option_name) {
        Map<String, String> o = this.getAllOptions();
        if (o.containsKey(option_name)) {
            String value = o.get(option_name);
            return !ForesterUtil.isEmpty(value);
        }
        throw new IllegalArgumentException("option \"" + option_name + "\" is not set");
    }

    public boolean isOptionSet(String option_name) {
        Map<String, String> o = this.getAllOptions();
        return o.containsKey(option_name);
    }

    public boolean isOptionValueSet(String option_name) throws IllegalArgumentException {
        Map<String, String> o = this.getAllOptions();
        if (o.containsKey(option_name)) {
            return !ForesterUtil.isEmpty(o.get(option_name));
        }
        throw new IllegalArgumentException("option \"" + option_name + "\" is not set");
    }

    private void parseCommandLineArguments(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            String arg = args[i].trim();
            this._command_line_str = String.valueOf(this._command_line_str) + arg;
            if (i < args.length - 1) {
                this._command_line_str = String.valueOf(this._command_line_str) + " ";
            }
            if (arg.startsWith(EXTENDED_OPTIONS_PREFIX)) {
                this.parseOption(arg.substring(EXTENDED_OPTIONS_PREFIX.length()), this.getExtendedOptionsList());
            } else if (arg.startsWith(OPTIONS_PREFIX)) {
                this.parseOption(arg.substring(OPTIONS_PREFIX.length()), this.getOptionsList());
            } else {
                this.getNamesList().add(arg);
            }
            ++i;
        }
    }

    private void parseOption(String option, Map<String, String> options_map) throws IOException {
        int sep_index = option.indexOf(OPTIONS_SEPARATOR);
        if (sep_index < 1) {
            if (ForesterUtil.isEmpty(option)) {
                throw new IOException("attempt to set option with an empty name");
            }
            if (this.getAllOptions().containsKey(option)) {
                throw new IOException("attempt to set option \"" + option + "\" mutiple times");
            }
            options_map.put(option, null);
        } else {
            String key = option.substring(0, sep_index);
            String value = option.substring(sep_index + 1);
            if (ForesterUtil.isEmpty(key)) {
                throw new IllegalArgumentException("attempt to set option with an empty name");
            }
            if (this.getAllOptions().containsKey(key)) {
                throw new IllegalArgumentException("attempt to set option \"" + key + "\" mutiple times [" + option + "]");
            }
            options_map.put(key, value);
        }
    }

    public List<String> validateAllowedOptions(List<String> allowed_options) {
        Map<String, String> options = this.getAllOptions();
        ArrayList<String> dissallowed = new ArrayList<String>();
        for (String o : options.keySet()) {
            if (allowed_options.contains(o)) continue;
            dissallowed.add(o);
        }
        return dissallowed;
    }

    public String validateAllowedOptionsAsString(List<String> allowed_options) {
        List<String> dissallowed = this.validateAllowedOptions(allowed_options);
        String dissallowed_string = "";
        Iterator<String> iter = dissallowed.iterator();
        while (iter.hasNext()) {
            dissallowed_string = String.valueOf(dissallowed_string) + "\"" + iter.next();
            dissallowed_string = iter.hasNext() ? String.valueOf(dissallowed_string) + "\", " : String.valueOf(dissallowed_string) + "\"";
        }
        return dissallowed_string;
    }

    public List<String> validateMandatoryOptions(List<String> mandatory_options) {
        Map<String, String> options = this.getAllOptions();
        ArrayList<String> missing = new ArrayList<String>();
        for (String string : mandatory_options) {
            String ma = string;
            if (options.containsKey(ma)) continue;
            missing.add(ma);
        }
        return missing;
    }

    public String validateMandatoryOptionsAsString(List<String> mandatory_options) {
        List<String> missing = this.validateMandatoryOptions(mandatory_options);
        String missing_string = "";
        Iterator<String> iter = missing.iterator();
        while (iter.hasNext()) {
            missing_string = String.valueOf(missing_string) + "\"" + iter.next();
            missing_string = iter.hasNext() ? String.valueOf(missing_string) + "\", " : String.valueOf(missing_string) + "\"";
        }
        return missing_string;
    }
}

