/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import ext.swing.ZActionListener;
import ext.swing.ZButton;
import ext.swing.ZLabelPane;
import ext.swing.ZToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class ZAbstractTreePanel
extends ZLabelPane {
    private TreeModel model = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel P_tree = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel P_toolBar = new JPanel();
    protected ZToolBar toolBar = new ZToolBar();
    private ZButton B_refresh = new ZButton();
    private BorderLayout borderLayout3 = new BorderLayout();
    private ZButton B_expand = new ZButton();
    private ZButton B_collapse = new ZButton();
    private JPanel P_tree2 = new JPanel();
    private JPanel P_searchBar = new JPanel();
    private JScrollPane LP_tree = new JScrollPane();
    private BorderLayout borderLayout4 = new BorderLayout();
    protected JTree tree = new JTree();
    private JLabel L_searchFor = new JLabel();
    private JTextField TF_search = new JTextField();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JPanel panel = new JPanel(new BorderLayout());

    protected abstract TreeModel createModel();

    protected abstract void nodeDoubleClicked();

    protected abstract void nodeSelected();

    protected abstract void initButtons();

    public ZAbstractTreePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        this.model = this.createModel();
        this.tree.setModel(this.model);
        this.expandAll();
        this.initButtons();
    }

    public void expandAll() {
        TreePath rootPath = this.tree.getPathForRow(0);
        Object root = rootPath.getLastPathComponent();
        this.expandDown(rootPath, root);
        this.tree.expandRow(0);
    }

    public void collapseAll() {
        TreePath rootPath = this.tree.getPathForRow(0);
        Object root = rootPath.getLastPathComponent();
        this.collapseDown(rootPath, root);
        this.tree.collapseRow(0);
    }

    public void addButton(String name, String tip, final ZActionListener listener) {
        this.toolBar.addButton(name, "", tip);
        this.toolBar.getButton(name).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                listener.action(ZAbstractTreePanel.this.getSelectedNode());
            }
        });
    }

    public ZToolBar getToolBar() {
        return this.toolBar;
    }

    public JTree getTree() {
        return this.tree;
    }

    public Object getSelectedNode() {
        return this.tree.getLastSelectedPathComponent();
    }

    public void gotoNode(String name) {
        int rows = this.tree.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath path = this.tree.getPathForRow(i);
            Object obj = path.getLastPathComponent();
            if (!name.toUpperCase().equals(obj.toString().toUpperCase())) continue;
            this.tree.setSelectionRow(i);
            return;
        }
    }

    public void CSGotoNode(String name) {
        int rows = this.tree.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath path = this.tree.getPathForRow(i);
            Object obj = path.getLastPathComponent();
            if (!name.equals(obj.toString())) continue;
            this.tree.setSelectionRow(i);
            return;
        }
    }

    private void expandDown(TreePath path, Object obj) {
        if (this.model.isLeaf(obj)) {
            return;
        }
        this.tree.expandPath(path);
        int count = this.model.getChildCount(obj);
        for (int i = 0; i < count; ++i) {
            Object child = this.model.getChild(obj, i);
            this.expandDown(path.pathByAddingChild(child), child);
        }
    }

    private void collapseDown(TreePath path, Object obj) {
        if (this.model.isLeaf(obj)) {
            return;
        }
        this.tree.collapsePath(path);
        int count = this.model.getChildCount(obj);
        for (int i = 0; i < count; ++i) {
            Object child = this.model.getChild(obj, i);
            this.collapseDown(path.pathByAddingChild(child), child);
        }
    }

    private void obscureGotoNode(String name) {
        int rows = this.tree.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath path = this.tree.getPathForRow(i);
            Object obj = path.getLastPathComponent();
            if (obj.toString().toUpperCase().indexOf(name.toUpperCase()) == -1) continue;
            this.tree.setSelectionRow(i);
            return;
        }
    }

    private void jbInit() throws Exception {
        this.P_tree.setLayout(this.borderLayout2);
        this.P_toolBar.setLayout(this.borderLayout3);
        this.toolBar.setFloatable(false);
        this.addButton("refresh", "refresh", new ZActionListener(){

            public void action(Object obj) {
                ZAbstractTreePanel.this.refresh();
            }
        });
        this.addButton("expand", "expand", new ZActionListener(){

            public void action(Object obj) {
                ZAbstractTreePanel.this.expandAll();
            }
        });
        this.addButton("collapse", "collapse", new ZActionListener(){

            public void action(Object obj) {
                ZAbstractTreePanel.this.collapseAll();
            }
        });
        this.P_tree2.setLayout(this.borderLayout4);
        this.P_searchBar.setLayout(this.borderLayout5);
        this.L_searchFor.setText("  Search for  ");
        this.borderLayout5.setHgap(3);
        this.P_searchBar.setBorder(BorderFactory.createRaisedBevelBorder());
        this.tree.setShowsRootHandles(true);
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                ZAbstractTreePanel.this.tree_keyTyped(e);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ZAbstractTreePanel.this.tree_mouseClicked(e);
            }
        });
        this.TF_search.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ZAbstractTreePanel.this.TF_search_focusLost(e);
            }
        });
        this.TF_search.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                ZAbstractTreePanel.this.TF_search_keyTyped(e);
            }
        });
        this.panel.add((Component)this.P_tree, "Center");
        this.P_tree.add((Component)this.P_tree2, "Center");
        this.P_tree2.add((Component)this.LP_tree, "Center");
        this.LP_tree.getViewport().add((Component)this.tree, null);
        this.P_searchBar.add((Component)this.L_searchFor, "West");
        this.P_searchBar.add((Component)this.TF_search, "Center");
        this.panel.add((Component)this.P_toolBar, "South");
        this.P_toolBar.add((Component)this.toolBar, "Center");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (ZAbstractTreePanel.this.getSelectedNode() == null) {
                    return;
                }
                ZAbstractTreePanel.this.nodeSelected();
            }
        });
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.setComponent(this.panel);
    }

    private void tree_mouseClicked(MouseEvent e) {
        int clickCount = e.getClickCount();
        int selectionCount = this.tree.getSelectionCount();
        if (selectionCount == 0) {
            return;
        }
        if (clickCount == 2) {
            this.nodeDoubleClicked();
        }
    }

    private void tree_keyTyped(KeyEvent e) {
        this.P_tree.add((Component)this.P_searchBar, "South");
        this.TF_search.setText(String.valueOf(e.getKeyChar()));
        this.P_tree.validate();
        this.TF_search.requestFocus();
        this.obscureGotoNode(this.TF_search.getText());
    }

    private void TF_search_focusLost(FocusEvent e) {
        this.P_tree.remove(this.P_searchBar);
        this.P_tree.validate();
    }

    private void TF_search_keyTyped(KeyEvent e) {
        this.obscureGotoNode(this.TF_search.getText());
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ZAbstractTreePanel(){

            protected TreeModel createModel() {
                JTree tree = new JTree();
                return tree.getModel();
            }

            protected void nodeDoubleClicked() {
                System.out.println("double clicked of ".concat(String.valueOf(String.valueOf(this.getSelectedNode().toString()))));
            }

            protected void nodeSelected() {
                System.out.println("single clicked of ".concat(String.valueOf(String.valueOf(this.getSelectedNode().toString()))));
            }

            protected void initButtons() {
            }
        });
        frame.pack();
        ((Component)frame).setVisible(true);
    }
}

