/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWriteContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

final class Doctype
extends NodeBase
implements DocumentType {
    private String name;
    private Nodemap entities;
    private Nodemap notations;
    private String publicId;
    private String systemId;
    private String internalSubset;

    Doctype(String n) {
        this.name = n;
        this.entities = new Nodemap();
        this.notations = new Nodemap();
    }

    Doctype(String pub, String sys, String subset) {
        this.publicId = pub;
        this.systemId = sys;
        this.internalSubset = subset;
    }

    void addEntityNode(String name, String value) {
        if ("lt".equals(name) || "gt".equals(name) || "apos".equals(name) || "quot".equals(name) || "amp".equals(name)) {
            return;
        }
        EntityNode node = new EntityNode(name, value);
        node.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(node);
    }

    void addEntityNode(String name, String pub, String sys, String not) {
        EntityNode node = new EntityNode(name, pub, sys, not);
        node.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(node);
    }

    void addNotation(String name, String pub, String sys) {
        NotationNode node = new NotationNode(name, pub, sys);
        node.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.notations.setNamedItem(node);
    }

    public Node cloneNode(boolean deep) {
        throw new RuntimeException(this.getMessage("DT-000"));
    }

    public NamedNodeMap getEntities() {
        return this.entities;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public short getNodeType() {
        return 10;
    }

    public NamedNodeMap getNotations() {
        return this.notations;
    }

    void setOwnerDocument(XmlDocument doc) {
        int i;
        super.setOwnerDocument(doc);
        if (this.entities != null) {
            i = 0;
            while (this.entities.item(i) != null) {
                ((NodeBase)this.entities.item(i)).setOwnerDocument(doc);
                ++i;
            }
        }
        if (this.notations != null) {
            i = 0;
            while (this.notations.item(i) != null) {
                ((NodeBase)this.notations.item(i)).setOwnerDocument(doc);
                ++i;
            }
        }
    }

    void setPrintInfo(String pub, String sys, String subset) {
        this.publicId = pub;
        this.systemId = sys;
        this.internalSubset = subset;
    }

    void setReadonly() {
        this.entities.readonly = true;
        this.notations.readonly = true;
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        Element root = this.getOwnerDocument().getDocumentElement();
        out.write("<!DOCTYPE ");
        out.write(root == null ? "UNKNOWN-ROOT" : root.getNodeName());
        if (this.systemId != null) {
            if (this.publicId != null) {
                out.write(" PUBLIC '");
                out.write(this.publicId);
                out.write("' '");
            } else {
                out.write(" SYSTEM '");
            }
            out.write(this.systemId);
            out.write("'");
        }
        if (this.internalSubset != null) {
            out.write(XmlDocument.eol);
            out.write("[");
            out.write(this.internalSubset);
            out.write("]");
        }
        out.write(">");
        out.write(XmlDocument.eol);
    }

    static class NotationNode
    extends NodeBase
    implements Notation {
        private String notation;
        private String publicId;
        private String systemId;

        NotationNode(String name, String pub, String sys) {
            this.notation = name;
            this.publicId = pub;
            this.systemId = sys;
        }

        public Node cloneNode(boolean ignored) {
            NotationNode retval = new NotationNode(this.notation, this.publicId, this.systemId);
            retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return retval;
        }

        public String getNodeName() {
            return this.notation;
        }

        public short getNodeType() {
            return 12;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            Writer out = context.getWriter();
            out.write("<!NOTATION ");
            out.write(this.notation);
            if (this.publicId != null) {
                out.write(" PUBLIC '");
                out.write(this.publicId);
                if (this.systemId != null) {
                    out.write("' '");
                    out.write(this.systemId);
                }
            } else {
                out.write(" SYSTEM '");
                out.write(this.systemId);
            }
            out.write("'>");
        }
    }

    static class EntityNode
    extends NodeBase
    implements Entity {
        private String entityName;
        private String publicId;
        private String systemId;
        private String notation;
        private String value;

        EntityNode(String name, String value) {
            this.entityName = name;
            this.value = value;
        }

        EntityNode(String name, String pub, String sys, String not) {
            this.entityName = name;
            this.publicId = pub;
            this.systemId = sys;
            this.notation = not;
        }

        public Node cloneNode(boolean ignored) {
            EntityNode retval = new EntityNode(this.entityName, this.publicId, this.systemId, this.notation);
            retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return retval;
        }

        public String getNodeName() {
            return this.entityName;
        }

        public short getNodeType() {
            return 6;
        }

        public String getNotationName() {
            return this.notation;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            Writer out = context.getWriter();
            out.write("<!ENTITY ");
            out.write(this.entityName);
            if (this.value == null) {
                if (this.publicId != null) {
                    out.write(" PUBLIC '");
                    out.write(this.publicId);
                    out.write("' '");
                } else {
                    out.write(" SYSTEM '");
                }
                out.write(this.systemId);
                out.write("'");
                if (this.notation != null) {
                    out.write(" NDATA ");
                    out.write(this.notation);
                }
            } else {
                out.write(" \"");
                int length = this.value.length();
                int i = 0;
                while (i < length) {
                    char c = this.value.charAt(i);
                    if (c == '\"') {
                        out.write("&quot;");
                    } else {
                        out.write(c);
                    }
                    ++i;
                }
                out.write(34);
            }
            out.write(">");
        }
    }

    static class Nodemap
    implements NamedNodeMap {
        boolean readonly;
        Vector list = new Vector();

        Nodemap() {
        }

        public int getLength() {
            return this.list.size();
        }

        public Node getNamedItem(String name) {
            int length = this.list.size();
            int i = 0;
            while (i < length) {
                Node value = this.item(i);
                if (value.getNodeName().equals(name)) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public Node item(int index) {
            if (index < 0 || index >= this.list.size()) {
                return null;
            }
            return (Node)this.list.elementAt(index);
        }

        public Node removeNamedItem(String name) throws DOMException {
            throw new DomEx(7);
        }

        public Node setNamedItem(Node item) throws DOMException {
            if (this.readonly) {
                throw new DomEx(7);
            }
            this.list.addElement(item);
            return null;
        }
    }
}

