/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.CDataNode;
import com.sun.xml.tree.CommentNode;
import com.sun.xml.tree.Doctype;
import com.sun.xml.tree.DocumentEx;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementEx;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.PINode;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.TextNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocumentBuilder;
import com.sun.xml.tree.XmlWriteContext;
import com.sun.xml.util.MessageCatalog;
import com.sun.xml.util.XmlNames;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDocument
extends ParentNode
implements DocumentEx,
DOMImplementation {
    static String eol;
    static final MessageCatalog catalog;
    private Locale locale = Locale.getDefault();
    private String systemId;
    private ElementFactory factory;
    int mutationCount;
    static /* synthetic */ Class class$com$sun$xml$tree$XmlDocument$Catalog;

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            temp = "\n";
        }
        eol = temp;
        catalog = new Catalog();
    }

    public Node appendChild(Node n) throws DOMException {
        if (n instanceof Element && this.getDocument() != null) {
            throw new DomEx(3);
        }
        if (n instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.appendChild(n);
    }

    public final void changeNodeOwner(Node node) throws DOMException {
        AttributeNode attr;
        ElementNode scope;
        if (node.getOwnerDocument() == this) {
            return;
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(4);
        }
        switch (node.getNodeType()) {
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                throw new DomEx(3);
            }
        }
        if (node instanceof AttributeNode && (scope = (attr = (AttributeNode)node).getNameScope()) != null && scope.getOwnerDocument() != this) {
            throw new DomEx(3);
        }
        NodeBase n = (NodeBase)node.getParentNode();
        if (n != null) {
            n.removeChild(node);
        }
        TreeWalker walker = new TreeWalker(node);
        n = (NodeBase)walker.getCurrent();
        while (n != null) {
            n.setOwnerDocument(this);
            if (n instanceof ElementNode) {
                NamedNodeMap list = n.getAttributes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    this.changeNodeOwner(list.item(i));
                    ++i;
                }
            }
            n = (NodeBase)walker.getNext();
        }
    }

    void checkChildType(int type) throws DOMException {
        switch (type) {
            case 1: 
            case 7: 
            case 8: 
            case 10: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public Locale chooseLocale(String[] languages) {
        Locale l = catalog.chooseLocale(languages);
        if (l != null) {
            this.setLocale(l);
        }
        return l;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Node cloneNode(boolean deep) {
        XmlDocument retval = new XmlDocument();
        retval.systemId = this.systemId;
        if (deep) {
            Node node;
            int i = 0;
            while ((node = this.item(i)) != null) {
                if (!(node instanceof DocumentType)) {
                    node = node.cloneNode(true);
                    retval.changeNodeOwner(node);
                    retval.appendChild(node);
                }
                ++i;
            }
        }
        return retval;
    }

    public Attr createAttribute(String name) throws DOMException {
        if (!XmlNames.isName(name)) {
            throw new DomEx(5);
        }
        AttributeNode retval = new AttributeNode(name, null, true, null);
        retval.setOwnerDocument(this);
        return retval;
    }

    public CDATASection createCDATASection(String text) {
        CDataNode retval = new CDataNode();
        if (text != null) {
            retval.setText(text.toCharArray());
        }
        retval.setOwnerDocument(this);
        return retval;
    }

    public Comment createComment(String data) {
        CommentNode retval = new CommentNode(data);
        retval.setOwnerDocument(this);
        return retval;
    }

    Doctype createDoctype(String name) {
        Doctype retval = new Doctype(name);
        retval.setOwnerDocument(this);
        return retval;
    }

    public DocumentFragment createDocumentFragment() {
        DocFragNode retval = new DocFragNode();
        retval.setOwnerDocument(this);
        return retval;
    }

    public final Element createElement(String tagName) throws DOMException {
        return this.createElementEx(tagName);
    }

    public final ElementEx createElementEx(String tagName) throws DOMException {
        if (!XmlNames.isName(tagName)) {
            throw new DomEx(5);
        }
        ElementNode retval = this.factory != null ? (ElementNode)this.factory.createElementEx(tagName) : new ElementNode();
        retval.setTag(tagName);
        retval.setOwnerDocument(this);
        return retval;
    }

    public final ElementEx createElementEx(String uri, String tagName) throws DOMException {
        if (!XmlNames.isName(tagName)) {
            throw new DomEx(5);
        }
        ElementNode retval = this.factory != null ? (ElementNode)this.factory.createElementEx(uri, tagName) : new ElementNode();
        retval.setTag(tagName);
        retval.setOwnerDocument(this);
        return retval;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (!XmlNames.isName(name)) {
            throw new DomEx(5);
        }
        EntityRefNode retval = new EntityRefNode(name);
        retval.setOwnerDocument(this);
        return retval;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String instructions) throws DOMException {
        if (!XmlNames.isName(target)) {
            throw new DomEx(5);
        }
        PINode retval = new PINode(target, instructions);
        retval.setOwnerDocument(this);
        return retval;
    }

    public Text createTextNode(String text) {
        TextNode retval = new TextNode();
        retval.setOwnerDocument(this);
        if (text != null) {
            retval.setText(text.toCharArray());
        }
        return retval;
    }

    public XmlWriteContext createWriteContext(Writer out) {
        return new ExtWriteContext(out);
    }

    public XmlWriteContext createWriteContext(Writer out, int level) {
        return new ExtWriteContext(out, level);
    }

    public static XmlDocument createXmlDocument(InputStream in, boolean doValidate) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(in), doValidate);
    }

    public static XmlDocument createXmlDocument(String documentURI) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(documentURI), false);
    }

    public static XmlDocument createXmlDocument(String documentURI, boolean doValidate) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(documentURI), doValidate);
    }

    public static XmlDocument createXmlDocument(InputSource in, boolean doValidate) throws IOException, SAXException {
        XmlDocumentBuilder builder;
        Parser parser;
        try {
            parser = doValidate ? new ValidatingParser(true) : new Parser();
            parser.setEntityResolver(new Resolver());
            builder = new XmlDocumentBuilder();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        builder.setParser(parser);
        parser.parse(in);
        return builder.getDocument();
    }

    public final DocumentType getDoctype() {
        int i = 0;
        Node n;
        while ((n = this.item(i)) != null) {
            if (n instanceof DocumentType) {
                return (DocumentType)n;
            }
            ++i;
        }
        return null;
    }

    ElementNode getDocument() {
        int i = 0;
        Node n;
        while ((n = this.item(i)) != null) {
            if (n instanceof ElementNode) {
                return (ElementNode)n;
            }
            ++i;
        }
        return null;
    }

    public Element getDocumentElement() {
        return this.getDocument();
    }

    public ElementEx getElementExById(String id) {
        ElementEx element;
        if (id == null) {
            throw new IllegalArgumentException(this.getMessage("XD-000"));
        }
        TreeWalker w = new TreeWalker(this);
        while ((element = (ElementEx)w.getNextElement(null)) != null) {
            String value;
            String idAttr = element.getIdAttributeName();
            if (idAttr == null || !(value = element.getAttribute(idAttr)).equals(id)) continue;
            return element;
        }
        return null;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public DOMImplementation getImplementation() {
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final String getNodeName() {
        return "#document";
    }

    public final short getNodeType() {
        return 9;
    }

    public Document getOwnerDoc() {
        return null;
    }

    public final String getSystemId() {
        return this.systemId;
    }

    public boolean hasFeature(String feature, String version) {
        if (!"XML".equalsIgnoreCase(feature)) {
            return false;
        }
        return version == null && "1.0".equals(version);
    }

    public Node insertBefore(Node n, Node refNode) throws DOMException {
        if (n instanceof Element && this.getDocument() != null) {
            throw new DomEx(3);
        }
        if (n instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.insertBefore(n, refNode);
    }

    static String java2std(String encodingName) {
        if (encodingName == null) {
            return null;
        }
        if (encodingName.startsWith("ISO8859_")) {
            return "ISO-8859-" + encodingName.substring(8);
        }
        if (encodingName.startsWith("8859_")) {
            return "ISO-8859-" + encodingName.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(encodingName) || "ASCII".equalsIgnoreCase(encodingName)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(encodingName)) {
            return "UTF-8";
        }
        if (encodingName.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(encodingName)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(encodingName)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(encodingName)) {
            return "EUC-JP";
        }
        return encodingName;
    }

    TextNode newText(char[] buf, int offset, int len) throws SAXException {
        TextNode retval = (TextNode)this.createTextNode(null);
        char[] data = new char[len];
        System.arraycopy(buf, offset, data, 0, len);
        retval.setText(data);
        return retval;
    }

    public DocumentType setDoctype(String dtdPublicId, String dtdSystemId, String internalSubset) {
        Doctype retval = (Doctype)this.getDoctype();
        if (retval != null) {
            retval.setPrintInfo(dtdPublicId, dtdSystemId, internalSubset);
        } else {
            retval = new Doctype(dtdPublicId, dtdSystemId, internalSubset);
            retval.setOwnerDocument(this);
            this.insertBefore(retval, this.getFirstChild());
        }
        return retval;
    }

    public final void setElementFactory(ElementFactory factory) {
        this.factory = factory;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public final void setSystemId(String uri) {
        this.systemId = uri;
    }

    public void write(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF8");
        this.write(writer, "UTF-8");
    }

    public void write(Writer out) throws IOException {
        String encoding = null;
        if (out instanceof OutputStreamWriter) {
            encoding = XmlDocument.java2std(((OutputStreamWriter)out).getEncoding());
        }
        this.write(out, encoding);
    }

    public void write(Writer out, String encoding) throws IOException {
        out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            out.write(" encoding=\"");
            out.write(encoding);
            out.write(34);
        }
        out.write("?>");
        out.write(eol);
        out.write(eol);
        this.writeChildrenXml(this.createWriteContext(out, 0));
        out.write(eol);
        out.flush();
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
        int length = this.getLength();
        Writer out = context.getWriter();
        if (length == 0) {
            return;
        }
        int i = 0;
        while (i < length) {
            ((NodeBase)this.item(i)).writeXml(context);
            out.write(eol);
            ++i;
        }
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        String encoding = null;
        if (out instanceof OutputStreamWriter) {
            encoding = XmlDocument.java2std(((OutputStreamWriter)out).getEncoding());
        }
        out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            out.write(" encoding=\"");
            out.write(encoding);
            out.write(34);
        }
        out.write("?>");
        out.write(eol);
        out.write(eol);
        this.writeChildrenXml(context);
    }

    static final class DocFragNode
    extends ParentNode
    implements DocumentFragment {
        DocFragNode() {
        }

        void checkChildType(int type) throws DOMException {
            switch (type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public Node cloneNode(boolean deep) {
            DocFragNode retval = new DocFragNode();
            if (deep) {
                throw new RuntimeException(this.getMessage("XD-001"));
            }
            return retval;
        }

        public String getNodeName() {
            Element root = this.getOwnerDocument().getDocumentElement();
            if (root != null) {
                return root.getNodeName();
            }
            return null;
        }

        public short getNodeType() {
            return 11;
        }

        public Node getParentNode() {
            return null;
        }

        public void setParentNode(Node p) {
            if (p != null) {
                throw new IllegalArgumentException();
            }
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            this.writeChildrenXml(context);
        }
    }

    static final class EntityRefNode
    extends ParentNode
    implements EntityReference {
        private String entity;

        EntityRefNode(String name) {
            if (name == null) {
                throw new IllegalArgumentException(this.getMessage("XD-002"));
            }
            this.entity = name;
        }

        void checkChildType(int type) throws DOMException {
            switch (type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public Node cloneNode(boolean deep) {
            return new EntityRefNode(this.entity);
        }

        public String getNodeName() {
            return this.entity;
        }

        public short getNodeType() {
            return 5;
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            if (!context.isEntityDeclared(this.entity)) {
                throw new IOException(this.getMessage("XD-003", new Object[]{this.entity}));
            }
            Writer out = context.getWriter();
            out.write(38);
            out.write(this.entity);
            out.write(59);
        }
    }

    class ExtWriteContext
    extends XmlWriteContext {
        ExtWriteContext(Writer out) {
            super(out);
        }

        ExtWriteContext(Writer out, int level) {
            super(out, level);
        }

        public boolean isEntityDeclared(String name) {
            if (super.isEntityDeclared(name)) {
                return true;
            }
            DocumentType doctype = XmlDocument.this.getDoctype();
            if (doctype == null) {
                return false;
            }
            return doctype.getEntities().getNamedItem(name) != null;
        }
    }

    static class Catalog
    extends MessageCatalog {
        Catalog() {
            super(class$com$sun$xml$tree$XmlDocument$Catalog != null ? class$com$sun$xml$tree$XmlDocument$Catalog : (class$com$sun$xml$tree$XmlDocument$Catalog = XmlDocument.class$("com.sun.xml.tree.XmlDocument$Catalog")));
        }
    }
}

