/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.association.CompressedMLMusingDoubleMatrix;
import net.maizegenetics.analysis.association.MLMOptionDialog;
import net.maizegenetics.dna.snp.GeneticMap;
import net.maizegenetics.gui.ReportDestinationDialog;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.trait.MarkerPhenotype;
import net.maizegenetics.trait.Phenotype;
import org.apache.log4j.Logger;

public class MLMPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MLMPlugin.class);
    protected DistanceMatrix kinshipMatrix;
    protected boolean analyzeByColumn;
    protected boolean useP3D = true;
    protected CompressionType compressionType = CompressionType.Optimum;
    protected double compression = 1.0;
    private boolean writeOutputToFile = false;
    private String outputName = null;
    private boolean filterOutput = false;
    private double maxp = 1.0;

    public MLMPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> maps = input.getDataOfType(GeneticMap.class);
            GeneticMap myMap = maps.size() > 0 ? (GeneticMap)maps.get(0).getData() : null;
            List<Datum> alignInList = input.getDataOfType(MarkerPhenotype.class);
            if (alignInList.size() == 0) {
                alignInList = input.getDataOfType(Phenotype.class);
            }
            List<Datum> kinshipList = input.getDataOfType(DistanceMatrix.class);
            if (alignInList.size() < 1) {
                String message = "Invalid selection. Please select sequence alignment or marker and trait data.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet = null;
                return dataSet;
            }
            if (kinshipList.size() != 1) {
                String message = "Please select exactly one kinship matrix.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet = null;
                return dataSet;
            }
            this.kinshipMatrix = (DistanceMatrix)kinshipList.get(0).getData();
            Iterator<Datum> itr = alignInList.iterator();
            if (this.isInteractive()) {
                MLMOptionDialog theOptions = new MLMOptionDialog(this.getParentFrame());
                if (theOptions.runClicked) {
                    this.useP3D = theOptions.useP3D();
                    this.compressionType = theOptions.getCompressionType();
                    this.compression = theOptions.getCompressionLevel();
                    theOptions.dispose();
                    ReportDestinationDialog rdd = new ReportDestinationDialog();
                    rdd.setLocationRelativeTo(this.getParentFrame());
                    rdd.setVisible(true);
                    if (!rdd.isOkayChecked()) {
                        DataSet dataSet = null;
                        return dataSet;
                    }
                    this.writeOutputToFile = rdd.wasUseFileChecked();
                    if (this.writeOutputToFile) {
                        this.outputName = rdd.getOutputFileName();
                    }
                    this.filterOutput = rdd.wasRestrictOutputChecked();
                    if (this.filterOutput) {
                        this.maxp = rdd.getMaxP();
                    }
                } else {
                    theOptions.dispose();
                    DataSet rdd = null;
                    return rdd;
                }
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            while (itr.hasNext()) {
                Datum current = itr.next();
                DataSet tds = null;
                try {
                    CompressedMLMusingDoubleMatrix theAnalysis;
                    if (this.useP3D) {
                        if (this.compressionType.equals((Object)CompressionType.Optimum)) {
                            theAnalysis = new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, true, Double.NaN, myMap);
                            tds = new DataSet(theAnalysis.solve(), (Plugin)this);
                        } else if (this.compressionType.equals((Object)CompressionType.Custom)) {
                            theAnalysis = new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, true, this.compression, myMap);
                            tds = new DataSet(theAnalysis.solve(), (Plugin)this);
                        } else {
                            theAnalysis = new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, false, true, Double.NaN, myMap);
                            tds = new DataSet(theAnalysis.solve(), (Plugin)this);
                        }
                    } else if (this.compressionType.equals((Object)CompressionType.Optimum)) {
                        theAnalysis = new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, false, Double.NaN, myMap);
                        tds = new DataSet(theAnalysis.solve(), (Plugin)this);
                    } else if (this.compressionType.equals((Object)CompressionType.Custom)) {
                        theAnalysis = new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, false, this.compression, myMap);
                        tds = new DataSet(theAnalysis.solve(), (Plugin)this);
                    } else {
                        theAnalysis = new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, false, false, Double.NaN, myMap);
                        tds = new DataSet(theAnalysis.solve(), (Plugin)this);
                    }
                }
                catch (Exception e) {
                    if (this.isInteractive()) {
                        JOptionPane.showMessageDialog(this.getParentFrame(), e.getMessage(), "Error", 0);
                        e.printStackTrace();
                    }
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
                if (tds == null) continue;
                result.add(tds);
                this.fireDataSetReturned(new PluginEvent(tds, MLMPlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = MLMPlugin.class.getResource("/net/maizegenetics/analysis/images/Mix.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "MLM";
    }

    @Override
    public String getToolTipText() {
        return "Association analysis using mixed model";
    }

    public void setAnalyzeByColumn(boolean analyzeByColumn) {
        this.analyzeByColumn = analyzeByColumn;
    }

    public void setMaximumNumOfIteration(int max) {
    }

    public void setFinalIterMarker(boolean myFinalIterMarker) {
    }

    public void addFactors(int[] factors) {
    }

    public void setColumnTypes(String[] types) {
    }

    public void addFactors(String[] names) {
    }

    public void updateProgress(int progress) {
        if (progress < 0) {
            progress = 0;
        } else if (progress > 100) {
            progress = 100;
        }
        this.fireProgress(progress);
    }

    public void setVarCompEst(String value) {
        if (value.equalsIgnoreCase("P3D")) {
            this.useP3D = true;
        } else if (value.equalsIgnoreCase("EachMarker")) {
            this.useP3D = false;
        } else {
            throw new IllegalArgumentException("MLMPlugin: setVarCompEst: don't know how to handle value: " + value);
        }
    }

    public void setCompressionType(CompressionType type) {
        this.compressionType = type;
    }

    public boolean isWriteOutputToFile() {
        return this.writeOutputToFile;
    }

    public void setWriteOutputToFile(boolean writeOutputToFile) {
        this.writeOutputToFile = writeOutputToFile;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
        this.writeOutputToFile = true;
    }

    public boolean isFilterOutput() {
        return this.filterOutput;
    }

    public void setFilterOutput(boolean filterOutput) {
        this.filterOutput = filterOutput;
    }

    public double getMaxp() {
        return this.maxp;
    }

    public void setMaxp(double maxp) {
        this.maxp = maxp;
        this.filterOutput = true;
    }

    public double getCustomCompression() {
        return this.compression;
    }

    public void setCustomCompression(double value) {
        this.compression = value;
    }

    public static enum CompressionType {
        Optimum,
        Custom,
        None;

    }
}

