/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.TableReportBoxWhiskerCatDataset;
import net.maizegenetics.analysis.chart.TableReportStatCategoryDataset;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;

public class BarChartPanel
extends BasicChartPanel {
    boolean isBoxWhisker = false;
    boolean isBar = false;
    boolean errBar = true;
    BorderLayout borderLayout1 = new BorderLayout();
    CategoryDataset dataset;
    ChartPanel chartPanel;
    TableReport theTable;
    JPanel controlPanel = new JPanel();
    JComboBox series1ComboBox;
    JComboBox series2ComboBox;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    String[] columnNames;
    int bins = 5;
    JComboBox categoryComboBox;
    JLabel jLabel3 = new JLabel();
    ButtonGroup errorButtonGroup = new ButtonGroup();
    JRadioButton errorRadioButton = new JRadioButton();
    JRadioButton deviationRadioButton = new JRadioButton();
    JRadioButton noErrRadioButton = new JRadioButton();
    JRadioButton boxWhiskerRadioButton = new JRadioButton();
    Component component1;
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public BarChartPanel(TableReport theTable) {
        this.theTable = theTable;
        try {
            Object[] colNames = theTable.getTableColumnNames();
            this.columnNames = new String[colNames.length + 1];
            this.columnNames[0] = "None";
            for (int i = 1; i < this.columnNames.length; ++i) {
                this.columnNames[i] = (String)colNames[i - 1];
            }
            this.dataset = null;
            this.chart = this.createChart(this.dataset, false, false);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(500, 270));
            this.chartPanel.setMouseZoomable(true, false);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BarChartPanel(TableReport theTable, int seriesCat, int seriesY1, int seriesY2, boolean isBoxWhisker, boolean isBar, boolean errBar) {
        this.theTable = theTable;
        this.isBoxWhisker = isBoxWhisker;
        this.isBar = isBar;
        this.errBar = errBar;
        this.dataset = this.createDataset(seriesCat, seriesY1, seriesY2, isBoxWhisker, errBar);
        this.chart = this.createChart(this.dataset, isBoxWhisker, isBar);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
    }

    void jbInit() throws Exception {
        this.categoryComboBox = new JComboBox<String>(this.columnNames);
        this.component1 = Box.createHorizontalStrut(8);
        this.setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("Y2");
        this.jLabel2.setText("Category");
        this.series1ComboBox = new JComboBox<String>(this.columnNames);
        this.series2ComboBox = new JComboBox<String>(this.columnNames);
        this.series1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartPanel.this.series1ComboBox_actionPerformed(e);
            }
        });
        this.series2ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartPanel.this.series2ComboBox_actionPerformed(e);
            }
        });
        this.controlPanel.setMinimumSize(new Dimension(394, 60));
        this.controlPanel.setPreferredSize(new Dimension(394, 60));
        this.categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartPanel.this.categoryComboBox_actionPerformed(e);
            }
        });
        this.jLabel3.setText("Y1");
        this.errorRadioButton.setToolTipText("Standard error of the mean");
        this.errorRadioButton.setText("Std Err");
        this.errorRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartPanel.this.errorRadioButton_actionPerformed(e);
            }
        });
        this.deviationRadioButton.setOpaque(true);
        this.deviationRadioButton.setToolTipText("Stardard deviation");
        this.deviationRadioButton.setText("Std Dev");
        this.deviationRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartPanel.this.deviationRadioButton_actionPerformed(e);
            }
        });
        this.noErrRadioButton.setSelected(true);
        this.noErrRadioButton.setText("None");
        this.noErrRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartPanel.this.noErrRadioButton_actionPerformed(e);
            }
        });
        this.boxWhiskerRadioButton.setToolTipText("Box and Whisker Plot");
        this.boxWhiskerRadioButton.setText("Box");
        this.boxWhiskerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartPanel.this.boxWhiskerRadioButton_actionPerformed(e);
            }
        });
        this.add((Component)this.chartPanel, "Center");
        this.add((Component)this.controlPanel, "North");
        this.errorButtonGroup.add(this.errorRadioButton);
        this.errorButtonGroup.add(this.deviationRadioButton);
        this.controlPanel.add((Component)this.series1ComboBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 30, 0, 12), 101, 3));
        this.controlPanel.add((Component)this.series2ComboBox, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 29, 0, 0), 90, 3));
        this.controlPanel.add((Component)this.jLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 42), 14, 7));
        this.controlPanel.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 19), 15, 7));
        this.controlPanel.add((Component)this.boxWhiskerRadioButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 2), 9, -2));
        this.controlPanel.add((Component)this.categoryComboBox, new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 83, 3));
        this.controlPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 8, 7));
        this.controlPanel.add((Component)this.noErrRadioButton, new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 13, 3, 0), 5, -2));
        this.controlPanel.add((Component)this.errorRadioButton, new GridBagConstraints(3, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 0), 1, -2));
        this.controlPanel.add((Component)this.deviationRadioButton, new GridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 2), 6, -2));
        this.controlPanel.add(this.component1, new GridBagConstraints(0, 1, 5, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 2), 382, 2));
        this.errorButtonGroup.add(this.noErrRadioButton);
        this.errorButtonGroup.add(this.boxWhiskerRadioButton);
    }

    CategoryDataset createDataset(int categoryColumn, int series1Column, int series2Column, boolean boxwhisker, boolean stderr) {
        int[] seriesY = series2Column > -1 ? new int[]{series1Column, series2Column} : new int[]{series1Column};
        Object dataset = boxwhisker ? new TableReportBoxWhiskerCatDataset(this.theTable, categoryColumn, seriesY) : new TableReportStatCategoryDataset(this.theTable, categoryColumn, seriesY, stderr);
        return dataset;
    }

    JFreeChart createChart(CategoryDataset dataset, boolean isBoxWhisker, boolean isBar) {
        String categoryName;
        String chartName;
        try {
            System.out.println("RowKey" + dataset.getRowKey(0));
            System.out.println("ColKey" + dataset.getColumnKey(0));
            chartName = "Mean " + dataset.getRowKey(0);
            if (dataset.getRowCount() > 1) {
                chartName = chartName + " and " + dataset.getRowKey(1);
            }
            categoryName = (String)this.categoryComboBox.getSelectedItem();
            chartName = chartName + " by " + categoryName;
        }
        catch (Exception ex) {
            System.out.println("Bar chart labels not ready");
            chartName = "Please choose a categorical variable and a numeric variable";
            categoryName = "Unknown";
        }
        if (isBoxWhisker) {
            CategoryAxis xAxis = new CategoryAxis(categoryName);
            NumberAxis yAxis = new NumberAxis("Mean");
            yAxis.setAutoRangeIncludesZero(false);
            BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
            renderer.setFillBox(false);
            CategoryPlot plot = new CategoryPlot((CategoryDataset)((TableReportBoxWhiskerCatDataset)dataset), xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
            this.chart = new JFreeChart(chartName, new Font("Helvetica", 1, 14), (Plot)plot, true);
        } else if (isBar) {
            CategoryAxis xAxis = new CategoryAxis(categoryName);
            NumberAxis yAxis = new NumberAxis("Mean");
            StatisticalBarRenderer renderer = new StatisticalBarRenderer();
            CategoryPlot plot = new CategoryPlot((CategoryDataset)((TableReportStatCategoryDataset)dataset), xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
            this.chart = new JFreeChart(chartName, new Font("Helvetica", 1, 14), (Plot)plot, true);
        } else {
            this.chart = ChartFactory.createBarChart((String)chartName, (String)categoryName, (String)"Mean", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        return this.chart;
    }

    void updateChart() {
        int series1 = this.series1ComboBox.getSelectedIndex() - 1;
        int series2 = this.series2ComboBox.getSelectedIndex() - 1;
        int categorySeries = this.categoryComboBox.getSelectedIndex() - 1;
        if (series1 > -1 && categorySeries > -1) {
            this.dataset = this.createDataset(categorySeries, series1, series2, this.isBoxWhisker, this.errBar);
            this.chart = this.createChart(this.dataset, this.isBoxWhisker, this.isBar);
            this.chartPanel.setChart(this.chart);
        }
    }

    void series1ComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void series2ComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void categoryComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void updateBarStyle() {
        if (this.boxWhiskerRadioButton.isSelected()) {
            this.isBoxWhisker = true;
            this.isBar = false;
        } else if (this.noErrRadioButton.isSelected()) {
            this.isBoxWhisker = false;
            this.isBar = false;
            this.errBar = false;
        } else if (this.errorRadioButton.isSelected()) {
            this.isBoxWhisker = false;
            this.isBar = true;
            this.errBar = true;
        } else {
            this.isBoxWhisker = false;
            this.isBar = true;
            this.errBar = false;
        }
        this.updateChart();
    }

    void noErrRadioButton_actionPerformed(ActionEvent e) {
        this.updateBarStyle();
    }

    void errorRadioButton_actionPerformed(ActionEvent e) {
        this.updateBarStyle();
    }

    void deviationRadioButton_actionPerformed(ActionEvent e) {
        this.updateBarStyle();
    }

    void boxWhiskerRadioButton_actionPerformed(ActionEvent e) {
        this.updateBarStyle();
    }

    @Override
    public JComponent getMainComponent() {
        return this.chartPanel;
    }
}

