/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.maizegenetics.analysis.chart.BarChartPanel;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.ChartDisplayPlugin;
import net.maizegenetics.analysis.chart.HistogramPanel;
import net.maizegenetics.analysis.chart.PieChartPanel;
import net.maizegenetics.analysis.chart.XYScatterPanel;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.ChartEditorManager;

public class BasicGraphFrame
extends JFrame {
    ChartDisplayPlugin theChartDisplayPlugin;
    BorderLayout borderLayout1 = new BorderLayout();
    TableReport theTable;
    JComboBox graphTypeComboBox = new JComboBox<String>(ChartDisplayPlugin.getPossibleCharts());
    JLabel jLabel1 = new JLabel();
    JPanel headerPanel = new JPanel();
    JButton saveButton = new JButton();
    JButton propertyButton = new JButton();
    BasicChartPanel chartPanel;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JFileChooser theFileChooser;

    public BasicGraphFrame(ChartDisplayPlugin cdp, TableReport theTable) {
        this.theTable = theTable;
        this.theChartDisplayPlugin = cdp;
        try {
            this.jbInit();
            this.chartPanel = new HistogramPanel(theTable);
            this.getContentPane().add((Component)this.chartPanel, "Center");
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.headerPanel.setMinimumSize(new Dimension(396, 29));
        this.headerPanel.setLayout(this.gridBagLayout1);
        this.propertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicGraphFrame.this.propertyButton_actionPerformed(e);
            }
        });
        this.graphTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicGraphFrame.this.graphTypeComboBox_actionPerformed(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                BasicGraphFrame.this.this_windowClosed(e);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicGraphFrame.this.saveButton_actionPerformed(e);
            }
        });
        this.headerPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 144), 26, 11));
        this.headerPanel.add((Component)this.graphTypeComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 105, 0, 0), 132, 0));
        this.headerPanel.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 7, 0, 0), 2, 0));
        this.headerPanel.add((Component)this.propertyButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 2, 1));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jLabel1.setText("Graph Type:");
        this.saveButton.setText("Save");
        this.propertyButton.setText("Properties");
        this.getContentPane().add((Component)this.headerPanel, "North");
    }

    void graphTypeComboBox_actionPerformed(ActionEvent e) {
        ChartDisplayPlugin.ChartType ct = ChartDisplayPlugin.ChartType.valueOf((String)this.graphTypeComboBox.getSelectedItem());
        this.getContentPane().remove(this.chartPanel);
        switch (ct) {
            case Histogram: {
                this.chartPanel = new HistogramPanel(this.theTable);
                break;
            }
            case XYScatter: {
                this.chartPanel = new XYScatterPanel(this.theTable);
                break;
            }
            case BarChart: {
                this.chartPanel = new BarChartPanel(this.theTable);
                break;
            }
            case PieChart: {
                this.chartPanel = new PieChartPanel(this.theTable);
            }
        }
        this.getContentPane().add((Component)this.chartPanel, "Center");
        this.pack();
    }

    void propertyButton_actionPerformed(ActionEvent e) {
        ChartEditor panel = ChartEditorManager.getChartEditor((JFreeChart)this.chartPanel.getChart());
        int result = JOptionPane.showConfirmDialog(this, panel, "Chart Properties", 2, -1);
        if (result == 0) {
            panel.updateChart(this.chartPanel.getChart());
        }
    }

    void this_windowClosed(WindowEvent e) {
        System.exit(0);
    }

    void saveButton_actionPerformed(ActionEvent e) {
        this.theChartDisplayPlugin.saveDataToFile(this.chartPanel.getMainComponent());
    }
}

