/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.TableReportPieDataset;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.PieDataset;

public class PieChartPanel
extends BasicChartPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    PieDataset dataset;
    ChartPanel chartPanel;
    TableReport theTable;
    JPanel controlPanel = new JPanel();
    JLabel jLabel2 = new JLabel();
    String[] columnNames;
    int bins = 5;
    JComboBox categoryComboBox;
    JCheckBox threeDCheckBox = new JCheckBox();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public PieChartPanel(TableReport theTable) {
        this.theTable = theTable;
        try {
            Object[] colNames = theTable.getTableColumnNames();
            this.columnNames = new String[colNames.length + 1];
            this.columnNames[0] = "None";
            for (int i = 1; i < this.columnNames.length; ++i) {
                this.columnNames[i] = (String)colNames[i - 1];
            }
            this.dataset = null;
            this.chart = this.createChart(this.dataset, false);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(500, 270));
            this.chartPanel.setMouseZoomable(true, false);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.categoryComboBox = new JComboBox<String>(this.columnNames);
        this.setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.gridBagLayout1);
        this.jLabel2.setText("Category");
        this.controlPanel.setMinimumSize(new Dimension(394, 50));
        this.controlPanel.setPreferredSize(new Dimension(394, 50));
        this.categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PieChartPanel.this.categoryComboBox_actionPerformed(e);
            }
        });
        this.threeDCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PieChartPanel.this.threeDCheckBox_actionPerformed(e);
            }
        });
        this.threeDCheckBox.setOpaque(true);
        this.threeDCheckBox.setText("3-D");
        this.add((Component)this.chartPanel, "Center");
        this.add((Component)this.controlPanel, "North");
        this.controlPanel.add((Component)this.categoryComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 0, 28, 0), 120, 0));
        this.controlPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 28, 0), 7, -1));
        this.controlPanel.add((Component)this.threeDCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 59, 28, 55), 45, -7));
    }

    PieDataset createDataset(int categoryColumn) {
        TableReportPieDataset dataset = new TableReportPieDataset(this.theTable, categoryColumn);
        return dataset;
    }

    JFreeChart createChart(PieDataset dataset, boolean is3D) {
        String chartName = "TEST";
        String categoryName = "CHOOSE CATEGORY";
        try {
            categoryName = (String)this.categoryComboBox.getSelectedItem();
            chartName = "Frequency of " + categoryName;
        }
        catch (Exception ex) {
            System.out.println("Pie chart labels not ready");
            chartName = "Please choose a categorical variable";
            categoryName = "Unknown";
        }
        this.chart = is3D ? ChartFactory.createPieChart3D((String)chartName, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createPieChart((String)chartName, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        return this.chart;
    }

    void updateChart() {
        int categorySeries = this.categoryComboBox.getSelectedIndex() - 1;
        boolean is3D = this.threeDCheckBox.isSelected();
        if (categorySeries > -1) {
            this.dataset = this.createDataset(categorySeries);
            this.chart = this.createChart(this.dataset, is3D);
            this.chartPanel.setChart(this.chart);
        }
    }

    void categoryComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void threeDCheckBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    @Override
    public JComponent getMainComponent() {
        return this.chartPanel;
    }
}

